/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.camera;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.location.Location;
import android.media.Image;
import android.media.ImageReader;
import android.provider.MediaStore;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.RequiresApi;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IPreviewDataCallBack;
import com.jiangdg.ausbc.camera.Camera2Strategy;
import com.jiangdg.ausbc.camera.ICameraStrategy;
import com.jiangdg.ausbc.camera.bean.CameraInfo;
import com.jiangdg.ausbc.camera.bean.CameraRequest;
import com.jiangdg.ausbc.camera.bean.CameraStatus;
import com.jiangdg.ausbc.camera.bean.CameraV2Info;
import com.jiangdg.ausbc.camera.bean.PreviewSize;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.SettableFuture;
import com.jiangdg.ausbc.utils.Utils;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Deprecated since version 3.3.0")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00af\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0003JMP\b\u0007\u0018\u0000 W2\u00020\u0001:\u0001WB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020!H\u0014J\b\u0010#\u001a\u00020!H\u0014J\u0012\u0010$\u001a\u00020!2\b\u0010%\u001a\u0004\u0018\u00010\u0014H\u0014J\u0012\u0010&\u001a\u00020!2\b\u0010'\u001a\u0004\u0018\u00010\u0014H\u0014J\u0018\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0014J\u001d\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\b\u0010/\u001a\u0004\u0018\u000100H\u0016\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020!H\u0003J\b\u00103\u001a\u00020!H\u0002J\b\u00104\u001a\u00020!H\u0002J\b\u00105\u001a\u00020!H\u0002J\b\u00106\u001a\u00020!H\u0002J\b\u00107\u001a\u00020!H\u0002J\b\u00108\u001a\u00020!H\u0002J\b\u00109\u001a\u00020!H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010\u00102\u0006\u0010;\u001a\u00020\u0014H\u0002J,\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00102\n\u0010?\u001a\u0006\u0012\u0002\b\u00030@2\u0006\u0010A\u001a\u00020*2\u0006\u0010B\u001a\u00020*H\u0002J-\u0010<\u001a\u00020=2\u000e\u0010C\u001a\n\u0012\u0004\u0012\u00020=\u0018\u00010D2\u0006\u0010A\u001a\u00020*2\u0006\u0010B\u001a\u00020*H\u0002\u00a2\u0006\u0002\u0010EJ\u0018\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u00020\u00102\u0006\u0010H\u001a\u00020*H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010I\u001a\u00020JX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010KR\u0010\u0010L\u001a\u00020MX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010NR\u0010\u0010O\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010QR\u000e\u0010R\u001a\u00020SX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010T\u001a\u00020SX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\bU\u0010V\u00a8\u0006X"}, d2={"Lcom/jiangdg/ausbc/camera/Camera2Strategy;", "Lcom/jiangdg/ausbc/camera/ICameraStrategy;", "ctx", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "mCaptureResults", "Ljava/util/concurrent/BlockingQueue;", "Landroid/hardware/camera2/CaptureResult;", "mImageCaptureBuilder", "Landroid/hardware/camera2/CaptureRequest$Builder;", "mPreviewCaptureBuilder", "mCameraDeviceFuture", "Lcom/jiangdg/ausbc/utils/SettableFuture;", "Landroid/hardware/camera2/CameraDevice;", "mCameraCharacteristicsFuture", "Landroid/hardware/camera2/CameraCharacteristics;", "mCameraSessionFuture", "Landroid/hardware/camera2/CameraCaptureSession;", "mImageSavePath", "", "mPreviewDataImageReader", "Landroid/media/ImageReader;", "mJpegImageReader", "mPreviewSurface", "Landroid/view/Surface;", "mPreviewDataSurface", "mJpegDataSurface", "mCameraManager", "Landroid/hardware/camera2/CameraManager;", "mYUVData", "", "loadCameraInfo", "", "startPreviewInternal", "stopPreviewInternal", "captureImageInternal", "savePath", "switchCameraInternal", "cameraId", "updateResolutionInternal", "width", "", "height", "getAllPreviewSizes", "", "Lcom/jiangdg/ausbc/camera/bean/PreviewSize;", "aspectRatio", "", "(Ljava/lang/Double;)Ljava/util/List;", "openCamera", "createCaptureRequestBuilders", "setPreviewSize", "setImageSize", "createSession", "realStartPreview", "closeSession", "closeCamera", "getCameraCharacteristics", "id", "getSuitableSize", "Landroid/util/Size;", "cameraCharacteristics", "clazz", "Ljava/lang/Class;", "maxWidth", "maxHeight", "sizeList", "", "([Landroid/util/Size;II)Landroid/util/Size;", "getJpegOrientation", "characteristics", "deviceOrientation", "mCameraStateCallBack", "com/jiangdg/ausbc/camera/Camera2Strategy$mCameraStateCallBack$1", "Lcom/jiangdg/ausbc/camera/Camera2Strategy$mCameraStateCallBack$1;", "mCreateSessionStateCallBack", "com/jiangdg/ausbc/camera/Camera2Strategy$mCreateSessionStateCallBack$1", "Lcom/jiangdg/ausbc/camera/Camera2Strategy$mCreateSessionStateCallBack$1;", "mImageCaptureStateCallBack", "com/jiangdg/ausbc/camera/Camera2Strategy$mImageCaptureStateCallBack$1", "Lcom/jiangdg/ausbc/camera/Camera2Strategy$mImageCaptureStateCallBack$1;", "mPreviewAvailableListener", "Landroid/media/ImageReader$OnImageAvailableListener;", "mJpegAvailableListener", "getMJpegAvailableListener$annotations", "()V", "Companion", "libausbc_release"})
@RequiresApi(value=21)
@SourceDebugExtension(value={"SMAP\nCamera2Strategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Camera2Strategy.kt\ncom/jiangdg/ausbc/camera/Camera2Strategy\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,624:1\n13409#2:625\n13409#2,2:626\n13410#2:628\n13409#2,2:634\n1863#3,2:629\n1863#3,2:632\n1863#3,2:636\n1#4:631\n*S KotlinDebug\n*F\n+ 1 Camera2Strategy.kt\ncom/jiangdg/ausbc/camera/Camera2Strategy\n*L\n76#1:625\n92#1:626,2\n76#1:628\n436#1:634,2\n191#1:629,2\n410#1:632,2\n564#1:636,2\n*E\n"})
public final class Camera2Strategy
extends ICameraStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockingQueue<CaptureResult> mCaptureResults;
    @Nullable
    private CaptureRequest.Builder mImageCaptureBuilder;
    @Nullable
    private CaptureRequest.Builder mPreviewCaptureBuilder;
    @Nullable
    private SettableFuture<CameraDevice> mCameraDeviceFuture;
    @Nullable
    private SettableFuture<CameraCharacteristics> mCameraCharacteristicsFuture;
    @Nullable
    private SettableFuture<CameraCaptureSession> mCameraSessionFuture;
    @NotNull
    private SettableFuture<String> mImageSavePath;
    @Nullable
    private ImageReader mPreviewDataImageReader;
    @Nullable
    private ImageReader mJpegImageReader;
    @Nullable
    private Surface mPreviewSurface;
    @Nullable
    private Surface mPreviewDataSurface;
    @Nullable
    private Surface mJpegDataSurface;
    @Nullable
    private CameraManager mCameraManager;
    @Nullable
    private byte[] mYUVData;
    @NotNull
    private final mCameraStateCallBack.1 mCameraStateCallBack;
    @NotNull
    private final mCreateSessionStateCallBack.1 mCreateSessionStateCallBack;
    @NotNull
    private final mImageCaptureStateCallBack.1 mImageCaptureStateCallBack;
    @NotNull
    private final ImageReader.OnImageAvailableListener mPreviewAvailableListener;
    @NotNull
    private final ImageReader.OnImageAvailableListener mJpegAvailableListener;
    @NotNull
    private static final String TAG = "CameraV2";

    public Camera2Strategy(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(ctx);
        this.mCaptureResults = new LinkedBlockingDeque();
        this.mImageSavePath = new SettableFuture();
        this.mCameraStateCallBack = new CameraDevice.StateCallback(this){
            final /* synthetic */ Camera2Strategy this$0;
            {
                this.this$0 = $receiver;
            }

            public void onOpened(CameraDevice camera) {
                Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
                SettableFuture settableFuture = Camera2Strategy.access$getMCameraDeviceFuture$p(this.this$0);
                if (settableFuture != null) {
                    settableFuture.set(camera);
                }
                SettableFuture settableFuture2 = Camera2Strategy.access$getMCameraCharacteristicsFuture$p(this.this$0);
                if (settableFuture2 != null) {
                    String string = camera.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    settableFuture2.set(Camera2Strategy.access$getCameraCharacteristics(this.this$0, string));
                }
                Logger.INSTANCE.i("CameraV2", "connect camera success in callback.");
            }

            public void onDisconnected(CameraDevice camera) {
                Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
                SettableFuture settableFuture = Camera2Strategy.access$getMCameraDeviceFuture$p(this.this$0);
                if (settableFuture != null) {
                    settableFuture.set(camera);
                }
                this.this$0.stopPreviewInternal();
                Logger.INSTANCE.i("CameraV2", "disconnect camera success in callback.");
            }

            public void onError(CameraDevice camera, int error) {
                Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
                SettableFuture settableFuture = Camera2Strategy.access$getMCameraDeviceFuture$p(this.this$0);
                if (settableFuture != null) {
                    settableFuture.set(camera);
                }
                this.this$0.stopPreviewInternal();
                Logger.INSTANCE.i("CameraV2", "connect camera err = (" + error + ") in callback.");
            }
        };
        this.mCreateSessionStateCallBack = new CameraCaptureSession.StateCallback(this){
            final /* synthetic */ Camera2Strategy this$0;
            {
                this.this$0 = $receiver;
            }

            public void onConfigured(CameraCaptureSession session) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    Logger.INSTANCE.i("CameraV2", "configure session success in callback!");
                    SettableFuture settableFuture = Camera2Strategy.access$getMCameraSessionFuture$p(this.this$0);
                    if (settableFuture == null) break block0;
                    settableFuture.set(session);
                }
            }

            public void onConfigureFailed(CameraCaptureSession session) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    Logger.INSTANCE.i("CameraV2", "configure session failed in callback!");
                    SettableFuture settableFuture = Camera2Strategy.access$getMCameraSessionFuture$p(this.this$0);
                    if (settableFuture == null) break block0;
                    settableFuture.set(session);
                }
            }
        };
        this.mImageCaptureStateCallBack = new CameraCaptureSession.CaptureCallback(this){
            final /* synthetic */ Camera2Strategy this$0;
            {
                this.this$0 = $receiver;
            }

            public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                super.onCaptureStarted(session, request, timestamp, frameNumber);
                this.this$0.getMMainHandler().post(() -> mImageCaptureStateCallBack.1.onCaptureStarted$lambda$0(this.this$0));
            }

            public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                super.onCaptureCompleted(session, request, result);
                Camera2Strategy.access$getMCaptureResults$p(this.this$0).put(result);
            }

            private static final void onCaptureStarted$lambda$0(Camera2Strategy this$0) {
                block0: {
                    ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
                    if (iCaptureCallBack == null) break block0;
                    iCaptureCallBack.onBegin();
                }
            }
        };
        this.mPreviewAvailableListener = arg_0 -> Camera2Strategy.mPreviewAvailableListener$lambda$33(this, arg_0);
        this.mJpegAvailableListener = arg_0 -> Camera2Strategy.mJpegAvailableListener$lambda$38(this, arg_0);
    }

    @Override
    protected void loadCameraInfo() {
        block6: {
            CameraManager cameraManager;
            Context context = this.getContext();
            Object object = context != null ? context.getSystemService("camera") : null;
            CameraManager cameraManager2 = this.mCameraManager = object instanceof CameraManager ? (CameraManager)object : null;
            if (cameraManager2 == null) break block6;
            CameraManager $this$loadCameraInfo_u24lambda_u244 = cameraManager = cameraManager2;
            boolean bl = false;
            String[] stringArray = $this$loadCameraInfo_u24lambda_u244.getCameraIdList();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getCameraIdList(...)");
            Object[] $this$forEach$iv = stringArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CameraV2Info cameraV2Info;
                Size[] sizeList;
                StreamConfigurationMap streamConfigurationMap;
                int n;
                CameraCharacteristics characteristics;
                Integer n2;
                String cameraId = (String)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$loadCameraInfo_u24lambda_u244.getCameraCharacteristics(cameraId), (String)"getCameraCharacteristics(...)");
                Integer n3 = n2 = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                if (n3 != null && n3 == 0) {
                    n = 0;
                } else {
                    Integer n4 = n2;
                    int n5 = 1;
                    n = n4 != null && n4 == n5 ? 1 : 2;
                }
                int type = n;
                boolean bl3 = false;
                List list = new ArrayList();
                StreamConfigurationMap streamConfigurationMap2 = streamConfigurationMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                Object object2 = sizeList = streamConfigurationMap2 != null ? streamConfigurationMap2.getOutputSizes(SurfaceTexture.class) : null;
                if (sizeList != null) {
                    Size[] $this$forEach$iv2 = sizeList;
                    boolean $i$f$forEach2 = false;
                    int n6 = $this$forEach$iv2.length;
                    for (int i = 0; i < n6; ++i) {
                        Size element$iv2;
                        Size it = element$iv2 = $this$forEach$iv2[i];
                        boolean bl4 = false;
                        list.add(new PreviewSize(it.getWidth(), it.getHeight()));
                    }
                }
                if (this.getMCameraInfoMap().get(type) != null) continue;
                Intrinsics.checkNotNull((Object)cameraId);
                CameraV2Info $this$loadCameraInfo_u24lambda_u244_u24lambda_u243_u24lambda_u242_u24lambda_u241 = cameraV2Info = new CameraV2Info(cameraId);
                boolean bl5 = false;
                $this$loadCameraInfo_u24lambda_u244_u24lambda_u243_u24lambda_u242_u24lambda_u241.setCameraType(type);
                $this$loadCameraInfo_u24lambda_u244_u24lambda_u243_u24lambda_u242_u24lambda_u241.setCameraPreviewSizes(list);
                $this$loadCameraInfo_u24lambda_u244_u24lambda_u243_u24lambda_u242_u24lambda_u241.setCameraCharacteristics(characteristics);
                $this$loadCameraInfo_u24lambda_u244_u24lambda_u243_u24lambda_u242_u24lambda_u241.setCameraVid(Integer.parseInt(cameraId) + 1);
                $this$loadCameraInfo_u24lambda_u244_u24lambda_u243_u24lambda_u242_u24lambda_u241.setCameraPid(Integer.parseInt(cameraId) + 1);
                CameraV2Info cameraInfo = cameraV2Info;
                Integer n7 = type;
                ((Map)this.getMCameraInfoMap()).put(n7, cameraInfo);
            }
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "loadCameraInfo success, camera = " + this.getMCameraInfoMap());
            }
        }
    }

    @Override
    protected void startPreviewInternal() {
        this.openCamera();
        this.createCaptureRequestBuilders();
        this.setPreviewSize();
        this.setImageSize();
        this.createSession();
        this.realStartPreview();
    }

    @Override
    protected void stopPreviewInternal() {
        this.closeSession();
        this.closeCamera();
    }

    @Override
    protected void captureImageInternal(@Nullable String savePath) {
        if (!this.hasCameraPermission() || !this.hasStoragePermission()) {
            this.getMMainHandler().post(() -> Camera2Strategy.captureImageInternal$lambda$5(this));
            Logger.INSTANCE.i(TAG, "takePictureInternal failed, has no storage/camera permission.");
            return;
        }
        SettableFuture<CameraCaptureSession> settableFuture = this.mCameraSessionFuture;
        CameraCaptureSession cameraSession = settableFuture != null ? settableFuture.get(3L, TimeUnit.SECONDS) : null;
        SettableFuture<CameraCharacteristics> settableFuture2 = this.mCameraCharacteristicsFuture;
        CameraCharacteristics characteristics = settableFuture2 != null ? settableFuture2.get(3L, TimeUnit.SECONDS) : null;
        CaptureRequest.Builder captureBuilder = this.mImageCaptureBuilder;
        Surface jpegSurface = this.mJpegDataSurface;
        if (cameraSession == null || characteristics == null || captureBuilder == null || jpegSurface == null) {
            this.getMMainHandler().post(() -> Camera2Strategy.captureImageInternal$lambda$6(this));
            Logger.INSTANCE.e(TAG, "takePictureInternal failed, camera init error.");
            return;
        }
        try {
            CaptureRequest.Builder it = captureBuilder;
            boolean bl = false;
            int deviceOrientation = this.getDeviceOrientation();
            int jpegOrientation = this.getJpegOrientation(characteristics, deviceOrientation);
            Location location = Utils.INSTANCE.getGpsLocation(this.getContext());
            captureBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)jpegOrientation);
            captureBuilder.set(CaptureRequest.JPEG_GPS_LOCATION, (Object)location);
            captureBuilder.set(CaptureRequest.JPEG_QUALITY, (Object)100);
            captureBuilder.addTarget(jpegSurface);
            CaptureRequest captureRequest = captureBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)captureRequest, (String)"let(...)");
            CaptureRequest captureRequest2 = captureRequest;
            this.mImageSavePath.set(savePath);
            cameraSession.capture(captureRequest2, (CameraCaptureSession.CaptureCallback)this.mImageCaptureStateCallBack, this.getMMainHandler());
        }
        catch (Exception e) {
            this.getMMainHandler().post(() -> Camera2Strategy.captureImageInternal$lambda$8(this, e));
            Logger.INSTANCE.e(TAG, "takePictureInternal failed, camera access error.", e);
        }
    }

    @Override
    protected void switchCameraInternal(@Nullable String cameraId) {
        block0: {
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest == null) break block0;
            CameraRequest request = cameraRequest;
            boolean bl = false;
            request.setFrontCamera(!request.isFrontCamera());
            this.stopPreviewInternal();
            this.startPreviewInternal();
        }
    }

    @Override
    protected void updateResolutionInternal(int width, int height) {
        block0: {
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest == null) break block0;
            CameraRequest request = cameraRequest;
            boolean bl = false;
            request.setPreviewWidth(width);
            request.setPreviewHeight(height);
            this.stopPreviewInternal();
            this.startPreviewInternal();
        }
    }

    @Override
    @NotNull
    public List<PreviewSize> getAllPreviewSizes(@Nullable Double aspectRatio) {
        List list = new ArrayList();
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            CameraInfo cameraInfo;
            Object object;
            Object v2;
            block4: {
                CameraRequest request = cameraRequest;
                boolean bl = false;
                Collection<CameraInfo> collection = this.getMCameraInfoMap().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable iterable = collection;
                for (Object object2 : iterable) {
                    CameraInfo it = (CameraInfo)object2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)request.getCameraId(), (Object)it.getCameraId())) continue;
                    v2 = object2;
                    break block4;
                }
                v2 = null;
            }
            if ((object = (cameraInfo = (CameraInfo)v2)) != null && (object = ((CameraInfo)object).getCameraPreviewSizes()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PreviewSize size = (PreviewSize)element$iv;
                    boolean bl = false;
                    int width = size.getWidth();
                    int height = size.getHeight();
                    double ratio = (double)width / (double)height;
                    if (aspectRatio != null && !Intrinsics.areEqual((double)ratio, (Double)aspectRatio)) continue;
                    list.add(size);
                }
            }
        }
        Logger.INSTANCE.i(TAG, "getAllPreviewSizes aspect ratio = " + aspectRatio + ", list= " + list);
        return list;
    }

    @SuppressLint(value={"MissingPermission"})
    private final void openCamera() {
        block6: {
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest == null) break block6;
            CameraRequest request = cameraRequest;
            boolean bl = false;
            this.mCameraDeviceFuture = new SettableFuture();
            this.mCameraCharacteristicsFuture = new SettableFuture();
            try {
                String string;
                if (!this.hasCameraPermission()) {
                    Logger.INSTANCE.e(TAG, "openCamera failed, has no camera permission.");
                    break block6;
                }
                if (this.mCameraManager == null) {
                    Logger.INSTANCE.e(TAG, "init camera manager failed, is null!");
                    break block6;
                }
                if (request.isFrontCamera()) {
                    CameraInfo cameraInfo = this.getMCameraInfoMap().get(0);
                    Intrinsics.checkNotNull((Object)cameraInfo);
                    string = cameraInfo.getCameraId();
                } else {
                    CameraInfo cameraInfo = this.getMCameraInfoMap().get(1);
                    Intrinsics.checkNotNull((Object)cameraInfo);
                    string = cameraInfo.getCameraId();
                }
                String cameraId = string;
                request.setCameraId(cameraId);
                CameraManager cameraManager = this.mCameraManager;
                Intrinsics.checkNotNull((Object)cameraManager);
                cameraManager.openCamera(cameraId, (CameraDevice.StateCallback)this.mCameraStateCallBack, this.getMMainHandler());
                Logger.INSTANCE.i(TAG, "openCamera success, id = " + cameraId + '.');
            }
            catch (CameraAccessException e) {
                this.closeCamera();
                Logger.INSTANCE.e(TAG, "openCamera failed, err = " + e.getReason() + '.', e);
            }
        }
    }

    private final void createCaptureRequestBuilders() {
        try {
            CameraDevice cameraDevice;
            SettableFuture<CameraDevice> settableFuture = this.mCameraDeviceFuture;
            CameraDevice cameraDevice2 = cameraDevice = settableFuture != null ? settableFuture.get(3L, TimeUnit.SECONDS) : null;
            if (cameraDevice == null) {
                Logger.INSTANCE.e(TAG, "createCaptureRequestBuilders failed, camera device is null.");
                return;
            }
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest != null) {
                CameraRequest it = cameraRequest;
                boolean bl = false;
                CaptureRequest.Builder builder = this.mPreviewCaptureBuilder = cameraDevice.createCaptureRequest(1);
                if (builder != null) {
                    builder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                }
                CaptureRequest.Builder builder2 = this.mPreviewCaptureBuilder;
                if (builder2 != null) {
                    builder2.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                }
                this.mImageCaptureBuilder = cameraDevice.createCaptureRequest(2);
                Logger.INSTANCE.i(TAG, "createCaptureRequestBuilders success.");
            }
        }
        catch (CameraAccessException e) {
            Logger.INSTANCE.e(TAG, "createCaptureRequestBuilders failed, err = " + e.getReason(), e);
        }
    }

    private final void setPreviewSize() {
        block5: {
            StreamConfigurationMap streamConfigurationMap;
            Surface previewSurface;
            Object object;
            CameraCharacteristics characteristics;
            SettableFuture<CameraCharacteristics> settableFuture = this.mCameraCharacteristicsFuture;
            CameraCharacteristics cameraCharacteristics = characteristics = settableFuture != null ? settableFuture.get(3L, TimeUnit.SECONDS) : null;
            if (this.getSurfaceTexture() != null) {
                object = new Surface(this.getSurfaceTexture());
            } else {
                SurfaceHolder surfaceHolder = this.getSurfaceHolder();
                object = previewSurface = surfaceHolder != null ? surfaceHolder.getSurface() : null;
            }
            if (characteristics == null || previewSurface == null) {
                Logger.INSTANCE.e(TAG, "setPreviewSize failed. Camera characteristics is null.");
                return;
            }
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest == null) break block5;
            CameraRequest request = cameraRequest;
            boolean bl = false;
            int maxWidth = request.getPreviewWidth();
            int maxHeight = request.getPreviewHeight();
            Size previewSize = this.getSuitableSize(characteristics, SurfaceTexture.class, maxWidth, maxHeight);
            this.mPreviewSurface = previewSurface;
            request.setPreviewWidth(previewSize.getWidth());
            request.setPreviewHeight(previewSize.getHeight());
            this.mYUVData = new byte[request.getPreviewWidth() * request.getPreviewHeight() * 3 / 2];
            int imageFormat = 35;
            StreamConfigurationMap streamConfigurationMap2 = streamConfigurationMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            boolean bl2 = streamConfigurationMap2 != null ? streamConfigurationMap2.isOutputSupportedFor(imageFormat) : false;
            if (bl2) {
                ImageReader imageReader = this.mPreviewDataImageReader = ImageReader.newInstance((int)previewSize.getWidth(), (int)previewSize.getHeight(), (int)imageFormat, (int)3);
                if (imageReader != null) {
                    imageReader.setOnImageAvailableListener(this.mPreviewAvailableListener, this.getCameraHandler());
                }
                ImageReader imageReader2 = this.mPreviewDataImageReader;
                this.mPreviewDataSurface = imageReader2 != null ? imageReader2.getSurface() : null;
            }
            Logger.INSTANCE.i(TAG, "setPreviewSize success, size = " + previewSize + '.');
        }
    }

    private final void setImageSize() {
        block3: {
            SettableFuture<CameraCharacteristics> settableFuture = this.mCameraCharacteristicsFuture;
            CameraCharacteristics characteristics = settableFuture != null ? settableFuture.get(3L, TimeUnit.SECONDS) : null;
            CaptureRequest.Builder captureBuilder = this.mImageCaptureBuilder;
            if (characteristics == null) {
                Logger.INSTANCE.e(TAG, "setImageSize failed. Camera characteristics is null.");
                return;
            }
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest == null) break block3;
            CameraRequest request = cameraRequest;
            boolean bl = false;
            int maxWidth = request.getPreviewWidth();
            int maxHeight = request.getPreviewHeight();
            Size imageSize = this.getSuitableSize(characteristics, ImageReader.class, maxWidth, maxHeight);
            ImageReader imageReader = this.mJpegImageReader = ImageReader.newInstance((int)imageSize.getWidth(), (int)imageSize.getHeight(), (int)256, (int)5);
            if (imageReader != null) {
                imageReader.setOnImageAvailableListener(this.mJpegAvailableListener, this.getCameraHandler());
            }
            ImageReader imageReader2 = this.mJpegImageReader;
            this.mJpegDataSurface = imageReader2 != null ? imageReader2.getSurface() : null;
            request.setPreviewWidth(imageSize.getWidth());
            request.setPreviewHeight(imageSize.getHeight());
            CaptureRequest.Builder builder = captureBuilder;
            if (builder != null) {
                CaptureRequest.Builder it = builder;
                boolean bl2 = false;
                Size[] availableThumbnailSizes = (Size[])characteristics.get(CameraCharacteristics.JPEG_AVAILABLE_THUMBNAIL_SIZES);
                Size thumbnailSize = this.getSuitableSize(availableThumbnailSizes, maxWidth, maxHeight);
                captureBuilder.set(CaptureRequest.JPEG_THUMBNAIL_SIZE, (Object)thumbnailSize);
            }
            Logger.INSTANCE.i(TAG, "setImageSize success, size = " + imageSize + '.');
        }
    }

    private final void createSession() {
        try {
            Surface it;
            List list;
            CameraDevice cameraDevice;
            SettableFuture<CameraDevice> settableFuture = this.mCameraDeviceFuture;
            CameraDevice cameraDevice2 = cameraDevice = settableFuture != null ? settableFuture.get(3L, TimeUnit.SECONDS) : null;
            if (cameraDevice == null) {
                Logger.INSTANCE.e(TAG, "realStartPreview failed, camera init failed.");
                this.stopPreviewInternal();
                return;
            }
            this.mCameraSessionFuture = new SettableFuture();
            List $this$createSession_u24lambda_u2422 = list = (List)new ArrayList();
            boolean bl = false;
            Surface surface = this.mPreviewSurface;
            if (surface != null) {
                it = surface;
                boolean bl2 = false;
                $this$createSession_u24lambda_u2422.add(it);
            }
            Surface surface2 = this.mPreviewDataSurface;
            if (surface2 != null) {
                it = surface2;
                boolean bl3 = false;
                $this$createSession_u24lambda_u2422.add(it);
            }
            Surface surface3 = this.mJpegDataSurface;
            if (surface3 != null) {
                it = surface3;
                boolean bl4 = false;
                $this$createSession_u24lambda_u2422.add(it);
            }
            List outputs = list;
            cameraDevice.createCaptureSession(outputs, (CameraCaptureSession.StateCallback)this.mCreateSessionStateCallBack, this.getMMainHandler());
            Logger.INSTANCE.i(TAG, "createSession, outputs = " + outputs.size());
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, "createCaptureSession failed, err = " + e.getLocalizedMessage(), e);
        }
    }

    private final void realStartPreview() {
        CaptureRequest captureRequest;
        CaptureRequest captureRequest2;
        Surface surface;
        CaptureRequest.Builder builder;
        CameraCaptureSession cameraSession;
        SettableFuture<CameraDevice> settableFuture = this.mCameraDeviceFuture;
        CameraDevice cameraDevice = settableFuture != null ? settableFuture.get(3L, TimeUnit.SECONDS) : null;
        SettableFuture<CameraCaptureSession> settableFuture2 = this.mCameraSessionFuture;
        CameraCaptureSession cameraCaptureSession = cameraSession = settableFuture2 != null ? settableFuture2.get(3L, TimeUnit.SECONDS) : null;
        if (cameraDevice == null || cameraSession == null) {
            Logger.INSTANCE.e(TAG, "realStartPreview failed, camera init failed.");
            this.stopPreviewInternal();
            this.postCameraStatus(new CameraStatus(-1, "camera init failed"));
            return;
        }
        Surface surface2 = this.mPreviewSurface;
        Intrinsics.checkNotNull((Object)surface2);
        Surface previewSurface = surface2;
        Surface previewDataSurface = this.mPreviewDataSurface;
        CaptureRequest.Builder builder2 = this.mImageCaptureBuilder;
        if (builder2 != null) {
            builder = builder2;
            boolean bl = false;
            builder.addTarget(previewSurface);
            Surface surface3 = previewDataSurface;
            if (surface3 != null) {
                Surface $this$realStartPreview_u24lambda_u2424_u24lambda_u2423 = surface = surface3;
                boolean bl2 = false;
                builder.addTarget($this$realStartPreview_u24lambda_u2424_u24lambda_u2423);
            }
        }
        CaptureRequest.Builder builder3 = this.mPreviewCaptureBuilder;
        if (builder3 != null) {
            builder = builder3;
            boolean bl = false;
            Surface surface4 = previewDataSurface;
            if (surface4 != null) {
                Surface $this$realStartPreview_u24lambda_u2426_u24lambda_u2425 = surface = surface4;
                boolean bl3 = false;
                builder.addTarget($this$realStartPreview_u24lambda_u2426_u24lambda_u2425);
            }
            builder.addTarget(previewSurface);
            captureRequest2 = builder.build();
        } else {
            captureRequest2 = null;
        }
        CaptureRequest captureRequest3 = captureRequest = captureRequest2;
        boolean bl = false;
        if (captureRequest3 == null) {
            Logger.INSTANCE.e(TAG, "realStartPreview failed, captureRequest is null.");
            this.postCameraStatus(new CameraStatus(-1, "capture request is null"));
            return;
        }
        cameraSession.setRepeatingRequest(captureRequest3, null, this.getCameraHandler());
        this.getMIsPreviewing().set(true);
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            CameraRequest cameraRequest2;
            CameraRequest $this$realStartPreview_u24lambda_u2428_u24lambda_u2427 = cameraRequest2 = cameraRequest;
            boolean bl4 = false;
            this.postCameraStatus(new CameraStatus(1, new Pair((Object)$this$realStartPreview_u24lambda_u2428_u24lambda_u2427.getPreviewWidth(), (Object)$this$realStartPreview_u24lambda_u2428_u24lambda_u2427.getPreviewHeight()).toString()));
        }
        Logger.INSTANCE.i(TAG, "realStartPreview success!");
    }

    private final void closeSession() {
        CameraDevice cameraDevice;
        if (Utils.INSTANCE.getDebugCamera() && this.getMIsPreviewing().get()) {
            Logger.INSTANCE.i(TAG, "closeSession success.");
        }
        this.getMIsPreviewing().set(false);
        CameraCaptureSession cameraCaptureSession = this.mCameraSessionFuture;
        if (cameraCaptureSession != null && (cameraCaptureSession = cameraCaptureSession.get(10L, TimeUnit.MILLISECONDS)) != null) {
            cameraCaptureSession.close();
        }
        if ((cameraDevice = this.mCameraDeviceFuture) != null && (cameraDevice = cameraDevice.get(10L, TimeUnit.MILLISECONDS)) != null) {
            cameraDevice.close();
        }
        this.mCameraSessionFuture = null;
        this.mCameraDeviceFuture = null;
    }

    private final void closeCamera() {
        if (Utils.INSTANCE.getDebugCamera() && this.getMIsPreviewing().get()) {
            Logger.INSTANCE.i(TAG, "closeCamera success.");
        }
        ImageReader imageReader = this.mPreviewDataImageReader;
        if (imageReader != null) {
            imageReader.close();
        }
        this.mPreviewDataImageReader = null;
        ImageReader imageReader2 = this.mJpegImageReader;
        if (imageReader2 != null) {
            imageReader2.close();
        }
        this.mJpegImageReader = null;
        this.mCameraCharacteristicsFuture = null;
        this.postCameraStatus(new CameraStatus(2, null, 2, null));
    }

    private final CameraCharacteristics getCameraCharacteristics(String id2) {
        Collection<CameraInfo> collection = this.getMCameraInfoMap().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CameraInfo it = (CameraInfo)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.jiangdg.ausbc.camera.bean.CameraV2Info");
            CameraV2Info cameraInfo = (CameraV2Info)it;
            if (!Intrinsics.areEqual((Object)cameraInfo.getCameraId(), (Object)id2)) continue;
            return cameraInfo.getCameraCharacteristics();
        }
        return null;
    }

    private final Size getSuitableSize(CameraCharacteristics cameraCharacteristics, Class<?> clazz, int maxWidth, int maxHeight) {
        StreamConfigurationMap streamConfigurationMap;
        StreamConfigurationMap streamConfigurationMap2 = streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Size[] supportedSizes = streamConfigurationMap2 != null ? streamConfigurationMap2.getOutputSizes(clazz) : null;
        return this.getSuitableSize(supportedSizes, maxWidth, maxHeight);
    }

    private final Size getSuitableSize(Size[] sizeList, int maxWidth, int maxHeight) {
        Size[] sizeArray;
        block1: {
            float aspectRatio = (float)maxWidth / (float)maxHeight;
            if (sizeList == null) break block1;
            Size[] $this$forEach$iv = sizeList;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                int h;
                Size element$iv;
                Size size = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                int w = size.getWidth();
                float ratio = (float)w / (float)(h = size.getHeight());
                if (!(ratio == aspectRatio) || w > maxWidth || h > maxHeight) continue;
                return new Size(w, h);
            }
        }
        return (sizeArray = sizeList) == null || sizeArray.length == 0 ? new Size(maxWidth, maxHeight) : new Size(sizeList[0].getWidth(), sizeList[0].getHeight());
    }

    private final int getJpegOrientation(CameraCharacteristics characteristics, int deviceOrientation) {
        Integer cameraFacing;
        int myDeviceOrientation = deviceOrientation;
        if (myDeviceOrientation == -1) {
            return 0;
        }
        Object object = characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        Intrinsics.checkNotNull((Object)object);
        int sensorOrientation = ((Number)object).intValue();
        Integer n = cameraFacing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
        boolean facingFront = n != null && n == 0;
        myDeviceOrientation = (myDeviceOrientation + 45) / 90 * 90;
        if (facingFront) {
            myDeviceOrientation = -myDeviceOrientation;
        }
        return (sensorOrientation + myDeviceOrientation + 360) % 360;
    }

    private static /* synthetic */ void getMJpegAvailableListener$annotations() {
    }

    private static final void captureImageInternal$lambda$5(Camera2Strategy this$0) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onError("Have no storage or camera permission.");
        }
    }

    private static final void captureImageInternal$lambda$6(Camera2Strategy this$0) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onError("camera2 init failed.");
        }
    }

    private static final void captureImageInternal$lambda$8(Camera2Strategy this$0, Exception $e) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onError($e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void mPreviewAvailableListener$lambda$33(Camera2Strategy this$0, ImageReader imageReader) {
        Image image;
        ImageReader imageReader2 = imageReader;
        Image image2 = image = imageReader2 != null ? imageReader2.acquireNextImage() : null;
        if (image2 != null) {
            AutoCloseable autoCloseable = (AutoCloseable)image2;
            Throwable throwable = null;
            try {
                Image it = (Image)autoCloseable;
                boolean bl = false;
                CameraRequest request = this$0.getRequest();
                if (request == null) {
                    return;
                }
                byte[] byArray = this$0.mYUVData;
                if (this$0.mYUVData == null) {
                    return;
                }
                try {
                    int i;
                    int index;
                    Image.Plane[] planes = it.getPlanes();
                    ByteBuffer yBuffer = planes[0].getBuffer();
                    int yuv420pYLen = request.getPreviewWidth() * request.getPreviewHeight();
                    Intrinsics.checkNotNull((Object)this$0.mYUVData);
                    yBuffer.get(this$0.mYUVData, 0, yuv420pYLen);
                    ByteBuffer vBuffer = planes[2].getBuffer();
                    int vPixelStride = planes[2].getPixelStride();
                    IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)vBuffer.remaining())), (int)vPixelStride);
                    int n = intProgression.getFirst();
                    int n2 = intProgression.getLast();
                    int n3 = intProgression.getStep();
                    int n4 = 0;
                    if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                        while (true) {
                            index = n4++;
                            i = n;
                            Intrinsics.checkNotNull((Object)this$0.mYUVData);
                            this$0.mYUVData[yuv420pYLen + 2 * index] = vBuffer.get(i);
                            if (i == n2) break;
                            n += n3;
                        }
                    }
                    ByteBuffer uBuffer = planes[1].getBuffer();
                    int uPixelStride = planes[1].getPixelStride();
                    IntProgression intProgression2 = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)uBuffer.remaining())), (int)uPixelStride);
                    n3 = intProgression2.getFirst();
                    n4 = intProgression2.getLast();
                    index = intProgression2.getStep();
                    i = 0;
                    if (index > 0 && n3 <= n4 || index < 0 && n4 <= n3) {
                        while (true) {
                            int index2 = i++;
                            int i2 = n3;
                            Intrinsics.checkNotNull((Object)this$0.mYUVData);
                            this$0.mYUVData[yuv420pYLen + (2 * index2 + 1)] = uBuffer.get(i2);
                            if (i2 == n4) break;
                            n3 += index;
                        }
                    }
                    Iterable $this$forEach$iv = this$0.getMPreviewDataCbList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IPreviewDataCallBack cb = (IPreviewDataCallBack)element$iv;
                        boolean bl2 = false;
                        cb.onPreviewData(this$0.mYUVData, request.getPreviewWidth(), request.getPreviewHeight(), IPreviewDataCallBack.DataFormat.NV21);
                    }
                    it.close();
                }
                catch (IndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
    }

    private static final void mJpegAvailableListener$lambda$38$lambda$37$lambda$36$lambda$34(Camera2Strategy this$0) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onError("set path failed, save auto ");
        }
    }

    private static final void mJpegAvailableListener$lambda$38$lambda$37$lambda$36$lambda$35(Camera2Strategy this$0, String $path) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onComplete($path);
        }
    }

    private static final void mJpegAvailableListener$lambda$38$lambda$37$lambda$36(Camera2Strategy this$0, byte[] $jpegBufferArray) {
        String string;
        String displayName;
        String string2;
        String title;
        String savePath = null;
        try {
            savePath = this$0.mImageSavePath.get(3L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, "times out.", e);
            this$0.getMMainHandler().post(() -> Camera2Strategy.mJpegAvailableListener$lambda$38$lambda$37$lambda$36$lambda$34(this$0));
        }
        String date = this$0.getMDateFormat().format(System.currentTimeMillis());
        String string3 = savePath;
        if (string3 == null) {
            string3 = title = "IMG_JJCamera_" + date;
        }
        if ((string2 = savePath) == null) {
            string2 = displayName = title + ".jpg";
        }
        if ((string = savePath) == null) {
            string = this$0.getMCameraDir() + '/' + displayName;
        }
        String path = string;
        FilesKt.writeBytes((File)new File(path), (byte[])$jpegBufferArray);
        ContentValues values = new ContentValues();
        values.put("title", title);
        values.put("_display_name", displayName);
        values.put("_data", path);
        values.put("datetaken", date);
        Context context = this$0.getContext();
        if (context != null && (context = context.getContentResolver()) != null) {
            context.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        this$0.getMMainHandler().post(() -> Camera2Strategy.mJpegAvailableListener$lambda$38$lambda$37$lambda$36$lambda$35(this$0, path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void mJpegAvailableListener$lambda$38(Camera2Strategy this$0, ImageReader imageReader) {
        Image image;
        ImageReader imageReader2 = imageReader;
        Image image2 = image = imageReader2 != null ? imageReader2.acquireNextImage() : null;
        if (image2 != null) {
            AutoCloseable autoCloseable = (AutoCloseable)image2;
            Throwable throwable = null;
            try {
                Image it = (Image)autoCloseable;
                boolean bl = false;
                CaptureResult captureResult = this$0.mCaptureResults.take();
                ByteBuffer jpegBuffer = it.getPlanes()[0].getBuffer();
                byte[] jpegBufferArray = new byte[jpegBuffer.remaining()];
                jpegBuffer.get(jpegBufferArray);
                this$0.getMSaveImageExecutor().submit(() -> Camera2Strategy.mJpegAvailableListener$lambda$38$lambda$37$lambda$36(this$0, jpegBufferArray));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
    }

    public static final /* synthetic */ SettableFuture access$getMCameraDeviceFuture$p(Camera2Strategy $this) {
        return $this.mCameraDeviceFuture;
    }

    public static final /* synthetic */ SettableFuture access$getMCameraCharacteristicsFuture$p(Camera2Strategy $this) {
        return $this.mCameraCharacteristicsFuture;
    }

    public static final /* synthetic */ CameraCharacteristics access$getCameraCharacteristics(Camera2Strategy $this, String id2) {
        return $this.getCameraCharacteristics(id2);
    }

    public static final /* synthetic */ SettableFuture access$getMCameraSessionFuture$p(Camera2Strategy $this) {
        return $this.mCameraSessionFuture;
    }

    public static final /* synthetic */ BlockingQueue access$getMCaptureResults$p(Camera2Strategy $this) {
        return $this.mCaptureResults;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/camera/Camera2Strategy$Companion;", "", "<init>", "()V", "TAG", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

