/*
 * Decompiled with CFR 0.152.
 */
package cn.pedant.SweetAlert;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Bundle;
import android.text.Html;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Transformation;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.pedant.SweetAlert.Constants;
import cn.pedant.SweetAlert.OptAnimationLoader;
import cn.pedant.SweetAlert.ProgressHelper;
import cn.pedant.SweetAlert.R;
import cn.pedant.SweetAlert.SuccessTickView;
import cn.pedant.SweetAlert.ViewUtils;
import com.pnikosis.materialishprogress.ProgressWheel;
import java.util.List;

public class SweetAlertDialog
extends Dialog
implements View.OnClickListener {
    private View mDialogView;
    private AnimationSet mModalInAnim;
    private AnimationSet mModalOutAnim;
    private Animation mOverlayOutAnim;
    private Animation mErrorInAnim;
    private AnimationSet mErrorXInAnim;
    private AnimationSet mSuccessLayoutAnimSet;
    private Animation mSuccessBowAnim;
    private TextView mTitleTextView;
    private TextView mContentTextView;
    private FrameLayout mCustomViewContainer;
    private View mCustomView;
    private String mTitleText;
    private String mContentText;
    private int mTextAlign = -1;
    private boolean mShowCancel;
    private boolean mShowContent;
    private String mCancelText;
    private String mConfirmText;
    private String mNeutralText;
    private int mAlertType;
    private FrameLayout mErrorFrame;
    private FrameLayout mSuccessFrame;
    private FrameLayout mProgressFrame;
    private SuccessTickView mSuccessTick;
    private ImageView mErrorX;
    private View mSuccessLeftMask;
    private View mSuccessRightMask;
    private Drawable mCustomImgDrawable;
    private ImageView mCustomImage;
    private LinearLayout mButtonsContainer;
    private Button mConfirmButton;
    private boolean mHideConfirmButton = false;
    private Button mCancelButton;
    private Button mNeutralButton;
    private Integer mConfirmButtonBackgroundColor;
    private Integer mConfirmButtonTextColor;
    private Integer mNeutralButtonBackgroundColor;
    private Integer mNeutralButtonTextColor;
    private Integer mCancelButtonBackgroundColor;
    private Integer mCancelButtonTextColor;
    private ProgressHelper mProgressHelper;
    private FrameLayout mWarningFrame;
    private OnSweetClickListener mCancelClickListener;
    private OnSweetClickListener mConfirmClickListener;
    private OnSweetClickListener mNeutralClickListener;
    private boolean mCloseFromCancel;
    private boolean mHideKeyBoardOnDismiss = true;
    private int contentTextSize = 0;
    public static final int NORMAL_TYPE = 0;
    public static final int ERROR_TYPE = 1;
    public static final int SUCCESS_TYPE = 2;
    public static final int WARNING_TYPE = 3;
    public static final int CUSTOM_IMAGE_TYPE = 4;
    public static final int PROGRESS_TYPE = 5;
    public static final int BUTTON_CONFIRM = -1;
    public static final int BUTTON_CANCEL = -2;
    private final float defStrokeWidth;
    private float strokeWidth = 0.0f;

    public SweetAlertDialog hideConfirmButton() {
        this.mHideConfirmButton = true;
        return this;
    }

    public SweetAlertDialog(Context context) {
        this(context, 0);
    }

    public SweetAlertDialog(Context context, int alertType) {
        super(context, R.style.alert_dialog);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.strokeWidth = this.defStrokeWidth = this.getContext().getResources().getDimension(R.dimen.buttons_stroke_width);
        this.mProgressHelper = new ProgressHelper(context);
        this.mAlertType = alertType;
        this.mErrorInAnim = OptAnimationLoader.loadAnimation(this.getContext(), R.anim.error_frame_in);
        this.mErrorXInAnim = (AnimationSet)OptAnimationLoader.loadAnimation(this.getContext(), R.anim.error_x_in);
        if (Build.VERSION.SDK_INT <= 10) {
            int idx;
            List childAnims = this.mErrorXInAnim.getAnimations();
            for (idx = 0; idx < childAnims.size() && !(childAnims.get(idx) instanceof AlphaAnimation); ++idx) {
            }
            if (idx < childAnims.size()) {
                childAnims.remove(idx);
            }
        }
        this.mSuccessBowAnim = OptAnimationLoader.loadAnimation(this.getContext(), R.anim.success_bow_roate);
        this.mSuccessLayoutAnimSet = (AnimationSet)OptAnimationLoader.loadAnimation(this.getContext(), R.anim.success_mask_layout);
        this.mModalInAnim = (AnimationSet)OptAnimationLoader.loadAnimation(this.getContext(), R.anim.modal_in);
        this.mModalOutAnim = (AnimationSet)OptAnimationLoader.loadAnimation(this.getContext(), R.anim.modal_out);
        this.mModalOutAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                SweetAlertDialog.this.mDialogView.setVisibility(8);
                if (SweetAlertDialog.this.mHideKeyBoardOnDismiss) {
                    SweetAlertDialog.this.hideSoftKeyboard();
                }
                SweetAlertDialog.this.mDialogView.post(new Runnable(){

                    @Override
                    public void run() {
                        if (SweetAlertDialog.this.mCloseFromCancel) {
                            SweetAlertDialog.super.cancel();
                        } else {
                            SweetAlertDialog.super.dismiss();
                        }
                    }
                });
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mOverlayOutAnim = new Animation(){

            protected void applyTransformation(float interpolatedTime, Transformation t) {
                WindowManager.LayoutParams wlp = SweetAlertDialog.this.getWindow().getAttributes();
                wlp.alpha = 1.0f - interpolatedTime;
                SweetAlertDialog.this.getWindow().setAttributes(wlp);
            }
        };
        this.mOverlayOutAnim.setDuration(120L);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.alert_dialog);
        this.mDialogView = this.getWindow().getDecorView().findViewById(0x1020002);
        this.mTitleTextView = (TextView)this.findViewById(R.id.title_text);
        this.mContentTextView = (TextView)this.findViewById(R.id.content_text);
        this.mCustomViewContainer = (FrameLayout)this.findViewById(R.id.custom_view_container);
        this.mErrorFrame = (FrameLayout)this.findViewById(R.id.error_frame);
        this.mErrorX = (ImageView)this.mErrorFrame.findViewById(R.id.error_x);
        this.mSuccessFrame = (FrameLayout)this.findViewById(R.id.success_frame);
        this.mProgressFrame = (FrameLayout)this.findViewById(R.id.progress_dialog);
        this.mSuccessTick = (SuccessTickView)this.mSuccessFrame.findViewById(R.id.success_tick);
        this.mSuccessLeftMask = this.mSuccessFrame.findViewById(R.id.mask_left);
        this.mSuccessRightMask = this.mSuccessFrame.findViewById(R.id.mask_right);
        this.mCustomImage = (ImageView)this.findViewById(R.id.custom_image);
        this.mWarningFrame = (FrameLayout)this.findViewById(R.id.warning_frame);
        this.mButtonsContainer = (LinearLayout)this.findViewById(R.id.buttons_container);
        this.mConfirmButton = (Button)this.findViewById(R.id.confirm_button);
        this.mConfirmButton.setOnClickListener((View.OnClickListener)this);
        this.mConfirmButton.setOnTouchListener(Constants.FOCUS_TOUCH_LISTENER);
        this.mCancelButton = (Button)this.findViewById(R.id.cancel_button);
        this.mCancelButton.setOnClickListener((View.OnClickListener)this);
        this.mCancelButton.setOnTouchListener(Constants.FOCUS_TOUCH_LISTENER);
        this.mNeutralButton = (Button)this.findViewById(R.id.neutral_button);
        this.mNeutralButton.setOnClickListener((View.OnClickListener)this);
        this.mNeutralButton.setOnTouchListener(Constants.FOCUS_TOUCH_LISTENER);
        this.mProgressHelper.setProgressWheel((ProgressWheel)this.findViewById(R.id.progressWheel));
        this.setTitleText(this.mTitleText);
        this.setContentText(this.mContentText);
        this.setCustomView(this.mCustomView);
        this.setCancelText(this.mCancelText);
        this.setConfirmText(this.mConfirmText);
        this.setNeutralText(this.mNeutralText);
        this.applyStroke();
        this.setConfirmButtonBackgroundColor(this.mConfirmButtonBackgroundColor);
        this.setConfirmButtonTextColor(this.mConfirmButtonTextColor);
        this.setCancelButtonBackgroundColor(this.mCancelButtonBackgroundColor);
        this.setCancelButtonTextColor(this.mCancelButtonTextColor);
        this.setNeutralButtonBackgroundColor(this.mNeutralButtonBackgroundColor);
        this.setNeutralButtonTextColor(this.mNeutralButtonTextColor);
        this.changeAlertType(this.mAlertType, true);
    }

    private void restore() {
        this.mCustomImage.setVisibility(8);
        this.mErrorFrame.setVisibility(8);
        this.mSuccessFrame.setVisibility(8);
        this.mWarningFrame.setVisibility(8);
        this.mProgressFrame.setVisibility(8);
        this.mConfirmButton.setVisibility(this.mHideConfirmButton ? 8 : 0);
        Drawable prevBg = this.mConfirmButton.getBackground();
        this.adjustButtonContainerVisibility();
        this.mConfirmButton.setBackground(prevBg);
        this.mErrorFrame.clearAnimation();
        this.mErrorX.clearAnimation();
        this.mSuccessTick.clearAnimation();
        this.mSuccessLeftMask.clearAnimation();
        this.mSuccessRightMask.clearAnimation();
    }

    private void adjustButtonContainerVisibility() {
        boolean showButtonsContainer = false;
        for (int i = 0; i < this.mButtonsContainer.getChildCount(); ++i) {
            View view = this.mButtonsContainer.getChildAt(i);
            if (!(view instanceof Button) || view.getVisibility() != 0) continue;
            showButtonsContainer = true;
            break;
        }
        this.mButtonsContainer.setVisibility(showButtonsContainer ? 0 : 8);
    }

    private void playAnimation() {
        if (this.mAlertType == 1) {
            this.mErrorFrame.startAnimation(this.mErrorInAnim);
            this.mErrorX.startAnimation((Animation)this.mErrorXInAnim);
        } else if (this.mAlertType == 2) {
            this.mSuccessTick.startTickAnim();
            this.mSuccessRightMask.startAnimation(this.mSuccessBowAnim);
        }
    }

    private void changeAlertType(int alertType, boolean fromCreate) {
        this.mAlertType = alertType;
        if (this.mDialogView != null) {
            if (!fromCreate) {
                this.restore();
            }
            this.mConfirmButton.setVisibility(this.mHideConfirmButton ? 8 : 0);
            switch (this.mAlertType) {
                case 1: {
                    this.mErrorFrame.setVisibility(0);
                    break;
                }
                case 2: {
                    this.mSuccessFrame.setVisibility(0);
                    this.mSuccessLeftMask.startAnimation((Animation)this.mSuccessLayoutAnimSet.getAnimations().get(0));
                    this.mSuccessRightMask.startAnimation((Animation)this.mSuccessLayoutAnimSet.getAnimations().get(1));
                    break;
                }
                case 3: {
                    this.mWarningFrame.setVisibility(0);
                    break;
                }
                case 4: {
                    this.setCustomImage(this.mCustomImgDrawable);
                    break;
                }
                case 5: {
                    this.mProgressFrame.setVisibility(0);
                    this.mConfirmButton.setVisibility(8);
                }
            }
            this.adjustButtonContainerVisibility();
            if (!fromCreate) {
                this.playAnimation();
            }
        }
    }

    public int getAlertType() {
        return this.mAlertType;
    }

    public void changeAlertType(int alertType) {
        this.changeAlertType(alertType, false);
    }

    public String getTitleText() {
        return this.mTitleText;
    }

    public SweetAlertDialog setTitleText(String text) {
        this.mTitleText = text;
        if (this.mTitleTextView != null && this.mTitleText != null) {
            if (text.isEmpty()) {
                this.mTitleTextView.setVisibility(8);
            } else {
                this.mTitleTextView.setVisibility(0);
                this.mTitleTextView.setText((CharSequence)Html.fromHtml((String)this.mTitleText));
            }
        }
        return this;
    }

    public SweetAlertDialog setTitleText(int resId) {
        return this.setTitleText(this.getContext().getResources().getString(resId));
    }

    public SweetAlertDialog setCustomImage(Drawable drawable) {
        this.mCustomImgDrawable = drawable;
        if (this.mCustomImage != null && this.mCustomImgDrawable != null) {
            this.mCustomImage.setVisibility(0);
            this.mCustomImage.setImageDrawable(this.mCustomImgDrawable);
        }
        return this;
    }

    public SweetAlertDialog setCustomImage(int resourceId) {
        return this.setCustomImage(this.getContext().getResources().getDrawable(resourceId));
    }

    public String getContentText() {
        return this.mContentText;
    }

    public SweetAlertDialog setContentText(String text) {
        this.mContentText = text;
        if (this.mContentTextView != null && this.mContentText != null) {
            this.showContentText(true);
            if (this.contentTextSize != 0) {
                this.mContentTextView.setTextSize(0, (float)SweetAlertDialog.spToPx(this.contentTextSize, this.getContext()));
            }
            String ct = this.mContentText.replaceAll("(\r\n|\n\r|\r|\n)", "<br>");
            this.mContentTextView.setText((CharSequence)Html.fromHtml((String)ct));
            this.mContentTextView.setVisibility(0);
            if (this.mTextAlign != -1) {
                this.mContentTextView.setTextAlignment(this.mTextAlign);
                this.mContentTextView.setGravity(this.mTextAlign == 3 ? 5 : 3);
            }
            this.mCustomViewContainer.setVisibility(8);
        }
        return this;
    }

    public SweetAlertDialog setContentText(String text, int textAlign) {
        this.mTextAlign = textAlign;
        SweetAlertDialog d = this.setContentText(text);
        if (this.mContentTextView != null && this.mContentText != null && this.mTextAlign != -1) {
            this.mContentTextView.setTextAlignment(this.mTextAlign);
            this.mContentTextView.setGravity(this.mTextAlign == 3 ? 5 : 3);
        }
        return d;
    }

    public static int spToPx(float sp, Context context) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public SweetAlertDialog setStrokeWidth(float width) {
        this.strokeWidth = SweetAlertDialog.spToPx(width, this.getContext());
        return this;
    }

    private void applyStroke() {
        if (Float.compare(this.defStrokeWidth, this.strokeWidth) != 0) {
            Resources r = this.getContext().getResources();
            this.setButtonBackgroundColor(this.mConfirmButton, r.getColor(R.color.main_green_color));
            this.setButtonBackgroundColor(this.mNeutralButton, r.getColor(R.color.main_disabled_color));
            this.setButtonBackgroundColor(this.mCancelButton, r.getColor(R.color.red_btn_bg_color));
        }
    }

    public boolean isShowCancelButton() {
        return this.mShowCancel;
    }

    public SweetAlertDialog showCancelButton(boolean isShow) {
        this.mShowCancel = isShow;
        if (this.mCancelButton != null) {
            this.mCancelButton.setVisibility(this.mShowCancel ? 0 : 8);
        }
        return this;
    }

    public boolean isShowContentText() {
        return this.mShowContent;
    }

    public SweetAlertDialog showContentText(boolean isShow) {
        this.mShowContent = isShow;
        if (this.mContentTextView != null) {
            this.mContentTextView.setVisibility(this.mShowContent ? 0 : 8);
        }
        return this;
    }

    public String getCancelText() {
        return this.mCancelText;
    }

    public SweetAlertDialog setCancelText(String text) {
        this.mCancelText = text;
        if (this.mCancelButton != null && this.mCancelText != null) {
            this.showCancelButton(true);
            this.mCancelButton.setText((CharSequence)this.mCancelText);
        }
        return this;
    }

    public String getConfirmText() {
        return this.mConfirmText;
    }

    public SweetAlertDialog setConfirmText(String text) {
        this.mConfirmText = text;
        if (this.mConfirmButton != null && this.mConfirmText != null) {
            this.mConfirmButton.setText((CharSequence)this.mConfirmText);
        }
        return this;
    }

    public SweetAlertDialog setConfirmButtonBackgroundColor(Integer color2) {
        this.mConfirmButtonBackgroundColor = color2;
        this.setButtonBackgroundColor(this.mConfirmButton, color2);
        return this;
    }

    public Integer getConfirmButtonBackgroundColor() {
        return this.mConfirmButtonBackgroundColor;
    }

    public SweetAlertDialog setNeutralButtonBackgroundColor(Integer color2) {
        this.mNeutralButtonBackgroundColor = color2;
        this.setButtonBackgroundColor(this.mNeutralButton, color2);
        return this;
    }

    public Integer getNeutralButtonBackgroundColor() {
        return this.mNeutralButtonBackgroundColor;
    }

    public SweetAlertDialog setCancelButtonBackgroundColor(Integer color2) {
        this.mCancelButtonBackgroundColor = color2;
        this.setButtonBackgroundColor(this.mCancelButton, color2);
        return this;
    }

    public Integer getCancelButtonBackgroundColor() {
        return this.mCancelButtonBackgroundColor;
    }

    private void setButtonBackgroundColor(Button btn, Integer color2) {
        Drawable[] drawableItems;
        if (btn != null && color2 != null && (drawableItems = ViewUtils.getDrawable((View)btn)) != null) {
            GradientDrawable gradientDrawableUnChecked = (GradientDrawable)drawableItems[1];
            gradientDrawableUnChecked.setColor(color2.intValue());
            gradientDrawableUnChecked.setStroke((int)this.strokeWidth, this.genStrokeColor(color2));
        }
    }

    private int genStrokeColor(int color2) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color2, (float[])hsv);
        hsv[2] = hsv[2] * 0.7f;
        return Color.HSVToColor((float[])hsv);
    }

    public SweetAlertDialog setConfirmButtonTextColor(Integer color2) {
        this.mConfirmButtonTextColor = color2;
        if (this.mConfirmButton != null && color2 != null) {
            this.mConfirmButton.setTextColor(this.mConfirmButtonTextColor.intValue());
        }
        return this;
    }

    public Integer getConfirmButtonTextColor() {
        return this.mConfirmButtonTextColor;
    }

    public SweetAlertDialog setNeutralButtonTextColor(Integer color2) {
        this.mNeutralButtonTextColor = color2;
        if (this.mNeutralButton != null && color2 != null) {
            this.mNeutralButton.setTextColor(this.mNeutralButtonTextColor.intValue());
        }
        return this;
    }

    public Integer getNeutralButtonTextColor() {
        return this.mNeutralButtonTextColor;
    }

    public SweetAlertDialog setCancelButtonTextColor(Integer color2) {
        this.mCancelButtonTextColor = color2;
        if (this.mCancelButton != null && color2 != null) {
            this.mCancelButton.setTextColor(this.mCancelButtonTextColor.intValue());
        }
        return this;
    }

    public Integer getCancelButtonTextColor() {
        return this.mCancelButtonTextColor;
    }

    public SweetAlertDialog setCancelClickListener(OnSweetClickListener listener) {
        this.mCancelClickListener = listener;
        return this;
    }

    public SweetAlertDialog setConfirmClickListener(OnSweetClickListener listener) {
        this.mConfirmClickListener = listener;
        return this;
    }

    public SweetAlertDialog setNeutralText(String text) {
        this.mNeutralText = text;
        if (this.mNeutralButton != null && this.mNeutralText != null && !text.isEmpty()) {
            this.mNeutralButton.setVisibility(0);
            this.mNeutralButton.setText((CharSequence)this.mNeutralText);
        }
        return this;
    }

    public SweetAlertDialog setNeutralClickListener(OnSweetClickListener listener) {
        this.mNeutralClickListener = listener;
        return this;
    }

    public void setTitle(CharSequence title) {
        this.setTitleText(title.toString());
    }

    public void setTitle(int titleId) {
        this.setTitleText(this.getContext().getResources().getString(titleId));
    }

    public Button getButton(int buttonType) {
        switch (buttonType) {
            default: {
                return this.mConfirmButton;
            }
            case -2: {
                return this.mCancelButton;
            }
            case -3: 
        }
        return this.mNeutralButton;
    }

    public SweetAlertDialog setConfirmButton(String text, OnSweetClickListener listener) {
        this.setConfirmText(text);
        this.setConfirmClickListener(listener);
        return this;
    }

    public SweetAlertDialog setConfirmButton(int resId, OnSweetClickListener listener) {
        String text = this.getContext().getResources().getString(resId);
        this.setConfirmButton(text, listener);
        return this;
    }

    public SweetAlertDialog setCancelButton(String text, OnSweetClickListener listener) {
        this.setCancelText(text);
        this.setCancelClickListener(listener);
        return this;
    }

    public SweetAlertDialog setCancelButton(int resId, OnSweetClickListener listener) {
        String text = this.getContext().getResources().getString(resId);
        this.setCancelButton(text, listener);
        return this;
    }

    public SweetAlertDialog setNeutralButton(String text, OnSweetClickListener listener) {
        this.setNeutralText(text);
        this.setNeutralClickListener(listener);
        return this;
    }

    public SweetAlertDialog setNeutralButton(int resId, OnSweetClickListener listener) {
        String text = this.getContext().getResources().getString(resId);
        this.setNeutralButton(text, listener);
        return this;
    }

    public SweetAlertDialog setContentTextSize(int value) {
        this.contentTextSize = value;
        return this;
    }

    public int getContentTextSize() {
        return this.contentTextSize;
    }

    protected void onStart() {
        this.mDialogView.startAnimation((Animation)this.mModalInAnim);
        this.playAnimation();
    }

    public SweetAlertDialog setCustomView(View view) {
        this.mCustomView = view;
        if (this.mCustomView != null && this.mCustomViewContainer != null) {
            this.mCustomViewContainer.addView(view);
            this.mCustomViewContainer.setVisibility(0);
            this.mContentTextView.setVisibility(8);
        }
        return this;
    }

    public void cancel() {
        this.dismissWithAnimation(true);
    }

    public void dismissWithAnimation() {
        this.dismissWithAnimation(false);
    }

    private void dismissWithAnimation(boolean fromCancel) {
        this.mCloseFromCancel = fromCancel;
        ((ViewGroup)this.mDialogView).getChildAt(0).startAnimation(this.mOverlayOutAnim);
        this.mDialogView.startAnimation((Animation)this.mModalOutAnim);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.cancel_button) {
            if (this.mCancelClickListener != null) {
                this.mCancelClickListener.onClick(this);
            } else {
                this.dismissWithAnimation();
            }
        } else if (v.getId() == R.id.confirm_button) {
            if (this.mConfirmClickListener != null) {
                this.mConfirmClickListener.onClick(this);
            } else {
                this.dismissWithAnimation();
            }
        } else if (v.getId() == R.id.neutral_button) {
            if (this.mNeutralClickListener != null) {
                this.mNeutralClickListener.onClick(this);
            } else {
                this.dismissWithAnimation();
            }
        }
    }

    public ProgressHelper getProgressHelper() {
        return this.mProgressHelper;
    }

    public SweetAlertDialog setHideKeyBoardOnDismiss(boolean hide) {
        this.mHideKeyBoardOnDismiss = hide;
        return this;
    }

    public boolean isHideKeyBoardOnDismiss() {
        return this.mHideKeyBoardOnDismiss;
    }

    private void hideSoftKeyboard() {
        InputMethodManager inputMethodManager;
        Activity activity = this.getOwnerActivity();
        if (activity != null && (inputMethodManager = (InputMethodManager)activity.getSystemService("input_method")) != null && activity.getCurrentFocus() != null) {
            inputMethodManager.hideSoftInputFromWindow(activity.getCurrentFocus().getWindowToken(), 0);
        }
    }

    public static interface OnSweetClickListener {
        public void onClick(SweetAlertDialog var1);
    }
}

