/*
 * Decompiled with CFR 0.152.
 */
package com.github.ehe.simpleorchestrator.sample.task;

import com.github.ehe.simpleorchestrator.Task;
import com.github.ehe.simpleorchestrator.exception.OrchestratorException;
import com.github.ehe.simpleorchestrator.sample.context.AsyncCheckRiskContext;
import java.util.List;
import java.util.concurrent.Future;
import jersey.repackaged.com.google.common.collect.Lists;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;

@Component
public class AsyncCheckRiskTask
implements Task<AsyncCheckRiskContext> {
    private static List<String> blackList = Lists.newArrayList((Object[])new String[]{"111222333", "999999999"});

    public void execute(AsyncCheckRiskContext context) throws OrchestratorException {
        context.logHistory((Object)this.getClass().getName());
        String ssn = context.getSsn();
        context.setRiskScore(this.check(context, ssn));
    }

    @Async
    private Future<Integer> check(AsyncCheckRiskContext context, String ssn) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (blackList.contains(ssn)) {
            context.logHistory((Object)"riskCheck: blacklisted");
            return new AsyncResult((Object)100);
        }
        return new AsyncResult((Object)0);
    }
}

