/*
 * Decompiled with CFR 0.152.
 */
package com.github.ehe.simpleorchestrator.sample.api.loan;

import com.github.ehe.simpleorchestrator.Orchestrator;
import com.github.ehe.simpleorchestrator.Task;
import com.github.ehe.simpleorchestrator.context.Context;
import com.github.ehe.simpleorchestrator.impl.OrchestratorImpl;
import com.github.ehe.simpleorchestrator.sample.api.loan.LoanOrchestratorContext;
import com.github.ehe.simpleorchestrator.sample.entity.ApplicationResult;
import com.github.ehe.simpleorchestrator.sample.entity.LoanApplication;
import com.github.ehe.simpleorchestrator.sample.exception.ValidationException;
import com.github.ehe.simpleorchestrator.sample.task.AsyncCheckRiskTask;
import com.github.ehe.simpleorchestrator.sample.task.CreditScoreTask;
import com.github.ehe.simpleorchestrator.sample.task.LoanTask;
import com.github.ehe.simpleorchestrator.sample.task.ValidationTask;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@Path(value="/application/loan")
public class LoanService {
    @Autowired
    private ValidationTask<LoanApplication> validationTask;
    @Autowired
    private CreditScoreTask creditScoreTask;
    @Autowired
    private AsyncCheckRiskTask asyncCheckRiskTask;
    @Autowired
    private LoanTask loanTask;
    @Autowired
    private Orchestrator<LoanOrchestratorContext> orchestrator;

    @Bean
    private Orchestrator<LoanOrchestratorContext> loanOrchestrator() {
        return new OrchestratorImpl(new Task[]{this.validationTask, this.creditScoreTask, this.asyncCheckRiskTask, this.loanTask});
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ApplicationResult applyloan(LoanApplication app) {
        LoanOrchestratorContext context = new LoanOrchestratorContext();
        context.init(app);
        try {
            this.orchestrator.execute((Context)context);
        }
        catch (ValidationException e) {
            return new ApplicationResult(e.getErrors());
        }
        return new ApplicationResult(context.getApplication().getPerson().getName(), context.isApproved(), context.getHistory());
    }
}

