/*
 * Decompiled with CFR 0.152.
 */
package com.github.ehe.simpleorchestrator.sample.task;

import com.github.ehe.simpleorchestrator.Task;
import com.github.ehe.simpleorchestrator.exception.OrchestratorException;
import com.github.ehe.simpleorchestrator.sample.context.ValidationContext;
import com.github.ehe.simpleorchestrator.sample.exception.ValidationException;
import com.github.ehe.simpleorchestrator.sample.task.ValidationTask;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.springframework.stereotype.Component;

@Component
public class ValidationTask<A>
implements Task<ValidationContext<A>> {
    private static Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    public void execute(ValidationContext<A> context) throws OrchestratorException {
        Object application = context.getApplication();
        Set constraintViolations = validator.validate(application, new Class[]{Default.class});
        if (constraintViolations.size() > 0) {
            List errors = constraintViolations.stream().map(v -> new ValidationError(v.getMessage(), v.getPropertyPath().toString())).collect(Collectors.toList());
            throw new ValidationException(errors);
        }
    }
}

