/*
 * Decompiled with CFR 0.152.
 */
package com.github.ehe.simpleorchestrator.sample.api.loan;

import com.github.ehe.simpleorchestrator.exception.OrchestratorException;
import com.github.ehe.simpleorchestrator.sample.context.AsyncCheckRiskContext;
import com.github.ehe.simpleorchestrator.sample.context.CreditScoreContext;
import com.github.ehe.simpleorchestrator.sample.context.LoanContext;
import com.github.ehe.simpleorchestrator.sample.context.ValidationContext;
import com.github.ehe.simpleorchestrator.sample.entity.LoanApplication;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class LoanOrchestratorContext
implements CreditScoreContext,
AsyncCheckRiskContext,
LoanContext,
ValidationContext<LoanApplication> {
    private LoanApplication application;
    private int creditScore;
    private boolean isApproved;
    private ConcurrentLinkedQueue<String> history = new ConcurrentLinkedQueue();
    private Future<Integer> riskScore;

    public void init(LoanApplication application) {
        this.application = application;
    }

    public String getSsn() {
        return this.application.getPerson().getSsn();
    }

    public void setRiskScore(Future<Integer> score) {
        this.riskScore = score;
    }

    public void setCreditScore(int score) {
        this.creditScore = score;
    }

    public LoanApplication getApplication() {
        return this.application;
    }

    public int getCreditScore() {
        return this.creditScore;
    }

    public int getRiskScore() {
        try {
            return (Integer)this.riskScore.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            throw new OrchestratorException("asyncRiskTask Failed", (Throwable)e);
        }
    }

    public void setLoanApproveStatus(boolean isApproved) {
        this.isApproved = isApproved;
    }

    public boolean isApproved() {
        return this.isApproved;
    }

    public List<String> getHistory() {
        return this.history.stream().collect(Collectors.toList());
    }

    public void logHistory(String history) {
        this.history.add(history);
    }
}

