/*
 * Decompiled with CFR 0.152.
 */
package com.github.ehe.simpleorchestrator.sample.api.card;

import com.github.ehe.simpleorchestrator.Orchestrator;
import com.github.ehe.simpleorchestrator.Task;
import com.github.ehe.simpleorchestrator.context.Context;
import com.github.ehe.simpleorchestrator.impl.Channel;
import com.github.ehe.simpleorchestrator.impl.OrchestratorImpl;
import com.github.ehe.simpleorchestrator.impl.Selector;
import com.github.ehe.simpleorchestrator.sample.api.card.CardOrchestratorContext;
import com.github.ehe.simpleorchestrator.sample.api.card.CardSelectorContext;
import com.github.ehe.simpleorchestrator.sample.api.card.CardService;
import com.github.ehe.simpleorchestrator.sample.entity.ApplicationResult;
import com.github.ehe.simpleorchestrator.sample.entity.CardApplication;
import com.github.ehe.simpleorchestrator.sample.selector.CardSelector;
import com.github.ehe.simpleorchestrator.sample.task.AsyncCheckRiskTask;
import com.github.ehe.simpleorchestrator.sample.task.CreditCardTask;
import com.github.ehe.simpleorchestrator.sample.task.CreditScoreTask;
import com.github.ehe.simpleorchestrator.sample.task.DebitCardTask;
import com.github.ehe.simpleorchestrator.sample.task.ValidationTask;
import java.util.EnumMap;
import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@Path(value="/application/card")
public class CardService {
    @Autowired
    private ValidationTask<CardApplication> validationTask;
    @Autowired
    private CreditScoreTask creditScoreTask;
    @Autowired
    private DebitCardTask debitCardTask;
    @Autowired
    private CreditCardTask creditCardTask;
    @Autowired
    private AsyncCheckRiskTask asyncCheckRiskTask;
    @Autowired
    private Channel<RiskCreditContext> riskCreditChannel;
    @Autowired
    private Selector<CardApplication.CardType, CardSelectorContext> cardSelector;
    @Autowired
    private Orchestrator<CardOrchestratorContext> orchestrator;

    @Bean
    private ValidationTask<CardApplication> cardValidationTask() {
        return new ValidationTask();
    }

    @Bean
    private Channel<RiskCreditContext> riskCreditChannel() {
        return new Channel(new Task[]{this.asyncCheckRiskTask, this.creditCardTask});
    }

    @Bean
    private Selector<CardApplication.CardType, CardSelectorContext> cardSelector() {
        return new CardSelector((EnumMap)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Bean
    private Orchestrator<CardOrchestratorContext> cardOrchestrator() {
        return new OrchestratorImpl(new Task[]{this.creditScoreTask, this.cardSelector});
    }

    @PostConstruct
    public void init() {
        System.out.println("aaa");
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ApplicationResult applyCard(CardApplication app) {
        CardOrchestratorContext context = new CardOrchestratorContext();
        context.init(app);
        this.orchestrator.execute((Context)context);
        return new ApplicationResult(context.getApplication().getPerson().getName(), context.isApproved(), context.getHistory());
    }

    static /* synthetic */ Channel access$000(CardService x0) {
        return x0.riskCreditChannel;
    }

    static /* synthetic */ DebitCardTask access$100(CardService x0) {
        return x0.debitCardTask;
    }
}

