/*
 * Decompiled with CFR 0.152.
 */
package com.github.ehe.simpleorchestrator.sample.api.card;

import com.github.ehe.simpleorchestrator.exception.OrchestratorException;
import com.github.ehe.simpleorchestrator.sample.api.card.CardSelectorContext;
import com.github.ehe.simpleorchestrator.sample.context.CreditCardContext;
import com.github.ehe.simpleorchestrator.sample.context.CreditScoreContext;
import com.github.ehe.simpleorchestrator.sample.context.DebitCardContext;
import com.github.ehe.simpleorchestrator.sample.context.ValidationContext;
import com.github.ehe.simpleorchestrator.sample.entity.CardApplication;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class CardOrchestratorContext
implements CreditScoreContext,
CreditCardContext,
DebitCardContext,
CardSelectorContext,
ValidationContext<CardApplication> {
    private CardApplication cardApplication;
    private int creditScore;
    private boolean isApproved;
    private ConcurrentLinkedQueue<String> history = new ConcurrentLinkedQueue();
    private Future<Integer> riskScore;

    public void init(CardApplication cardApplication) {
        this.cardApplication = cardApplication;
    }

    public String getSsn() {
        return this.cardApplication.getPerson().getSsn();
    }

    public void setRiskScore(Future<Integer> score) {
        this.riskScore = score;
    }

    public void setCreditScore(int score) {
        this.creditScore = score;
    }

    public CardApplication getApplication() {
        return this.cardApplication;
    }

    public int getCreditScore() {
        return this.creditScore;
    }

    public int getRiskScore() {
        try {
            return (Integer)this.riskScore.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            throw new OrchestratorException("asyncRiskTask Failed", (Throwable)e);
        }
    }

    public void setCardApproveStatus(boolean isApproved) {
        this.isApproved = isApproved;
    }

    public boolean isApproved() {
        return this.isApproved;
    }

    public List<String> getHistory() {
        return this.history.stream().collect(Collectors.toList());
    }

    public void logHistory(String history) {
        this.history.add(history);
    }
}

