/*
 * Decompiled with CFR 0.152.
 */
package net.ypresto.androidtranscoder.format;

import android.media.MediaFormat;
import android.util.Log;
import net.ypresto.androidtranscoder.format.MediaFormatStrategy;
import net.ypresto.androidtranscoder.format.OutputFormatUnavailableException;

class Android720pFormatStrategy
implements MediaFormatStrategy {
    private static final String TAG = "720pFormatStrategy";
    private static final int LONGER_LENGTH = 1280;
    private static final int SHORTER_LENGTH = 720;
    private static final int DEFAULT_BITRATE = 8000000;
    private final int mBitRate;

    public Android720pFormatStrategy() {
        this.mBitRate = 8000000;
    }

    public Android720pFormatStrategy(int bitRate) {
        this.mBitRate = bitRate;
    }

    @Override
    public MediaFormat createVideoOutputFormat(MediaFormat inputFormat) {
        int outHeight;
        int outWidth;
        int shorter;
        int longer;
        int height;
        int width = inputFormat.getInteger("width");
        if (width >= (height = inputFormat.getInteger("height"))) {
            longer = width;
            shorter = height;
            outWidth = 1280;
            outHeight = 720;
        } else {
            shorter = width;
            longer = height;
            outWidth = 720;
            outHeight = 1280;
        }
        if (longer * 9 != shorter * 16) {
            throw new OutputFormatUnavailableException("This video is not 16:9, and is not able to transcode. (" + width + "x" + height + ")");
        }
        if (shorter <= 720) {
            Log.d((String)TAG, (String)("This video is less or equal to 720p, pass-through. (" + width + "x" + height + ")"));
            return null;
        }
        MediaFormat format = MediaFormat.createVideoFormat((String)"video/avc", (int)outWidth, (int)outHeight);
        format.setInteger("bitrate", this.mBitRate);
        format.setInteger("frame-rate", 30);
        format.setInteger("i-frame-interval", 3);
        format.setInteger("color-format", 2130708361);
        return format;
    }

    @Override
    public MediaFormat createAudioOutputFormat(MediaFormat inputFormat) {
        return null;
    }
}

