/*
 * Decompiled with CFR 0.152.
 */
package net.ypresto.androidtranscoder.format;

import android.media.MediaFormat;
import android.util.Log;
import net.ypresto.androidtranscoder.format.MediaFormatStrategy;
import net.ypresto.androidtranscoder.format.OutputFormatUnavailableException;

class Android16By9FormatStrategy
implements MediaFormatStrategy {
    public static final int SCALE_720P = 5;
    private static final String TAG = "Android16By9FormatStrategy";
    private final int mScale;
    private final int mBitrate;

    public Android16By9FormatStrategy(int scale, int bitrate) {
        this.mScale = scale;
        this.mBitrate = bitrate;
    }

    @Override
    public MediaFormat createVideoOutputFormat(MediaFormat inputFormat) {
        int outHeight;
        int outWidth;
        int shorter;
        int longer;
        int width = inputFormat.getInteger("width");
        int height = inputFormat.getInteger("height");
        int targetLonger = this.mScale * 16 * 16;
        int targetShorter = this.mScale * 16 * 9;
        if (width >= height) {
            longer = width;
            shorter = height;
            outWidth = targetLonger;
            outHeight = targetShorter;
        } else {
            shorter = width;
            longer = height;
            outWidth = targetShorter;
            outHeight = targetLonger;
        }
        if (longer * 9 != shorter * 16) {
            throw new OutputFormatUnavailableException("This video is not 16:9, and is not able to transcode. (" + width + "x" + height + ")");
        }
        if (shorter <= targetShorter) {
            Log.d((String)TAG, (String)("This video's height is less or equal to " + targetShorter + ", pass-through. (" + width + "x" + height + ")"));
            return null;
        }
        MediaFormat format = MediaFormat.createVideoFormat((String)"video/avc", (int)outWidth, (int)outHeight);
        format.setInteger("bitrate", this.mBitrate);
        format.setInteger("frame-rate", 30);
        format.setInteger("i-frame-interval", 3);
        format.setInteger("color-format", 2130708361);
        return format;
    }

    @Override
    public MediaFormat createAudioOutputFormat(MediaFormat inputFormat) {
        return null;
    }
}

