/*
 * Decompiled with CFR 0.152.
 */
package org.phoenixframework.channels;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.phoenixframework.channels.Channel;
import org.phoenixframework.channels.ChannelEvent;
import org.phoenixframework.channels.Envelope;
import org.phoenixframework.channels.IErrorCallback;
import org.phoenixframework.channels.IMessageCallback;
import org.phoenixframework.channels.ISocketCloseCallback;
import org.phoenixframework.channels.ISocketOpenCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Socket {
    private static final Logger log = LoggerFactory.getLogger(Socket.class);
    public static final int RECONNECT_INTERVAL_MS = 5000;
    private static final int DEFAULT_HEARTBEAT_INTERVAL = 7000;
    private final List<Channel> channels = new ArrayList<Channel>();
    private String endpointUri = null;
    private final Set<IErrorCallback> errorCallbacks = Collections.newSetFromMap(new HashMap());
    private final int heartbeatInterval;
    private TimerTask heartbeatTimerTask = null;
    private final OkHttpClient httpClient = new OkHttpClient();
    private final Set<IMessageCallback> messageCallbacks = Collections.newSetFromMap(new HashMap());
    private final ObjectMapper objectMapper = new ObjectMapper();
    private boolean reconnectOnFailure = true;
    private TimerTask reconnectTimerTask = null;
    private int refNo = 1;
    private final LinkedBlockingQueue<RequestBody> sendBuffer = new LinkedBlockingQueue();
    private final Set<ISocketCloseCallback> socketCloseCallbacks = Collections.newSetFromMap(new HashMap());
    private final Set<ISocketOpenCallback> socketOpenCallbacks = Collections.newSetFromMap(new HashMap());
    private Timer timer = null;
    private WebSocket webSocket = null;
    private final PhoenixWSListener wsListener = new PhoenixWSListener();

    public Socket(String endpointUri) throws IOException {
        this(endpointUri, 7000);
    }

    public Socket(String endpointUri, int heartbeatIntervalInMs) {
        log.trace("PhoenixSocket({})", (Object)endpointUri);
        this.endpointUri = endpointUri;
        this.heartbeatInterval = heartbeatIntervalInMs;
        this.timer = new Timer("Reconnect Timer for " + endpointUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel chan(String topic, JsonNode payload) {
        log.trace("chan: {}, {}", (Object)topic, (Object)payload);
        Channel channel = new Channel(topic, payload, this);
        List<Channel> list = this.channels;
        synchronized (list) {
            this.channels.add(channel);
        }
        return channel;
    }

    public void connect() throws IOException {
        log.trace("connect");
        this.disconnect();
        String httpUrl = this.endpointUri.replaceFirst("^ws:", "http:").replaceFirst("^wss:", "https:");
        Request request = new Request.Builder().url(httpUrl).build();
        this.webSocket = this.httpClient.newWebSocket(request, (WebSocketListener)this.wsListener);
    }

    public void disconnect() throws IOException {
        log.trace("disconnect");
        if (this.webSocket != null) {
            this.webSocket.close(1001, "Disconnected by client");
        }
        this.cancelHeartbeatTimer();
        this.cancelReconnectTimer();
    }

    public boolean isConnected() {
        return this.webSocket != null;
    }

    public Socket onClose(ISocketCloseCallback callback) {
        this.socketCloseCallbacks.add(callback);
        return this;
    }

    public Socket onError(IErrorCallback callback) {
        this.errorCallbacks.add(callback);
        return this;
    }

    public Socket onMessage(IMessageCallback callback) {
        this.messageCallbacks.add(callback);
        return this;
    }

    public Socket onOpen(ISocketOpenCallback callback) {
        this.cancelReconnectTimer();
        this.socketOpenCallbacks.add(callback);
        return this;
    }

    public Socket push(Envelope envelope) throws IOException {
        ObjectNode node = this.objectMapper.createObjectNode();
        node.put("topic", envelope.getTopic());
        node.put("event", envelope.getEvent());
        node.put("ref", envelope.getRef());
        node.put("join_ref", envelope.getJoinRef());
        node.set("payload", (JsonNode)(envelope.getPayload() == null ? this.objectMapper.createObjectNode() : envelope.getPayload()));
        String json = this.objectMapper.writeValueAsString((Object)node);
        log.trace("push: {}, isConnected:{}, JSON:{}", new Object[]{envelope, this.isConnected(), json});
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"text/xml"), (String)json);
        if (this.isConnected()) {
            this.webSocket.send(json);
        } else {
            this.sendBuffer.add(body);
        }
        return this;
    }

    public void reconectOnFailure(boolean reconnectOnFailure) {
        this.reconnectOnFailure = reconnectOnFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Channel channel) {
        List<Channel> list = this.channels;
        synchronized (list) {
            Iterator<Channel> chanIter = this.channels.iterator();
            while (chanIter.hasNext()) {
                if (chanIter.next() != channel) continue;
                chanIter.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllChannels() {
        List<Channel> list = this.channels;
        synchronized (list) {
            this.channels.clear();
        }
    }

    public String toString() {
        return "PhoenixSocket{endpointUri='" + this.endpointUri + '\'' + ", channels(" + this.channels.size() + ")=" + this.channels + ", refNo=" + this.refNo + ", webSocket=" + this.webSocket + '}';
    }

    synchronized String makeRef() {
        this.refNo = (this.refNo + 1) % Integer.MAX_VALUE;
        return Integer.toString(this.refNo);
    }

    private void cancelHeartbeatTimer() {
        if (this.heartbeatTimerTask != null) {
            this.heartbeatTimerTask.cancel();
        }
    }

    private void cancelReconnectTimer() {
        if (this.reconnectTimerTask != null) {
            this.reconnectTimerTask.cancel();
        }
    }

    private void flushSendBuffer() {
        while (this.isConnected() && !this.sendBuffer.isEmpty()) {
            RequestBody body = (RequestBody)this.sendBuffer.remove();
            this.webSocket.send(body.toString());
        }
    }

    private void scheduleReconnectTimer() {
        this.cancelReconnectTimer();
        this.cancelHeartbeatTimer();
        this.reconnectTimerTask = new TimerTask(){

            @Override
            public void run() {
                log.trace("reconnectTimerTask run");
                try {
                    Socket.this.connect();
                }
                catch (Exception e) {
                    log.error("Failed to reconnect to " + (Object)((Object)Socket.this.wsListener), (Throwable)e);
                }
            }
        };
        this.timer.schedule(this.reconnectTimerTask, 5000L);
    }

    private void startHeartbeatTimer() {
        this.heartbeatTimerTask = new TimerTask(){

            @Override
            public void run() {
                log.trace("heartbeatTimerTask run");
                if (Socket.this.isConnected()) {
                    try {
                        Envelope envelope = new Envelope("phoenix", "heartbeat", (JsonNode)new ObjectNode(JsonNodeFactory.instance), Socket.this.makeRef(), null);
                        Socket.this.push(envelope);
                    }
                    catch (Exception e) {
                        log.error("Failed to send heartbeat", (Throwable)e);
                    }
                }
            }
        };
        this.timer.schedule(this.heartbeatTimerTask, this.heartbeatInterval, (long)this.heartbeatInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerChannelError() {
        List<Channel> list = this.channels;
        synchronized (list) {
            for (Channel channel : this.channels) {
                channel.trigger(ChannelEvent.ERROR.getPhxEvent(), null);
            }
        }
    }

    static String replyEventName(String ref) {
        return "chan_reply_" + ref;
    }

    public class PhoenixWSListener
    extends WebSocketListener {
        public void onOpen(WebSocket webSocket, Response response) {
            log.trace("WebSocket onOpen: {}", (Object)webSocket);
            Socket.this.webSocket = webSocket;
            Socket.this.cancelReconnectTimer();
            Socket.this.startHeartbeatTimer();
            for (ISocketOpenCallback callback : Socket.this.socketOpenCallbacks) {
                callback.onOpen();
            }
            Socket.this.flushSendBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(WebSocket webSocket, String text) {
            log.trace("onMessage: {}", (Object)text);
            try {
                Envelope envelope = (Envelope)Socket.this.objectMapper.readValue(text, Envelope.class);
                List list = Socket.this.channels;
                synchronized (list) {
                    for (Channel channel : Socket.this.channels) {
                        if (!channel.isMember(envelope)) continue;
                        channel.trigger(envelope.getEvent(), envelope);
                    }
                }
                for (IMessageCallback callback : Socket.this.messageCallbacks) {
                    callback.onMessage(envelope);
                }
            }
            catch (IOException e) {
                log.error("Failed to read message payload", (Throwable)e);
            }
        }

        public void onMessage(WebSocket webSocket, ByteString bytes) {
            this.onMessage(webSocket, bytes.toString());
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            log.trace("WebSocket onClose {}/{}", (Object)code, (Object)reason);
            Socket.this.webSocket = null;
            for (ISocketCloseCallback callback : Socket.this.socketCloseCallbacks) {
                callback.onClose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            log.warn("WebSocket connection error", t);
            try {
                Socket.this.triggerChannelError();
                for (IErrorCallback callback : Socket.this.errorCallbacks) {
                    callback.onError(t.getMessage());
                }
            }
            finally {
                if (Socket.this.webSocket != null) {
                    try {
                        Socket.this.webSocket.close(1001, "EOF received");
                    }
                    finally {
                        Socket.this.webSocket = null;
                    }
                }
                if (Socket.this.reconnectOnFailure) {
                    Socket.this.scheduleReconnectTimer();
                }
            }
        }
    }
}

