/*
 * Decompiled with CFR 0.152.
 */
package org.phoenixframework.channels;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Envelope {
    @JsonProperty(value="topic")
    private String topic;
    @JsonProperty(value="event")
    private String event;
    @JsonProperty(value="payload")
    private JsonNode payload;
    @JsonProperty(value="ref")
    private String ref;
    @JsonProperty
    private String join_ref;

    public Envelope() {
    }

    public Envelope(String topic, String event, JsonNode payload, String ref, String join_ref) {
        this.topic = topic;
        this.event = event;
        this.payload = payload;
        this.ref = ref;
        this.join_ref = join_ref;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getEvent() {
        return this.event;
    }

    public JsonNode getPayload() {
        return this.payload;
    }

    public String getRef() {
        if (this.ref != null) {
            return this.ref;
        }
        JsonNode refNode = this.payload.get("ref");
        return refNode != null ? refNode.textValue() : null;
    }

    public String getJoinRef() {
        if (this.join_ref != null) {
            return this.join_ref;
        }
        JsonNode joinRefNode = this.payload.get("join_ref");
        return joinRefNode != null ? joinRefNode.textValue() : null;
    }

    public String getResponseStatus() {
        JsonNode statusNode = this.payload.get("status");
        return statusNode == null ? null : statusNode.textValue();
    }

    public String getReason() {
        JsonNode reasonNode = this.payload.get("reason");
        return reasonNode == null ? null : reasonNode.textValue();
    }

    public String toString() {
        return "Envelope{topic='" + this.topic + '\'' + ", event='" + this.event + '\'' + ", payload=" + this.payload + '}';
    }
}

