/*
 * Decompiled with CFR 0.152.
 */
package com.enrico.colorpicker;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.preference.Preference;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import com.enrico.colorpicker.colorUtils;
import com.enrico.colorpicker.viewUtils;

class paletteUtils {
    paletteUtils() {
    }

    private static void createCircularBitmap(Activity activity, Resources resources, ImageView imageView, String tag, int colorViewColor) {
        Bitmap.Config conf = Bitmap.Config.ARGB_8888;
        Bitmap bmp = Bitmap.createBitmap((int)paletteUtils.SpToPixels((Context)activity, 50), (int)paletteUtils.SpToPixels((Context)activity, 50), (Bitmap.Config)conf);
        int color = Color.parseColor((String)tag);
        imageView.setImageDrawable((Drawable)paletteUtils.createRoundedBitmapDrawableWithBorder(activity, bmp, color, colorViewColor, resources));
    }

    static void createCircularPreferenceBitmap(Preference preference, Activity activity, Resources resources, int color, int viewColor) {
        Bitmap.Config conf = Bitmap.Config.ARGB_8888;
        Bitmap bmp = Bitmap.createBitmap((int)paletteUtils.SpToPixels((Context)activity, 50), (int)paletteUtils.SpToPixels((Context)activity, 50), (Bitmap.Config)conf);
        preference.setIcon((Drawable)paletteUtils.createRoundedBitmapDrawableWithBorder(activity, bmp, color, viewColor, resources));
    }

    private static RoundedBitmapDrawable createRoundedBitmapDrawableWithBorder(Activity activity, Bitmap bitmap, int tagColor, int viewColor, Resources mResources) {
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        int borderWidthHalf = 10;
        int bitmapRadius = Math.min(bitmapWidth, bitmapHeight) / 2;
        int bitmapSquareWidth = Math.min(bitmapWidth, bitmapHeight);
        int bitmapDim = bitmapSquareWidth + borderWidthHalf;
        Bitmap roundedBitmap = Bitmap.createBitmap((int)bitmapDim, (int)bitmapDim, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(roundedBitmap);
        canvas.drawColor(tagColor);
        int x = borderWidthHalf + bitmapSquareWidth - bitmapWidth;
        int y = borderWidthHalf + bitmapSquareWidth - bitmapHeight;
        canvas.drawBitmap(bitmap, (float)x, (float)y, null);
        final Paint borderPaint = new Paint();
        borderPaint.setStyle(Paint.Style.STROKE);
        borderPaint.setAntiAlias(true);
        borderPaint.setStrokeWidth((float)borderWidthHalf);
        double darkness = 1.0 - (0.299 * (double)Color.red((int)viewColor) + 0.587 * (double)Color.green((int)viewColor) + 0.114 * (double)Color.blue((int)viewColor)) / 255.0;
        if (darkness < 0.5) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    borderPaint.setColor(colorUtils.opaqueColor(-12303292));
                }
            });
        } else {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    borderPaint.setColor(colorUtils.opaqueColor(-3355444));
                }
            });
        }
        canvas.drawCircle((float)(canvas.getWidth() / 2), (float)(canvas.getWidth() / 2), (float)(bitmapDim / 2), borderPaint);
        RoundedBitmapDrawable roundedBitmapDrawable = RoundedBitmapDrawableFactory.create((Resources)mResources, (Bitmap)roundedBitmap);
        roundedBitmapDrawable.setCornerRadius((float)bitmapRadius);
        roundedBitmapDrawable.setCircular(true);
        roundedBitmapDrawable.setAntiAlias(true);
        return roundedBitmapDrawable;
    }

    private static int SpToPixels(Context context, int width) {
        float scaledDensity = context.getResources().getDisplayMetrics().scaledDensity;
        int density = Math.round(scaledDensity);
        return width * density;
    }

    static void initializeMaterialPalette(final Activity activity, Resources resources, final View colorView, final TextView hashtext, final TextView hashtag, final SeekBar alphatize, final EditText editAA, final EditText editAlpha, final TextView rgb, final EditText editHEX, final EditText editR, final EditText editG, final EditText editB, ImageView ... imageViews) {
        for (ImageView circles : imageViews) {
            final String tag = circles.getTag().toString();
            final String desc = circles.getContentDescription().toString();
            final int color = Color.parseColor((String)tag);
            paletteUtils.createCircularBitmap(activity, resources, circles, tag, colorUtils.getColorViewColor(colorView));
            circles.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    alphatize.setProgress(255);
                    viewUtils.updateColorView(activity, colorView, hashtext, hashtag, editAA, editAlpha, rgb, editHEX, editR, editG, editB, color);
                    viewUtils.makeToast(activity, desc + ": " + tag.toUpperCase());
                }
            });
        }
    }
}

