/*
 * Decompiled with CFR 0.152.
 */
package persistence.datomic;

import clojure.lang.IFn;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentVector;
import clojure.lang.Symbol;
import datomic.Connection;
import datomic.Database;
import datomic.Peer;
import datomic.Util;
import datomisca.AbstractQuery;
import datomisca.AddEntity;
import datomisca.AsEntityId$;
import datomisca.AsPermanentEntityId;
import datomisca.AsPermanentEntityId$;
import datomisca.Attribute;
import datomisca.Attribute2EntityReaderCast$;
import datomisca.Attribute2PartialAddEntityWriter$;
import datomisca.Cardinality;
import datomisca.DId;
import datomisca.DId$;
import datomisca.Datomic$;
import datomisca.DatomicMapping$;
import datomisca.DatomicRef$;
import datomisca.EntityMapper;
import datomisca.EntityReader;
import datomisca.FromDatomic$;
import datomisca.FromDatomicInj$;
import datomisca.LookupRef;
import datomisca.LookupRef$;
import datomisca.PartialAddEntityWriter;
import datomisca.Partition$;
import datomisca.QueryResultToTuple;
import datomisca.QueryResultToTuple$;
import datomisca.TempId;
import datomisca.TempIdentified;
import datomisca.ToDatomic$;
import datomisca.ToDatomicCast$;
import datomisca.ToDatomicInj$;
import datomisca.TxData;
import datomisca.TxReport;
import datomisca.functional.Combinator;
import datomisca.functional.ContraFunctor;
import datomisca.functional.Functor;
import datomisca.functional.Monad;
import datomisca.gen.TypedQuery0;
import datomisca.gen.TypedQuery2;
import datomisca.gen.TypedQuery3;
import datomisca.package;
import datomisca.package$;
import datomiscadao.DB;
import datomiscadao.Page;
import datomiscadao.PageFilter;
import datomiscadao.Sort;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import persistence.datomic.DatomicAuthService;
import persistence.datomic.TokenUser;
import persistence.datomic.TokenUser$Schema$;
import play.api.libs.json.JsValue;
import scala.Function1;
import scala.Function4;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

public final class TokenUser$
implements DB<TokenUser>,
Serializable {
    public static final TokenUser$ MODULE$ = new TokenUser$();
    private static final Function1<Date, LocalDateTime> dateToLocalDateTime;
    private static final Function1<LocalDateTime, Date> localDateTimeToDate;
    private static final EntityReader<TokenUser> reader;
    private static final PartialAddEntityWriter<TokenUser> writer;
    private static final long hoursTillExpiry;
    private static TypedQuery3<?, ?, ?, Object> datomiscadao$DB$$findByGenericQuery;
    private static TypedQuery3<?, ?, ?, Object> datomiscadao$DB$$findByParentIdQuery;

    static {
        DB.$init$((DB)MODULE$);
        dateToLocalDateTime = (Function1 & Serializable)date -> LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        localDateTimeToDate = (Function1 & Serializable)ldt -> Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
        reader = (EntityReader)DatomicMapping$.MODULE$.RDCombinatorOpsWrapper((EntityMapper)package.RichAttribute$.MODULE$.read$extension(package$.MODULE$.RichAttribute(TokenUser$Schema$.MODULE$.id()), Attribute2EntityReaderCast$.MODULE$.attr2EntityReaderCastOne(FromDatomic$.MODULE$.FromDatomicInj2FromDatomic(FromDatomicInj$.MODULE$.DUuid2UUID()))), DatomicMapping$.MODULE$.RDCombinatorWrapper((Monad)EntityReader.EntityReaderMonad$.MODULE$)).and((Object)package.RichAttribute$.MODULE$.read$extension(package$.MODULE$.RichAttribute(TokenUser$Schema$.MODULE$.email()), Attribute2EntityReaderCast$.MODULE$.attr2EntityReaderCastOne(FromDatomic$.MODULE$.FromDatomicInj2FromDatomic(FromDatomicInj$.MODULE$.DString2String())))).and((Object)package.RichAttribute$.MODULE$.read$extension(package$.MODULE$.RichAttribute(TokenUser$Schema$.MODULE$.expirationTime()), Attribute2EntityReaderCast$.MODULE$.attr2EntityReaderCastOne(FromDatomic$.MODULE$.FromDatomicInj2FromDatomic(FromDatomicInj$.MODULE$.DInstant2Date()))).map(MODULE$.dateToLocalDateTime())).and((Object)package.RichAttribute$.MODULE$.read$extension(package$.MODULE$.RichAttribute(TokenUser$Schema$.MODULE$.isSignUp()), Attribute2EntityReaderCast$.MODULE$.attr2EntityReaderCastOne(FromDatomic$.MODULE$.FromDatomicInj2FromDatomic(FromDatomicInj$.MODULE$.DBoolean2Boolean())))).apply((Function4 & Serializable)(id, email, expirationTime, isSignUp) -> TokenUser$.$anonfun$reader$1(id, email, expirationTime, BoxesRunTime.unboxToBoolean((Object)isSignUp)), (Functor)EntityReader.EntityReaderFunctor$.MODULE$);
        writer = (PartialAddEntityWriter)DatomicMapping$.MODULE$.RDCombinatorOpsWrapper((EntityMapper)package.RichAttribute$.MODULE$.write$extension(package$.MODULE$.RichAttribute(TokenUser$Schema$.MODULE$.id()), Attribute2PartialAddEntityWriter$.MODULE$.oneValue(ToDatomic$.MODULE$.ToDatomicInj2ToDatomic(ToDatomicInj$.MODULE$.UUID2DUuid()))), (Combinator)PartialAddEntityWriter.AddEntityWriterCombinator$.MODULE$).and((Object)package.RichAttribute$.MODULE$.write$extension(package$.MODULE$.RichAttribute(TokenUser$Schema$.MODULE$.email()), Attribute2PartialAddEntityWriter$.MODULE$.oneValue(ToDatomic$.MODULE$.ToDatomicInj2ToDatomic(ToDatomicInj$.MODULE$.String2DString())))).and(DatomicMapping$.MODULE$.RDtoContraFunctorOps(package.RichAttribute$.MODULE$.write$extension(package$.MODULE$.RichAttribute(TokenUser$Schema$.MODULE$.expirationTime()), Attribute2PartialAddEntityWriter$.MODULE$.oneValue(ToDatomic$.MODULE$.ToDatomicInj2ToDatomic(ToDatomicInj$.MODULE$.Date2DDate()))), (ContraFunctor)PartialAddEntityWriter.PartialAddEntityWriterContraFunctor$.MODULE$).contramap(MODULE$.localDateTimeToDate())).and((Object)package.RichAttribute$.MODULE$.write$extension(package$.MODULE$.RichAttribute(TokenUser$Schema$.MODULE$.isSignUp()), Attribute2PartialAddEntityWriter$.MODULE$.oneValue(ToDatomic$.MODULE$.ToDatomicInj2ToDatomic(ToDatomicInj$.MODULE$.Boolean2DBoolean())))).apply(DatomicMapping$.MODULE$.unlift((Function1 & Serializable)x$0 -> MODULE$.unapply((TokenUser)x$0)), (ContraFunctor)PartialAddEntityWriter.PartialAddEntityWriterContraFunctor$.MODULE$);
        hoursTillExpiry = 24L;
    }

    public Future<TokenUser> createEntity(IterableOnce<TxData> facts, DId resolveId, Connection conn, ExecutionContext ec) {
        return DB.createEntity$((DB)this, facts, (DId)resolveId, (Connection)conn, (ExecutionContext)ec);
    }

    public Future<TokenUser> updateEntity(IterableOnce<TxData> facts, long id, Connection conn, ExecutionContext ec) {
        return DB.updateEntity$((DB)this, facts, (long)id, (Connection)conn, (ExecutionContext)ec);
    }

    public Iterable<Object> execute0(AbstractQuery myQuery, Connection conn) {
        return DB.execute0$((DB)this, (AbstractQuery)myQuery, (Connection)conn);
    }

    public Iterable<Object> execute1(AbstractQuery myQuery, String param, Connection conn) {
        return DB.execute1$((DB)this, (AbstractQuery)myQuery, (String)param, (Connection)conn);
    }

    public Iterable<Object> execute1(AbstractQuery myQuery, long param, Connection conn) {
        return DB.execute1$((DB)this, (AbstractQuery)myQuery, (long)param, (Connection)conn);
    }

    public Option<TokenUser> refOptionByChildId(Attribute<DatomicRef$, ? extends Cardinality> attribute, long childId, Connection conn) {
        return DB.refOptionByChildId$((DB)this, attribute, (long)childId, (Connection)conn);
    }

    public Vector<TokenUser> refListByChildId(Attribute<DatomicRef$, ? extends Cardinality> attribute, long childId, Connection conn) {
        return DB.refListByChildId$((DB)this, attribute, (long)childId, (Connection)conn);
    }

    public Iterable<Object> refRawByChildId(Attribute<DatomicRef$, ? extends Cardinality> attribute, long childId, Connection conn) {
        return DB.refRawByChildId$((DB)this, attribute, (long)childId, (Connection)conn);
    }

    public Vector<TokenUser> refListByParentId(Attribute<DatomicRef$, ? extends Cardinality> attribute, long parentId, Connection conn) {
        return DB.refListByParentId$((DB)this, attribute, (long)parentId, (Connection)conn);
    }

    public Option<TokenUser> refOptionByParentId(Attribute<DatomicRef$, ? extends Cardinality> attribute, long parentId, Connection conn) {
        return DB.refOptionByParentId$((DB)this, attribute, (long)parentId, (Connection)conn);
    }

    public Iterable<Object> refRawByParentId(Attribute<DatomicRef$, ? extends Cardinality> attribute, long parentId, Connection conn) {
        return DB.refRawByParentId$((DB)this, attribute, (long)parentId, (Connection)conn);
    }

    public Object get(Object id, Database db, EntityReader reader, AsPermanentEntityId idConv) {
        return DB.get$((DB)this, (Object)id, (Database)db, (EntityReader)reader, (AsPermanentEntityId)idConv);
    }

    public Object get(Object id, Connection conn, EntityReader reader, AsPermanentEntityId idConv) {
        return DB.get$((DB)this, (Object)id, (Connection)conn, (EntityReader)reader, (AsPermanentEntityId)idConv);
    }

    public <I> Option<TokenUser> find(I id, Database db, EntityReader<TokenUser> reader, AsPermanentEntityId<I> idConv) {
        return DB.find$((DB)this, id, (Database)db, reader, idConv);
    }

    public <I> Option<TokenUser> find(I id, Connection conn, EntityReader<TokenUser> reader, AsPermanentEntityId<I> idConv) {
        return DB.find$((DB)this, id, (Connection)conn, reader, idConv);
    }

    public Option<TokenUser> find(java.util.List<?> ref, Database db, EntityReader<TokenUser> reader) {
        return DB.find$((DB)this, ref, (Database)db, reader);
    }

    public Option<TokenUser> find(java.util.List<?> ref, Connection conn, EntityReader<TokenUser> reader) {
        return DB.find$((DB)this, ref, (Connection)conn, reader);
    }

    public <I> Try<TokenUser> getAsTry(I id, Database db, EntityReader<TokenUser> reader, AsPermanentEntityId<I> idConv) {
        return DB.getAsTry$((DB)this, id, (Database)db, reader, idConv);
    }

    public <I> Try<TokenUser> getAsTry(I id, Connection conn, EntityReader<TokenUser> reader, AsPermanentEntityId<I> idConv) {
        return DB.getAsTry$((DB)this, id, (Connection)conn, reader, idConv);
    }

    public <I> JsValue getAsJson(I id, Database db, int depth, AsPermanentEntityId<I> idConv) {
        return DB.getAsJson$((DB)this, id, (Database)db, (int)depth, idConv);
    }

    public <I> int getAsJson$default$3() {
        return DB.getAsJson$default$3$((DB)this);
    }

    public <I> Future<TxReport> retractEntity(I id, Connection conn, ExecutionContext ex, AsPermanentEntityId<I> idConv) {
        return DB.retractEntity$((DB)this, id, (Connection)conn, (ExecutionContext)ex, idConv);
    }

    public List<TokenUser> list(Iterable<Object> query, Database db, EntityReader<TokenUser> reader) {
        return DB.list$((DB)this, query, (Database)db, reader);
    }

    public List<TokenUser> list(Iterable<Object> query, Connection conn, EntityReader<TokenUser> reader) {
        return DB.list$((DB)this, query, (Connection)conn, reader);
    }

    public List<Tuple2<Object, TokenUser>> listWithId(Iterable<Object> query, Database db, EntityReader<TokenUser> reader) {
        return DB.listWithId$((DB)this, query, (Database)db, reader);
    }

    public List<Tuple2<Object, TokenUser>> listWithId(Iterable<Object> query, Connection conn, EntityReader<TokenUser> reader) {
        return DB.listWithId$((DB)this, query, (Connection)conn, reader);
    }

    public Option<TokenUser> headOption(Iterable<Object> query, Database db, EntityReader<TokenUser> reader) {
        return DB.headOption$((DB)this, query, (Database)db, reader);
    }

    public Option<TokenUser> headOption(Iterable<Object> query, Connection conn, EntityReader<TokenUser> reader) {
        return DB.headOption$((DB)this, query, (Connection)conn, reader);
    }

    public Option<Tuple2<Object, TokenUser>> headOptionWithId(Iterable<Object> query, Database db, EntityReader<TokenUser> reader) {
        return DB.headOptionWithId$((DB)this, query, (Database)db, reader);
    }

    public Option<Tuple2<Object, TokenUser>> headOptionWithId(Iterable<Object> query, Connection conn, EntityReader<TokenUser> reader) {
        return DB.headOptionWithId$((DB)this, query, (Connection)conn, reader);
    }

    public Page<TokenUser> page(Iterable<Object> query, PageFilter filter, Database db, EntityReader<TokenUser> reader) {
        return DB.page$((DB)this, query, (PageFilter)filter, (Database)db, reader);
    }

    public Page<TokenUser> pageWithSort(Iterable<Tuple2<Object, Object>> query, PageFilter filter, Sort.SortOrder sort, Database db, EntityReader<TokenUser> reader) {
        return DB.pageWithSort$((DB)this, query, (PageFilter)filter, (Sort.SortOrder)sort, (Database)db, reader);
    }

    public Sort.SortOrder pageWithSort$default$3() {
        return DB.pageWithSort$default$3$((DB)this);
    }

    public TypedQuery3<?, ?, ?, Object> datomiscadao$DB$$findByGenericQuery() {
        return datomiscadao$DB$$findByGenericQuery;
    }

    public TypedQuery3<?, ?, ?, Object> datomiscadao$DB$$findByParentIdQuery() {
        return datomiscadao$DB$$findByParentIdQuery;
    }

    public final void datomiscadao$DB$_setter_$datomiscadao$DB$$findByGenericQuery_$eq(TypedQuery3<?, ?, ?, Object> x$1) {
        datomiscadao$DB$$findByGenericQuery = x$1;
    }

    public final void datomiscadao$DB$_setter_$datomiscadao$DB$$findByParentIdQuery_$eq(TypedQuery3<?, ?, ?, Object> x$1) {
        datomiscadao$DB$$findByParentIdQuery = x$1;
    }

    public UUID $lessinit$greater$default$1() {
        return UUID.randomUUID();
    }

    public LocalDateTime $lessinit$greater$default$3() {
        return LocalDateTime.now().plusHours(336L);
    }

    public boolean $lessinit$greater$default$4() {
        return false;
    }

    public Function1<Date, LocalDateTime> dateToLocalDateTime() {
        return dateToLocalDateTime;
    }

    public Function1<LocalDateTime, Date> localDateTimeToDate() {
        return localDateTimeToDate;
    }

    public EntityReader<TokenUser> reader() {
        return reader;
    }

    public PartialAddEntityWriter<TokenUser> writer() {
        return writer;
    }

    private long hoursTillExpiry() {
        return hoursTillExpiry;
    }

    public Future<Option<TokenUser>> findById(UUID id, Connection conn) {
        return Future$.MODULE$.successful(this.find(LookupRef$.MODULE$.apply(TokenUser$Schema$.MODULE$.id(), (Object)id, ToDatomic$.MODULE$.ToDatomicInj2ToDatomic(ToDatomicInj$.MODULE$.UUID2DUuid())), conn, this.reader()));
    }

    public Seq<TokenUser> findAll(Connection conn) {
        HashMap<Keyword, PersistentVector> map$macro$1 = new HashMap<Keyword, PersistentVector>(2);
        map$macro$1.put(Keyword.intern(null, (String)"find"), PersistentVector.create(Arrays.asList((Object[])new Symbol[]{Symbol.intern(null, (String)"?a")})));
        map$macro$1.put(Keyword.intern(null, (String)"where"), PersistentVector.create(Arrays.asList((Object[])new PersistentVector[]{PersistentVector.create(Arrays.asList((Object[])new IFn[]{Symbol.intern(null, (String)"?a"), Keyword.intern((String)"tokenUser", (String)"email")}))})));
        TypedQuery0 queryAll = new TypedQuery0(PersistentArrayMap.create(map$macro$1));
        return this.list((Iterable<Object>)Datomic$.MODULE$.q(queryAll, (Object)new datomisca.Database(Datomic$.MODULE$.database(conn)), ToDatomicCast$.MODULE$.DDWriter2ToDatomicCast(ToDatomic$.MODULE$.dbConv()), (QueryResultToTuple)QueryResultToTuple$.MODULE$.QueryResultToTuple1()), conn, this.reader());
    }

    public Seq<TokenUser> findByEmail(String email, Connection conn) {
        HashMap<Keyword, PersistentVector> map$macro$1 = new HashMap<Keyword, PersistentVector>(3);
        map$macro$1.put(Keyword.intern(null, (String)"find"), PersistentVector.create(Arrays.asList((Object[])new Symbol[]{Symbol.intern(null, (String)"?a")})));
        map$macro$1.put(Keyword.intern(null, (String)"in"), PersistentVector.create(Arrays.asList((Object[])new Symbol[]{Symbol.intern(null, (String)"$"), Symbol.intern(null, (String)"?email")})));
        map$macro$1.put(Keyword.intern(null, (String)"where"), PersistentVector.create(Arrays.asList((Object[])new PersistentVector[]{PersistentVector.create(Arrays.asList((Object[])new IFn[]{Symbol.intern(null, (String)"?a"), Keyword.intern((String)"tokenUser", (String)"email"), Symbol.intern(null, (String)"?email")}))})));
        TypedQuery2 query = new TypedQuery2(PersistentArrayMap.create(map$macro$1));
        return this.list((Iterable<Object>)Datomic$.MODULE$.q(query, (Object)new datomisca.Database(Datomic$.MODULE$.database(conn)), (Object)email, ToDatomicCast$.MODULE$.DDWriter2ToDatomicCast(ToDatomic$.MODULE$.dbConv()), ToDatomicCast$.MODULE$.DDWriter2ToDatomicCast(ToDatomic$.MODULE$.ToDatomicInj2ToDatomic(ToDatomicInj$.MODULE$.String2DString())), (QueryResultToTuple)QueryResultToTuple$.MODULE$.QueryResultToTuple1()), conn, this.reader());
    }

    public Future<TokenUser> save(TokenUser tokenUser, Connection conn, ExecutionContext ec) {
        AddEntity tokenUserFact = DatomicMapping$.MODULE$.toEntity((Object)new TempId(DId$.MODULE$.apply(Partition$.MODULE$.USER())), (Object)tokenUser, AsEntityId$.MODULE$.dId(), this.writer());
        return Datomic$.MODULE$.transact((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TxData[]{tokenUserFact}), conn, ec).map((Function1 & Serializable)tx -> (TokenUser)MODULE$.get((Object)BoxesRunTime.boxToLong((long)tx.resolve((TempIdentified)tokenUserFact)), conn, MODULE$.reader(), AsPermanentEntityId$.MODULE$.long(Predef$.MODULE$.$conforms())), ec);
    }

    public void delete(UUID id, DatomicAuthService datomicService, ExecutionContext ec) {
        Connection conn = datomicService.conn();
        this.retractEntity(new LookupRef(LookupRef$.MODULE$.apply(TokenUser$Schema$.MODULE$.id(), (Object)id, ToDatomic$.MODULE$.ToDatomicInj2ToDatomic(ToDatomicInj$.MODULE$.UUID2DUuid()))), conn, ec, AsPermanentEntityId$.MODULE$.lookupRefId());
        Peer.connect((Object)datomicService.connectionUrl("prod")).transact(Util.list((Object[])new Object[]{Util.list((Object[])new Object[]{new StringBuilder(46).append("[{:db/id #db/id[db.part/user], :db/excise ").append(id).append(" }]]").toString()})}));
    }

    public TokenUser apply(UUID id, String email, LocalDateTime expirationTime, boolean isSignUp) {
        return new TokenUser(id, email, expirationTime, isSignUp);
    }

    public UUID apply$default$1() {
        return UUID.randomUUID();
    }

    public LocalDateTime apply$default$3() {
        return LocalDateTime.now().plusHours(336L);
    }

    public boolean apply$default$4() {
        return false;
    }

    public Option<Tuple4<UUID, String, LocalDateTime, Object>> unapply(TokenUser x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.id(), (Object)x$0.email(), (Object)x$0.expirationTime(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isSignUp())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TokenUser$.class);
    }

    public static final /* synthetic */ TokenUser $anonfun$reader$1(UUID id, String email, LocalDateTime expirationTime, boolean isSignUp) {
        return new TokenUser(id, email, expirationTime, isSignUp);
    }

    private TokenUser$() {
    }
}

