/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.form;

import android.content.Context;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import eltos.simpledialogfragment.R;
import eltos.simpledialogfragment.SimpleDialog;
import eltos.simpledialogfragment.color.ColorView;
import eltos.simpledialogfragment.color.SimpleColorDialog;
import eltos.simpledialogfragment.form.ColorField;
import eltos.simpledialogfragment.form.FormElementViewHolder;
import eltos.simpledialogfragment.form.SimpleFormDialog;

class ColorViewHolder
extends FormElementViewHolder<ColorField>
implements SimpleDialog.OnDialogResultListener {
    protected static final String SAVED_COLOR = "color";
    private static final String COLOR_DIALOG_TAG = "colorPickerDialogTag";
    private TextView label;
    private ColorView colorView;

    public ColorViewHolder(ColorField field) {
        super(field);
    }

    @Override
    protected int getContentViewLayout() {
        return R.layout.simpledialogfragment_form_item_color;
    }

    @Override
    protected void setUpView(View view, final Context context, Bundle savedInstanceState, final SimpleFormDialog.DialogActions actions) {
        this.label = (TextView)view.findViewById(R.id.label);
        this.colorView = (ColorView)view.findViewById(R.id.color);
        String text = ((ColorField)this.field).getText(context);
        this.label.setText((CharSequence)text);
        this.label.setVisibility(text == null ? 8 : 0);
        this.label.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ColorViewHolder.this.colorView.performClick();
            }
        });
        if (savedInstanceState != null) {
            this.colorView.setColor(savedInstanceState.getInt(SAVED_COLOR));
        } else {
            this.colorView.setColor(((ColorField)this.field).getInitialColor(context));
        }
        this.colorView.setOutlineWidth((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
        this.colorView.setOutlineColor(((ColorField)this.field).outline);
        this.colorView.setStyle(ColorView.Style.PALETTE);
        this.colorView.setChecked(true);
        this.colorView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                actions.showDialog((SimpleDialog)((Object)((SimpleColorDialog)SimpleColorDialog.build().title(((ColorField)ColorViewHolder.this.field).getText(context))).colors(((ColorField)ColorViewHolder.this.field).colors).allowCustom(((ColorField)ColorViewHolder.this.field).allowCustom).colorPreset(ColorViewHolder.this.colorView.getColor()).neut()), ColorViewHolder.COLOR_DIALOG_TAG + ((ColorField)ColorViewHolder.this.field).resultKey);
            }
        });
    }

    @Override
    protected void saveState(Bundle outState) {
        outState.putInt(SAVED_COLOR, this.colorView.getColor());
    }

    @Override
    protected void putResults(Bundle results, String key) {
        results.putInt(key, this.colorView.getColor());
    }

    @Override
    protected boolean focus(SimpleFormDialog.FocusActions actions) {
        actions.hideKeyboard();
        return this.colorView.requestFocus();
    }

    @Override
    protected boolean posButtonEnabled(Context context) {
        return !((ColorField)this.field).required || this.colorView.getColor() != 0;
    }

    @Override
    protected boolean validate(Context context) {
        boolean valid = this.posButtonEnabled(context);
        if (valid) {
            TypedValue value = new TypedValue();
            if (this.label.getContext().getTheme().resolveAttribute(16842904, value, true)) {
                this.label.setTextColor(value.data);
            } else {
                this.label.setTextColor(-1979711488);
            }
        } else {
            this.label.setTextColor(context.getResources().getColor(R.color.simpledialogfragment_error_color));
        }
        return valid;
    }

    @Override
    public boolean onResult(@NonNull String dialogTag, int which, @NonNull Bundle extras) {
        if ((COLOR_DIALOG_TAG + ((ColorField)this.field).resultKey).equals(dialogTag)) {
            if (which == -1 && this.colorView != null) {
                this.colorView.setColor(extras.getInt("SimpleColorDialog.color", this.colorView.getColor()));
            }
            return true;
        }
        return false;
    }
}

