/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment;

import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.DatePicker;
import eltos.simpledialogfragment.CustomViewDialog;
import java.util.Calendar;
import java.util.Date;

public class SimpleDateDialog
extends CustomViewDialog<SimpleDateDialog>
implements DatePicker.OnDateChangedListener {
    public static final String TAG = "SimpleDateDialog.";
    public static final String DATE = "SimpleDateDialog.DATE";
    protected static final String MIN_DATE = "SimpleDateDialog.MIN_DATE";
    protected static final String MAX_DATE = "SimpleDateDialog.MAX_DATE";
    protected static final String FIRST_DAY_OF_WEEK = "SimpleDateDialog.FIRST_DAY_OF_WEEK";
    private DatePicker picker;

    public static SimpleDateDialog build() {
        return new SimpleDateDialog();
    }

    public SimpleDateDialog date(Date date) {
        return this.date(date.getTime());
    }

    public SimpleDateDialog date(long millis) {
        return (SimpleDateDialog)((Object)this.setArg(DATE, millis));
    }

    public SimpleDateDialog minDate(Date date) {
        return this.minDate(date.getTime());
    }

    public SimpleDateDialog minDate(long millis) {
        return (SimpleDateDialog)((Object)this.setArg(MIN_DATE, millis));
    }

    public SimpleDateDialog maxDate(Date date) {
        return this.maxDate(date.getTime());
    }

    public SimpleDateDialog maxDate(long millis) {
        return (SimpleDateDialog)((Object)this.setArg(MAX_DATE, millis));
    }

    public SimpleDateDialog firstDayOfWeek(int day) {
        return (SimpleDateDialog)((Object)this.setArg(FIRST_DAY_OF_WEEK, day));
    }

    @Override
    protected View onCreateContentView(Bundle savedInstanceState) {
        this.picker = new DatePicker(this.getContext());
        Calendar c = Calendar.getInstance();
        if (savedInstanceState != null) {
            c.setTimeInMillis(savedInstanceState.getLong(DATE));
        } else if (this.getArguments().containsKey(DATE)) {
            c.setTimeInMillis(this.getArguments().getLong(DATE));
        }
        this.picker.init(c.get(1), c.get(2), c.get(5), (DatePicker.OnDateChangedListener)this);
        if (this.getArguments().containsKey(MIN_DATE)) {
            this.picker.setMinDate(this.getArguments().getLong(MIN_DATE));
        }
        if (this.getArguments().containsKey(MAX_DATE)) {
            this.picker.setMaxDate(this.getArguments().getLong(MAX_DATE));
        }
        if (Build.VERSION.SDK_INT >= 21 && this.getArguments().containsKey(FIRST_DAY_OF_WEEK)) {
            this.picker.setFirstDayOfWeek(this.getArguments().getInt(FIRST_DAY_OF_WEEK));
        }
        return this.picker;
    }

    public void onDateChanged(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
    }

    private long getCurrentMillis() {
        Calendar c = Calendar.getInstance();
        c.set(this.picker.getYear(), this.picker.getMonth(), this.picker.getDayOfMonth(), 0, 0, 0);
        return c.getTimeInMillis();
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putLong(DATE, this.getCurrentMillis());
        super.onSaveInstanceState(outState);
    }

    @Override
    protected Bundle onResult(int which) {
        Bundle results = new Bundle();
        results.putLong(DATE, this.getCurrentMillis());
        return results;
    }
}

