/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.form;

import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import eltos.simpledialogfragment.CustomViewDialog;
import eltos.simpledialogfragment.R;
import eltos.simpledialogfragment.SimpleDialog;
import eltos.simpledialogfragment.form.FormElement;
import eltos.simpledialogfragment.form.FormElementViewHolder;
import eltos.simpledialogfragment.form.Hint;
import eltos.simpledialogfragment.form.Input;
import eltos.simpledialogfragment.form.InputViewHolder;
import java.util.ArrayList;
import java.util.Collections;

public class SimpleFormDialog
extends CustomViewDialog<SimpleFormDialog>
implements SimpleDialog.OnDialogResultListener {
    public static final String TAG = "SimpleFormDialog.";
    protected static final String INPUT_FIELDS = "SimpleFormDialog.inputFields";
    protected static final String AUTO_FOCUS = "SimpleFormDialog.autofocus";
    protected static final String SAVE_TAG = "form.";
    private FocusActions mFocusActions = new FocusActions();
    ArrayList<FormElementViewHolder<?>> mViews = new ArrayList(0);
    ViewGroup mFormContainer;

    public static SimpleFormDialog build() {
        return new SimpleFormDialog();
    }

    public static SimpleFormDialog buildEmailInput(String emailFieldKey) {
        return SimpleFormDialog.build().fields(new FormElement[]{Input.email(emailFieldKey).required()});
    }

    public static SimpleFormDialog buildPasswordInput(String passwordFieldKey) {
        return SimpleFormDialog.build().fields(new FormElement[]{Input.password(passwordFieldKey).required()});
    }

    public static SimpleFormDialog buildPinCodeInput(String pinFieldKey) {
        return SimpleFormDialog.build().fields(new FormElement[]{Input.pin(pinFieldKey).required()});
    }

    public static SimpleFormDialog buildPinCodeInput(String pinFieldKey, int digits) {
        return SimpleFormDialog.build().fields(((Input)Input.pin(pinFieldKey).required()).min(digits).max(digits));
    }

    public static SimpleFormDialog buildNumberInput(String numberFieldKey) {
        return SimpleFormDialog.build().fields(new FormElement[]{Input.phone(numberFieldKey).required()});
    }

    public static SimpleFormDialog buildLoginEmail(String emailFieldKey, String passwordFieldKey) {
        return ((SimpleFormDialog)((SimpleFormDialog)SimpleFormDialog.build().title(R.string.login)).pos(R.string.login)).fields(new FormElement[]{Input.email(emailFieldKey).required(), Input.password(passwordFieldKey).required()});
    }

    public static SimpleFormDialog buildLogin(String userFieldKey, String passwordFieldKey) {
        return ((SimpleFormDialog)((SimpleFormDialog)SimpleFormDialog.build().title(R.string.login)).pos(R.string.login)).fields(new FormElement[]{Input.plain(userFieldKey).hint(R.string.user).required(), Input.password(passwordFieldKey).required()});
    }

    public SimpleFormDialog fields(FormElement ... elements) {
        ArrayList list = new ArrayList(elements.length);
        Collections.addAll(list, elements);
        this.getArguments().putParcelableArrayList(INPUT_FIELDS, list);
        return this;
    }

    public SimpleFormDialog autofocus(boolean enabled) {
        return (SimpleFormDialog)this.setArg(AUTO_FOCUS, enabled);
    }

    protected String onValidateInput(String fieldKey, @Nullable String input) {
        Bundle extras = this.getExtras();
        if (this.getTargetFragment() instanceof InputValidator) {
            return ((InputValidator)this.getTargetFragment()).validate(this.getTag(), fieldKey, input, extras);
        }
        if (this.getActivity() instanceof InputValidator) {
            return ((InputValidator)this.getActivity()).validate(this.getTag(), fieldKey, input, extras);
        }
        return null;
    }

    @Override
    protected void onDialogShown() {
        if (this.getDialog() != null && this.getDialog().getWindow() != null) {
            this.getDialog().getWindow().setSoftInputMode(16);
        }
        this.setPositiveButtonEnabled(this.posButtonEnabled());
        if (this.getArguments().getBoolean(AUTO_FOCUS, true)) {
            this.requestFocus(0);
        }
    }

    @Override
    protected boolean acceptsPositiveButtonPress() {
        boolean okay = true;
        for (FormElementViewHolder<?> holder : this.mViews) {
            String error;
            if (!holder.validate(this.getContext())) {
                if (okay) {
                    holder.focus(this.mFocusActions);
                }
                okay = false;
                continue;
            }
            if (!(holder instanceof InputViewHolder) || (error = this.onValidateInput(((FormElement)holder.field).resultKey, ((InputViewHolder)holder).getText())) == null) continue;
            ((InputViewHolder)holder).setError(true, error);
            if (okay) {
                holder.focus(this.mFocusActions);
            }
            okay = false;
        }
        return okay;
    }

    protected boolean posButtonEnabled() {
        int first = this.getFirstFocusableIndex();
        if (0 <= first && this.isLastFocusableIndex(first) && first < this.mViews.size()) {
            return this.mViews.get(first).posButtonEnabled(this.getContext());
        }
        return true;
    }

    protected void requestFocus(int viewIndex) {
        if (0 <= viewIndex && viewIndex < this.mViews.size()) {
            this.mViews.get(viewIndex).focus(this.mFocusActions);
        }
    }

    private boolean isFocusableIndex(int i) {
        ArrayList fields = this.getArguments().getParcelableArrayList(INPUT_FIELDS);
        return 0 <= i && fields != null && i < fields.size() && !(fields.get(i) instanceof Hint);
    }

    private int getNextFocusableIndex(int i) {
        ArrayList fields = this.getArguments().getParcelableArrayList(INPUT_FIELDS);
        do {
            if (fields != null && ++i < fields.size()) continue;
            return Integer.MAX_VALUE;
        } while (!this.isFocusableIndex(i));
        return i;
    }

    private int getFirstFocusableIndex() {
        return this.getNextFocusableIndex(-1);
    }

    private boolean isOnlyFocusableIndex(int i) {
        return i == this.getFirstFocusableIndex() && this.isLastFocusableIndex(i);
    }

    private boolean isLastFocusableIndex(int i) {
        return this.isFocusableIndex(i) && this.getNextFocusableIndex(i) == Integer.MAX_VALUE;
    }

    @Override
    public View onCreateContentView(Bundle savedInstanceState) {
        View view = this.inflate(R.layout.simpledialogfragment_form);
        ViewGroup container = (ViewGroup)view.findViewById(R.id.container);
        this.populateContainer(container, savedInstanceState);
        this.setPositiveButtonEnabled(this.posButtonEnabled());
        return view;
    }

    protected void populateContainer(@NonNull ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mFormContainer = container;
        ArrayList fields = this.getArguments().getParcelableArrayList(INPUT_FIELDS);
        if (fields != null) {
            this.mViews = new ArrayList(fields.size());
            int lastI = fields.size() - 1;
            for (int i = 0; i < fields.size(); ++i) {
                Object viewHolder = ((FormElement)fields.get(i)).buildViewHolder();
                View child = this.inflate(((FormElementViewHolder)viewHolder).getContentViewLayout(), this.mFormContainer, false);
                Bundle savedState = savedInstanceState == null ? null : savedInstanceState.getBundle(SAVE_TAG + i);
                ((FormElementViewHolder)viewHolder).setUpView(child, this.getContext(), savedState, new DialogActions(i, lastI));
                this.mFormContainer.addView(child);
                this.mViews.add((FormElementViewHolder<?>)viewHolder);
            }
        }
    }

    @Override
    public Bundle onResult(int which) {
        Bundle result = new Bundle();
        for (FormElementViewHolder<?> holder : this.mViews) {
            holder.putResults(result, ((FormElement)holder.field).resultKey);
        }
        return result;
    }

    public void onSaveInstanceState(Bundle outState) {
        for (int i = 0; i < this.mViews.size(); ++i) {
            Bundle viewState = new Bundle();
            this.mViews.get(i).saveState(viewState);
            outState.putBundle(SAVE_TAG + i, viewState);
        }
        super.onSaveInstanceState(outState);
    }

    @Override
    public boolean onResult(@NonNull String dialogTag, int which, @NonNull Bundle extras) {
        ArrayList fields = this.getArguments().getParcelableArrayList(INPUT_FIELDS);
        if (fields != null) {
            for (FormElementViewHolder<?> view : this.mViews) {
                if (!(view instanceof SimpleDialog.OnDialogResultListener) || !((SimpleDialog.OnDialogResultListener)((Object)view)).onResult(dialogTag, which, extras)) continue;
                return true;
            }
        }
        return false;
    }

    public class FocusActions {
        public void hideKeyboard() {
            InputMethodManager imm;
            View view = SimpleFormDialog.this.getDialog().getCurrentFocus();
            if (view != null && (imm = (InputMethodManager)SimpleFormDialog.this.getContext().getSystemService("input_method")) != null) {
                imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
        }

        public void clearCurrentFocus() {
            SimpleFormDialog.this.mFormContainer.requestFocus();
        }
    }

    public static interface InputValidator {
        public String validate(String var1, String var2, @Nullable String var3, @NonNull Bundle var4);
    }

    public class DialogActions
    extends FocusActions {
        private int index;
        private int lastIndex;

        private DialogActions(int index, int lastIndex) {
            this.index = index;
            this.lastIndex = lastIndex;
        }

        public void updatePosButtonState() {
            SimpleFormDialog.this.setPositiveButtonEnabled(SimpleFormDialog.this.posButtonEnabled());
        }

        public boolean isOnlyFocusableElement() {
            return SimpleFormDialog.this.isOnlyFocusableIndex(this.index);
        }

        public boolean isLastFocusableElement() {
            return SimpleFormDialog.this.isLastFocusableIndex(this.index);
        }

        public void continueWithNextElement(boolean mayPressPositiveButtonIfLast) {
            if (mayPressPositiveButtonIfLast && this.isLastFocusableElement()) {
                SimpleFormDialog.this.pressPositiveButton();
            } else {
                SimpleFormDialog.this.requestFocus(SimpleFormDialog.this.getNextFocusableIndex(this.index));
            }
        }

        public void showDialog(SimpleDialog dialog, String tag) {
            dialog.show((Fragment)SimpleFormDialog.this, tag);
        }
    }
}

