/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.form;

import android.content.Context;
import android.os.Bundle;
import android.telephony.PhoneNumberFormattingTextWatcher;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.google.android.material.textfield.TextInputLayout;
import eltos.simpledialogfragment.R;
import eltos.simpledialogfragment.form.FormElementViewHolder;
import eltos.simpledialogfragment.form.Input;
import eltos.simpledialogfragment.form.SimpleFormDialog;
import eltos.simpledialogfragment.input.TextInputAutoCompleteTextView;
import java.util.Arrays;

class InputViewHolder
extends FormElementViewHolder<Input> {
    protected static final String SAVED_TEXT = "savedText";
    private TextInputAutoCompleteTextView input;
    private TextInputLayout inputLayout;

    InputViewHolder(Input field) {
        super(field);
    }

    @Override
    protected int getContentViewLayout() {
        return R.layout.simpledialogfragment_form_item_input;
    }

    @Override
    protected void setUpView(View view, Context context, Bundle savedInstanceState, final SimpleFormDialog.DialogActions actions) {
        Object[] suggestions;
        this.input = (TextInputAutoCompleteTextView)view.findViewById(R.id.editText);
        this.inputLayout = (TextInputLayout)view.findViewById(R.id.inputLayout);
        if (savedInstanceState == null) {
            this.input.setText(((Input)this.field).getText(context));
            this.input.setSelectAllOnFocus(true);
            this.input.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                public void onFocusChange(View v, boolean hasFocus) {
                    if (hasFocus) {
                        InputViewHolder.this.input.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                InputViewHolder.this.input.setSelectAllOnFocus(false);
                                InputViewHolder.this.input.setOnFocusChangeListener(null);
                            }
                        }, 10L);
                    }
                }
            });
        } else {
            this.input.setText(savedInstanceState.getString(SAVED_TEXT));
        }
        this.inputLayout.setHint((CharSequence)((Input)this.field).getHint(context));
        if ((((Input)this.field).inputType & 0xF) == 0) {
            ((Input)this.field).inputType |= 1;
        }
        this.input.setInputType(((Input)this.field).inputType);
        if ((((Input)this.field).inputType & 0xF) == 3) {
            this.input.addTextChangedListener((TextWatcher)new PhoneNumberFormattingTextWatcher());
        }
        if (((Input)this.field).passwordToggleVisible) {
            this.inputLayout.setEndIconMode(1);
        }
        if (((Input)this.field).maxLength > 0) {
            this.inputLayout.setCounterMaxLength(((Input)this.field).maxLength);
            this.inputLayout.setCounterEnabled(true);
        }
        this.input.setImeOptions(actions.isLastFocusableElement() ? 6 : 5);
        this.input.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                switch (actionId) {
                    case 5: {
                        if (((Input)InputViewHolder.this.field).forceSuggestion && InputViewHolder.this.input.isPopupShowing() && InputViewHolder.this.input.getAdapter().getCount() > 0) {
                            InputViewHolder.this.input.setText(InputViewHolder.this.input.getAdapter().getItem(0).toString());
                        }
                    }
                    case 6: {
                        actions.continueWithNextElement(true);
                        return true;
                    }
                }
                return false;
            }
        });
        this.input.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    InputViewHolder.this.validate(v.getContext());
                }
            }
        });
        if (actions.isOnlyFocusableElement()) {
            this.input.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                }

                public void afterTextChanged(Editable s) {
                    actions.updatePosButtonState();
                }
            });
        }
        if ((suggestions = ((Input)this.field).getSuggestions(context)) != null) {
            if (((Input)this.field).isSpinner && !((Input)this.field).required) {
                suggestions = (String[])Arrays.copyOf(suggestions, suggestions.length + 1);
                suggestions[suggestions.length - 1] = "";
            }
            ArrayAdapter adapter = new ArrayAdapter(context, 17367043, suggestions);
            this.input.setAdapter((ListAdapter)adapter);
            this.input.setThreshold(1);
            this.input.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    if (((Input)InputViewHolder.this.field).isSpinner && !((Input)InputViewHolder.this.field).required && position == InputViewHolder.this.input.getAdapter().getCount() - 1) {
                        InputViewHolder.this.input.setText(null);
                    }
                    InputViewHolder.this.validate(view.getContext());
                    actions.updatePosButtonState();
                    actions.continueWithNextElement(true);
                }
            });
            if (((Input)this.field).isSpinner || ((Input)this.field).forceSuggestion && !((Input)this.field).passwordToggleVisible) {
                this.inputLayout.setBoxBackgroundMode(2);
                this.inputLayout.setEndIconMode(3);
            }
            if (((Input)this.field).isSpinner) {
                this.input.setInputType(0);
                this.input.setKeyListener(null);
                this.input.doNotFilter = true;
                this.input.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        actions.hideKeyboard();
                    }
                });
            }
        }
    }

    @Nullable
    protected String getText() {
        return this.input.getText() != null ? this.input.getText().toString().trim() : null;
    }

    private boolean isInputEmpty() {
        return this.getText() == null || this.getText().isEmpty();
    }

    private boolean isLengthExceeded() {
        return ((Input)this.field).maxLength > 0 && this.getText() != null && this.getText().length() > ((Input)this.field).maxLength;
    }

    protected void setError(boolean enabled, @Nullable String error) {
        this.inputLayout.setError((CharSequence)error);
        this.inputLayout.setErrorEnabled(enabled);
    }

    @Override
    protected void saveState(Bundle outState) {
        outState.putString(SAVED_TEXT, this.getText());
    }

    @Override
    protected void putResults(Bundle results, String key) {
        results.putString(key, this.getText());
    }

    @Override
    protected boolean focus(SimpleFormDialog.FocusActions actions) {
        if (((Input)this.field).isSpinner) {
            actions.hideKeyboard();
            this.input.showDropDown();
        } else {
            this.input.post(new Runnable(){

                @Override
                public void run() {
                    InputMethodManager imm = (InputMethodManager)InputViewHolder.this.input.getContext().getSystemService("input_method");
                    if (imm != null) {
                        imm.showSoftInput((View)InputViewHolder.this.input, 1);
                    }
                }
            });
        }
        if (((Input)this.field).forceSuggestion) {
            this.input.showDropDown();
        }
        return this.input.requestFocus();
    }

    @Override
    protected boolean posButtonEnabled(Context context) {
        return (!((Input)this.field).required || !this.isInputEmpty()) && !this.isLengthExceeded();
    }

    @Override
    protected boolean validate(Context context) {
        String error;
        if (((Input)this.field).required && this.isInputEmpty()) {
            this.setError(true, context.getString(R.string.required));
            return false;
        }
        if (this.isLengthExceeded()) {
            this.setError(true, null);
            return false;
        }
        if (this.getText() != null && this.getText().length() < ((Input)this.field).minLength) {
            this.setError(true, context.getResources().getQuantityString(R.plurals.at_least_x_chars, ((Input)this.field).minLength, new Object[]{((Input)this.field).minLength}));
            return false;
        }
        if (((Input)this.field).forceSuggestion && !this.isInputEmpty()) {
            String[] suggestions = ((Input)this.field).getSuggestions(context);
            String text = this.getText();
            boolean match = false;
            if (suggestions != null && text != null && suggestions.length > 0) {
                for (String s : suggestions) {
                    if (s == null || !text.equalsIgnoreCase(s)) continue;
                    match = true;
                    this.input.setTextKeepState(s);
                    break;
                }
                if (!match) {
                    this.setError(true, context.getString(R.string.input_not_a_given_option));
                    return false;
                }
            }
        }
        this.setError((error = ((Input)this.field).validatePattern(context, this.getText())) != null, error);
        return error == null;
    }
}

