/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.list;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.BackgroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Checkable;
import android.widget.Filter;
import android.widget.Filterable;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AdvancedAdapter<T>
extends BaseAdapter
implements Filterable {
    public static final int CHOICE_MODE_NONE = 0;
    public static final int CHOICE_MODE_SINGLE = 1;
    public static final int CHOICE_MODE_MULTIPLE = 2;
    private int mChoiceMode = 2;
    private boolean mNoAnimations = false;
    @ColorInt
    private Integer mDefaultHighlightColor = null;
    private ArrayList<Item> mFilteredItems = new ArrayList();
    private ArrayList<Item> mItems = new ArrayList();
    private CharSequence mFilterConstraint = null;

    public void setData(T[] list) {
        this.setData(new ArrayList<T>(Arrays.asList(list)));
    }

    public void setData(ArrayList<? extends T> list) {
        this.mItems.clear();
        for (T t : list) {
            this.mItems.add(new Item(t));
        }
        this.mFilteredItems = new ArrayList<Item>(this.mItems);
        this.filterItems();
    }

    public void setData(T[] list, ItemIdentifier<T> identifier) {
        this.setData(new ArrayList<T>(Arrays.asList(list)), identifier);
    }

    public void setData(ArrayList<? extends T> list, ItemIdentifier<T> identifier) {
        this.mItems.clear();
        for (T t : list) {
            this.mItems.add(new Item(t, identifier.getIdForItem(t)));
        }
        this.mFilteredItems = new ArrayList<Item>(this.mItems);
        this.filterItems();
    }

    public void setDataAndIds(T[] list, long[] ids) {
        this.mItems.clear();
        ArrayList pairs = new ArrayList(list.length);
        for (int i = 0; i < list.length && i < ids.length; ++i) {
            this.mItems.add(new Item(list[i], ids[i]));
        }
        this.mFilteredItems = new ArrayList<Item>(this.mItems);
        this.filterItems();
    }

    public void setDataAndIds(ArrayList<Pair<T, Long>> list) {
        this.mItems.clear();
        for (Pair<T, Long> pair : list) {
            this.mItems.add(new Item(pair.first, (Long)pair.second));
        }
        this.mFilteredItems = new ArrayList<Item>(this.mItems);
        this.filterItems();
    }

    public ArrayList<T> getData() {
        ArrayList list = new ArrayList(this.mItems.size());
        for (Item item : this.mItems) {
            list.add(item.object);
        }
        return list;
    }

    @Nullable
    public AdvancedFilter getFilter() {
        return null;
    }

    public void setChoiceMode(int choiceMode) {
        this.mChoiceMode = choiceMode;
        if (this.mChoiceMode == 0) {
            this.setAllItemsChecked(false);
        } else if (this.mChoiceMode == 1 && this.getCheckedItemCount() > 1) {
            boolean single = true;
            for (Item item : this.mItems) {
                if (single && item.checked) {
                    single = false;
                    continue;
                }
                item.checked = false;
            }
            this.filterItems();
        }
    }

    public int getCount() {
        return this.mFilteredItems.size();
    }

    public T getItem(int filteredPosition) {
        return this.mFilteredItems.get((int)filteredPosition).object;
    }

    public long getItemId(int filteredPosition) {
        return this.mFilteredItems.get(filteredPosition).getId();
    }

    public void setItemChecked(int filteredPosition, boolean checked) {
        if (this.mChoiceMode != 0) {
            if (checked && this.mChoiceMode == 1) {
                this.setAllItemsChecked(false);
            }
            this.mFilteredItems.get((int)filteredPosition).checked = checked;
        }
    }

    public void toggleChecked(int filteredPosition) {
        if (this.mChoiceMode == 2) {
            this.setItemChecked(filteredPosition, !this.isItemChecked(filteredPosition));
        } else if (this.mChoiceMode == 1) {
            this.setItemChecked(filteredPosition, true);
        }
    }

    public void setAllItemsChecked(boolean checked) {
        if (!checked || this.mChoiceMode == 2) {
            for (Item i : this.mItems) {
                i.checked = checked;
            }
        }
    }

    public void setItemChecked(long id2, boolean checked) {
        if (this.mChoiceMode != 0) {
            if (checked && this.mChoiceMode == 1) {
                this.setAllItemsChecked(false);
            }
            for (Item item : this.mItems) {
                if (item.getId() != id2) continue;
                item.checked = checked;
                break;
            }
        }
    }

    public void setItemsCheckedFromIds(ArrayList<Long> checkedItemIds) {
        for (Item item : this.mItems) {
            item.checked = checkedItemIds.contains(item.getId());
        }
    }

    public void setItemsCheckedFromIds(long[] checkedItemIds) {
        this.setAllItemsChecked(false);
        for (long id2 : checkedItemIds) {
            this.setItemChecked(id2, true);
        }
    }

    public boolean isItemChecked(int filteredPosition) {
        return this.mFilteredItems.get((int)filteredPosition).checked;
    }

    public int getCheckedItemCount() {
        int count = 0;
        for (Item i : this.mItems) {
            if (!i.checked) continue;
            ++count;
        }
        return count;
    }

    public ArrayList<T> getCheckedItems() {
        ArrayList list = new ArrayList(this.getCheckedItemCount());
        for (Item i : this.mItems) {
            if (!i.checked) continue;
            list.add(i.object);
        }
        return list;
    }

    public ArrayList<Integer> getCheckedItemOriginalPositions() {
        ArrayList<Integer> result = new ArrayList<Integer>(this.getCheckedItemCount());
        for (int i = 0; i < this.mItems.size(); ++i) {
            if (!this.mItems.get((int)i).checked) continue;
            result.add(i);
        }
        return result;
    }

    public ArrayList<Long> getCheckedItemIds() {
        ArrayList<Long> result = new ArrayList<Long>(this.getCheckedItemCount());
        for (Item item : this.mItems) {
            if (!item.checked) continue;
            result.add(item.getId());
        }
        return result;
    }

    protected void filterItems() {
        if (this.getFilter() != null) {
            this.getFilter().filter(this.mFilterConstraint);
        }
    }

    protected Spannable highlight(String text, Context context) {
        if (this.mDefaultHighlightColor == null) {
            TypedArray array2 = context.obtainStyledAttributes(new int[]{0x1010099});
            this.mDefaultHighlightColor = array2.getColor(0, 1714664933);
            array2.recycle();
        }
        return this.highlight(text, this.mDefaultHighlightColor);
    }

    protected Spannable highlight(String text, int color2) {
        if (text == null) {
            return null;
        }
        SpannableStringBuilder highlighted = new SpannableStringBuilder((CharSequence)text);
        AdvancedFilter filter = this.getFilter();
        if (filter == null || filter.mPattern == null) {
            return highlighted;
        }
        Matcher matcher = filter.mPattern.matcher(text);
        while (matcher.find()) {
            highlighted.setSpan((Object)new BackgroundColorSpan(color2), matcher.start(), matcher.end(), 33);
        }
        return highlighted;
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.mNoAnimations = false;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView instanceof Checkable) {
            ((Checkable)convertView).setChecked(this.isItemChecked(position));
            if (this.mNoAnimations) {
                convertView.jumpDrawablesToCurrentState();
            }
        }
        return convertView;
    }

    class Item {
        T object;
        Long id = null;
        boolean checked = false;

        Item(T object) {
            this.object = object;
        }

        Item(T object, boolean checked) {
            this(object);
            this.checked = checked;
        }

        Item(T object, Long id2) {
            this(object);
            this.id = id2;
        }

        public Long getId() {
            return this.id != null ? this.id : (long)this.hashCode();
        }
    }

    public static interface ItemIdentifier<Item> {
        @Nullable
        public Long getIdForItem(Item var1);
    }

    public abstract class AdvancedFilter
    extends Filter {
        @Nullable
        private CharSequence mConstraint;
        @Nullable
        private Pattern mPattern;
        private boolean mIgnoreCase = true;
        private boolean mMatchWordBeginning = true;

        public AdvancedFilter() {
            this(true, true);
        }

        public AdvancedFilter(boolean ignoreCase, boolean matchWordBeginning) {
            this.mIgnoreCase = ignoreCase;
            this.mMatchWordBeginning = matchWordBeginning;
        }

        protected boolean isIgnoreCase() {
            return this.mIgnoreCase;
        }

        protected boolean isMatchWordBeginning() {
            return this.mMatchWordBeginning;
        }

        protected abstract boolean matches(T var1, @NonNull CharSequence var2);

        @Deprecated
        protected boolean matchesWord(String string2, @NonNull CharSequence constraint) {
            return string2 != null && Pattern.compile((this.mMatchWordBeginning ? "\\b" : "") + "(" + constraint + ")", this.mIgnoreCase ? 2 : 0).matcher(string2).find();
        }

        protected boolean matches(String string2) {
            return string2 != null && this.mPattern != null && this.mPattern.matcher(string2).find();
        }

        @Nullable
        protected Filter.FilterResults performFiltering(@Nullable CharSequence constraint) {
            this.mConstraint = constraint;
            if (constraint == null || constraint.length() == 0) {
                this.mPattern = null;
                return null;
            }
            this.mPattern = Pattern.compile((this.mMatchWordBeginning ? "\\b" : "") + "(" + this.mConstraint + ")", this.mIgnoreCase ? 2 : 0);
            ArrayList<Item> filteredResults = new ArrayList<Item>();
            for (Item item : AdvancedAdapter.this.mItems) {
                if (!this.matches(item.object, constraint)) continue;
                filteredResults.add(item);
            }
            Filter.FilterResults results = new Filter.FilterResults();
            results.values = filteredResults;
            results.count = filteredResults.size();
            return results;
        }

        protected void publishResults(CharSequence constraint, @Nullable Filter.FilterResults results) {
            AdvancedAdapter.this.mFilterConstraint = constraint;
            AdvancedAdapter.this.mFilteredItems.clear();
            if (results != null && results.values != null) {
                AdvancedAdapter.this.mFilteredItems.addAll((Collection)results.values);
            } else {
                AdvancedAdapter.this.mFilteredItems.addAll(AdvancedAdapter.this.mItems);
            }
            AdvancedAdapter.this.notifyDataSetChanged();
            AdvancedAdapter.this.mNoAnimations = true;
        }
    }
}

