/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment;

import android.content.Context;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.view.View;
import android.widget.TimePicker;
import eltos.simpledialogfragment.CustomViewDialog;

public class SimpleTimeDialog
extends CustomViewDialog<SimpleTimeDialog>
implements TimePicker.OnTimeChangedListener {
    private static final String TAG = "simpleDateDialog";
    public static final String HOUR = "simpleDateDialoghour";
    public static final String MINUTE = "simpleDateDialogminute";
    public static final String VIEW_24_HOUR = "simpleDateDialog24HourView";
    private TimePicker picker;

    public static SimpleTimeDialog build() {
        return new SimpleTimeDialog();
    }

    public SimpleTimeDialog hour(int hour) {
        return (SimpleTimeDialog)((Object)this.setArg(HOUR, hour));
    }

    public SimpleTimeDialog minute(int minute) {
        return (SimpleTimeDialog)((Object)this.setArg(MINUTE, minute));
    }

    public SimpleTimeDialog set24HourView(boolean view24Hour) {
        return (SimpleTimeDialog)((Object)this.setArg(VIEW_24_HOUR, view24Hour));
    }

    @Override
    protected View onCreateContentView(Bundle savedInstanceState) {
        this.picker = new TimePicker(this.getContext());
        if (savedInstanceState != null) {
            this.picker.setCurrentHour(Integer.valueOf(savedInstanceState.getInt(HOUR)));
            this.picker.setCurrentMinute(Integer.valueOf(savedInstanceState.getInt(MINUTE)));
        } else {
            if (this.getArguments().containsKey(HOUR)) {
                this.picker.setCurrentHour(Integer.valueOf(this.getArguments().getInt(HOUR)));
            }
            if (this.getArguments().containsKey(MINUTE)) {
                this.picker.setCurrentMinute(Integer.valueOf(this.getArguments().getInt(MINUTE)));
            }
        }
        if (this.getArguments().containsKey(VIEW_24_HOUR)) {
            this.picker.setIs24HourView(Boolean.valueOf(this.getArguments().getBoolean(VIEW_24_HOUR)));
        } else {
            this.picker.setIs24HourView(Boolean.valueOf(DateFormat.is24HourFormat((Context)this.getContext())));
        }
        this.picker.setOnTimeChangedListener((TimePicker.OnTimeChangedListener)this);
        return this.picker;
    }

    public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(HOUR, this.picker.getCurrentHour().intValue());
        outState.putInt(MINUTE, this.picker.getCurrentMinute().intValue());
        super.onSaveInstanceState(outState);
    }

    @Override
    protected Bundle onResult(int which) {
        Bundle results = new Bundle();
        results.putInt(HOUR, this.picker.getCurrentHour().intValue());
        results.putInt(MINUTE, this.picker.getCurrentMinute().intValue());
        return results;
    }
}

