/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.form;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import eltos.simpledialogfragment.R;
import eltos.simpledialogfragment.form.FormElementViewHolder;
import eltos.simpledialogfragment.form.SimpleFormDialog;
import eltos.simpledialogfragment.form.Spinner;

class SpinnerViewHolder
extends FormElementViewHolder<Spinner> {
    public static final int NONE = -1;
    protected static final String SAVED_POSITION = "pos";
    private android.widget.Spinner spinner;
    private TextView label;
    private CustomSpinnerAdapter adapter;

    SpinnerViewHolder(Spinner field) {
        super(field);
    }

    @Override
    protected int getContentViewLayout() {
        return R.layout.simpledialogfragment_form_item_spinner;
    }

    @Override
    protected void setUpView(View view, Context context, Bundle savedInstanceState, SimpleFormDialog.DialogActions actions, boolean isLastElement, boolean isOnlyElement) {
        this.spinner = (android.widget.Spinner)view.findViewById(R.id.spinner);
        this.label = (TextView)view.findViewById(R.id.label);
        String text = ((Spinner)this.field).getText(context);
        this.label.setText((CharSequence)text);
        this.label.setVisibility(text == null ? 8 : 0);
        String[] items = ((Spinner)this.field).getItems(context);
        if (items != null) {
            this.adapter = new CustomSpinnerAdapter(context, items, !((Spinner)this.field).required, ((Spinner)this.field).getPlaceholderText(context));
            this.spinner.setAdapter((SpinnerAdapter)this.adapter);
            int preset = ((Spinner)this.field).position >= 0 && ((Spinner)this.field).position < items.length ? ((Spinner)this.field).position : -1;
            this.setSelection(preset);
        }
        if (savedInstanceState != null) {
            this.setSelection(savedInstanceState.getInt(SAVED_POSITION));
        }
    }

    @Override
    protected void saveState(Bundle outState) {
        outState.putInt(SAVED_POSITION, this.getSelection());
    }

    @Override
    protected void putResults(Bundle results, String key) {
        results.putInt(key, this.getSelection());
    }

    @Override
    protected boolean focus(SimpleFormDialog.FocusActions actions) {
        actions.hideKeyboard();
        actions.clearCurrentFocus();
        this.spinner.performClick();
        return this.spinner.requestFocus();
    }

    @Override
    protected boolean posButtonEnabled(Context context) {
        return !((Spinner)this.field).required || this.getSelection() != -1;
    }

    @Override
    protected boolean validate(Context context) {
        boolean valid;
        boolean bl = valid = !((Spinner)this.field).required || this.getSelection() != -1;
        if (valid) {
            TypedValue value = new TypedValue();
            this.label.getContext().getTheme().resolveAttribute(16842904, value, true);
            this.label.setTextColor(value.data);
        } else {
            this.label.setTextColor(context.getResources().getColor(R.color.simpledialogfragment_error_color));
        }
        return valid;
    }

    private int getSelection() {
        return this.adapter.mapFromSelection(this.spinner.getSelectedItemPosition());
    }

    private void setSelection(int index) {
        this.spinner.setSelection(this.adapter.mapToSelection(index), false);
    }

    private static class CustomSpinnerAdapter
    extends ArrayAdapter<String> {
        private int emptyIndex;
        private boolean allowEmpty;

        int mapToSelection(int index) {
            return index == -1 ? this.emptyIndex : (index < this.emptyIndex ? index : index + 1);
        }

        int mapFromSelection(int index) {
            return index == this.emptyIndex ? -1 : (index < this.emptyIndex ? index : index - 1);
        }

        CustomSpinnerAdapter(Context context, String[] items, boolean allowEmpty, String emptyString) {
            super(context, 0x1090009);
            this.allowEmpty = allowEmpty;
            if (allowEmpty) {
                this.emptyIndex = 0;
                this.add(emptyString);
                this.addAll(items);
            } else {
                this.addAll(items);
                this.add(emptyString);
                this.emptyIndex = items.length;
            }
        }

        @NonNull
        public View getView(int position, View convertView, @NonNull ViewGroup parent) {
            View view = super.getView(position, convertView, parent);
            if (position == this.emptyIndex) {
                TextView label = (TextView)view.findViewById(16908308);
                label.setText((CharSequence)"");
                label.setHint((CharSequence)this.getItem(position));
            }
            return view;
        }

        public View getDropDownView(int position, View convertView, @NonNull ViewGroup parent) {
            View view = super.getDropDownView(position, convertView, parent);
            if (position == this.emptyIndex) {
                TextView label = (TextView)view.findViewById(16908308);
                label.setText((CharSequence)"");
                label.setHint((CharSequence)this.getItem(position));
            }
            return view;
        }

        public int getCount() {
            return super.getCount() - (this.allowEmpty ? 0 : 1);
        }
    }
}

