/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment;

import android.app.Dialog;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.StyleRes;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import eltos.simpledialogfragment.CustomViewDialog;
import eltos.simpledialogfragment.R;

public class SimpleImageDialog
extends CustomViewDialog<SimpleImageDialog> {
    private static final String TAG = SimpleImageDialog.class.getSimpleName();
    protected static final String DRAWABLE_RESOURCE = TAG + "drawableRes";
    protected static final String BITMAP = TAG + "bitmap";
    protected static final String IMAGE_URI = TAG + "uri";
    protected static final String SCALE_TYPE = TAG + "scale";
    private boolean customTheme = false;

    public SimpleImageDialog() {
        this.pos(null);
    }

    public static SimpleImageDialog build() {
        return new SimpleImageDialog();
    }

    public SimpleImageDialog image(@DrawableRes int resourceId) {
        return (SimpleImageDialog)((Object)this.setArg(DRAWABLE_RESOURCE, resourceId));
    }

    public SimpleImageDialog image(Bitmap image) {
        this.getArguments().putParcelable(BITMAP, (Parcelable)image);
        return this;
    }

    public SimpleImageDialog image(Uri imageUri) {
        this.getArguments().putParcelable(IMAGE_URI, (Parcelable)imageUri);
        return this;
    }

    public SimpleImageDialog scaleType(Scale scale) {
        return (SimpleImageDialog)((Object)this.setArg(SCALE_TYPE, scale.nativeInt));
    }

    @Override
    public SimpleImageDialog theme(@StyleRes int theme) {
        this.customTheme = true;
        return (SimpleImageDialog)((Object)super.theme(theme));
    }

    @Override
    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (!this.customTheme) {
            TypedValue outValue = new TypedValue();
            this.getContext().getTheme().resolveAttribute(R.attr.imageDialogTheme, outValue, true);
            if (outValue.type == 1) {
                this.theme(outValue.resourceId);
            } else {
                this.theme(R.style.ImageDialogTheme);
            }
        }
        return super.onCreateDialog(savedInstanceState);
    }

    @Override
    protected View onCreateContentView(Bundle savedInstanceState) {
        View view;
        int scale = this.getArguments().getInt(SCALE_TYPE, Scale.FIT.nativeInt);
        if (scale == Scale.FIT.nativeInt) {
            view = this.inflate(R.layout.simpledialogfragment_image);
        } else if (scale == Scale.SCROLL_VERTICAL.nativeInt) {
            view = this.inflate(R.layout.simpledialogfragment_image_vert_scroll);
        } else if (scale == Scale.SCROLL_HORIZONTAL.nativeInt) {
            view = this.inflate(R.layout.simpledialogfragment_image_hor_scroll);
        } else {
            return null;
        }
        ImageView imageView = (ImageView)view.findViewById(R.id.image);
        if (this.getArguments().containsKey(IMAGE_URI)) {
            imageView.setImageURI((Uri)this.getArguments().getParcelable(IMAGE_URI));
        }
        if (this.getArguments().containsKey(DRAWABLE_RESOURCE)) {
            imageView.setImageResource(this.getArguments().getInt(DRAWABLE_RESOURCE));
        }
        if (this.getArguments().containsKey(BITMAP)) {
            imageView.setImageBitmap((Bitmap)this.getArguments().getParcelable(BITMAP));
        }
        return view;
    }

    public static enum Scale {
        FIT(3),
        SCROLL_HORIZONTAL(10),
        SCROLL_VERTICAL(11);

        final int nativeInt;

        private Scale(int ni) {
            this.nativeInt = ni;
        }
    }
}

