/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.list;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v4.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import eltos.simpledialogfragment.list.AdvancedAdapter;
import eltos.simpledialogfragment.list.CustomListDialog;
import eltos.simpledialogfragment.list.SimpleListItem;
import java.util.ArrayList;

public class SimpleListDialog
extends CustomListDialog<SimpleListDialog> {
    private static final String DATA_SET = "simpleListDialog.data_set";

    public static SimpleListDialog build() {
        return new SimpleListDialog();
    }

    public SimpleListDialog items(Context context, int[] labelsResourceIds) {
        ArrayList<SimpleListItem> list = new ArrayList<SimpleListItem>(labelsResourceIds.length);
        for (int id2 : labelsResourceIds) {
            list.add(new SimpleListItem(context.getString(id2), id2));
        }
        return this.items(list);
    }

    public SimpleListDialog items(String[] labels) {
        ArrayList<SimpleListItem> list = new ArrayList<SimpleListItem>(labels.length);
        for (String label : labels) {
            list.add(new SimpleListItem(label, label.hashCode()));
        }
        return this.items(list);
    }

    public SimpleListDialog items(String[] labels, long[] ids) {
        if (labels.length != ids.length) {
            throw new IllegalArgumentException("Length of ID-array must match label array length!");
        }
        ArrayList<SimpleListItem> list = new ArrayList<SimpleListItem>(labels.length);
        for (int i = 0; i < labels.length && i < ids.length; ++i) {
            list.add(new SimpleListItem(labels[i], ids[i]));
        }
        return this.items(list);
    }

    public SimpleListDialog items(ArrayList<SimpleListItem> items) {
        this.getArguments().putParcelableArrayList(DATA_SET, items);
        return this;
    }

    @Override
    protected SimpleListAdapter onCreateAdapter() {
        int layout2;
        switch (this.getArguments().getInt("CustomListDialogchoiceMode")) {
            case 1: {
                layout2 = 17367055;
                break;
            }
            case 2: {
                layout2 = 0x1090010;
                break;
            }
            default: {
                layout2 = 17367043;
            }
        }
        ArrayList<SimpleListItem> data = this.getArguments().getParcelableArrayList(DATA_SET);
        if (data == null) {
            data = new ArrayList<SimpleListItem>(0);
        }
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        return new SimpleListAdapter(inflater, layout2, data);
    }

    class SimpleListAdapter
    extends AdvancedAdapter<String> {
        private LayoutInflater mInflater;
        private int mLayout;
        AdvancedAdapter.AdvancedFilter mFilter = new AdvancedAdapter.AdvancedFilter(){

            protected boolean matches(String object, @NonNull CharSequence constraint) {
                return this.matchesWord(object, constraint);
            }
        };

        SimpleListAdapter(@LayoutRes LayoutInflater layoutInflater, int layout2, ArrayList<SimpleListItem> data) {
            this.mInflater = layoutInflater;
            this.mLayout = layout2;
            ArrayList dataAndIds = new ArrayList(data.size());
            for (SimpleListItem simpleListItem : data) {
                dataAndIds.add(new Pair((Object)simpleListItem.getString(), (Object)simpleListItem.getId()));
            }
            this.setDataAndIds(dataAndIds);
        }

        @Override
        public AdvancedAdapter.AdvancedFilter getFilter() {
            return this.mFilter;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            TextView textView;
            if (convertView == null) {
                convertView = this.mInflater.inflate(this.mLayout, parent, false);
                textView = (TextView)convertView.findViewById(16908308);
                convertView.setTag((Object)textView);
            } else {
                textView = (TextView)convertView.getTag();
            }
            textView.setText((CharSequence)this.getItem(position));
            return super.getView(position, convertView, parent);
        }
    }
}

