/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.list;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import eltos.simpledialogfragment.R;

public class ClearableEditText
extends EditText
implements View.OnTouchListener,
View.OnFocusChangeListener {
    private Location loc = Location.RIGHT;
    private Drawable xD;
    private Listener listener;
    private View.OnTouchListener l;
    private View.OnFocusChangeListener f;
    private final TextWatcher mTextWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            if (ClearableEditText.this.isFocused()) {
                ClearableEditText.this.setClearIconVisible(s != null && s.length() > 0);
            }
        }
    };

    public ClearableEditText(Context context) {
        super(context);
        this.init(context, null);
    }

    public ClearableEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ClearableEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setClearPosition(Location loc) {
        this.loc = loc;
    }

    public void setClearDrawable(@DrawableRes int resId) {
        this.xD = this.getResources().getDrawable(resId);
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.l = l;
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener f) {
        this.f = f;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.isClearIconVisible()) {
            boolean tappedX;
            int x = (int)event.getX();
            int y = (int)event.getY();
            int left = this.loc == Location.LEFT ? 0 : this.getWidth() - this.getPaddingRight() - this.xD.getIntrinsicWidth();
            int right = this.loc == Location.LEFT ? this.getPaddingLeft() + this.xD.getIntrinsicWidth() : this.getWidth();
            boolean bl = tappedX = x >= left && x <= right && y >= 0 && y <= this.getBottom() - this.getTop();
            if (tappedX) {
                if (event.getAction() == 1) {
                    this.setText("");
                    if (this.listener != null) {
                        this.listener.didClearText();
                    }
                }
                return true;
            }
        }
        return this.l != null && this.l.onTouch(v, event);
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (hasFocus) {
            this.setClearIconVisible(this.getText() != null && this.getText().length() > 0);
        } else {
            this.setClearIconVisible(false);
        }
        if (this.f != null) {
            this.f.onFocusChange(v, hasFocus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, @Nullable AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ClearableEditText, 0, 0);
        try {
            Integer i = a.getInteger(R.styleable.ClearableEditText_clearPosition, -1);
            if (i == 0) {
                this.loc = Location.LEFT;
            } else if (i == 1) {
                this.loc = Location.RIGHT;
            }
            this.xD = a.getDrawable(R.styleable.ClearableEditText_clearDrawable);
        }
        finally {
            a.recycle();
        }
        if (this.xD == null) {
            this.xD = this.getResources().getDrawable(R.drawable.ic_clear_search);
        }
        if (this.xD != null) {
            this.xD.setBounds(0, 0, this.xD.getIntrinsicWidth(), this.xD.getIntrinsicHeight());
            int min = this.getPaddingTop() + this.xD.getIntrinsicHeight() + this.getPaddingBottom();
            if (this.getSuggestedMinimumHeight() < min) {
                this.setMinimumHeight(min);
            }
        }
        super.setOnTouchListener((View.OnTouchListener)this);
        super.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.addTextChangedListener(this.mTextWatcher);
        this.setClearIconVisible(false);
    }

    private boolean isClearIconVisible() {
        if (this.loc == Location.LEFT) {
            return this.getCompoundDrawables()[0] != null;
        }
        if (this.loc == Location.RIGHT) {
            return this.getCompoundDrawables()[2] != null;
        }
        return false;
    }

    protected void setClearIconVisible(boolean visible) {
        if (visible != this.isClearIconVisible()) {
            super.setCompoundDrawables(visible & this.loc == Location.LEFT ? this.xD : null, null, visible & this.loc == Location.RIGHT ? this.xD : null, null);
        }
    }

    public static interface Listener {
        public void didClearText();
    }

    public static enum Location {
        LEFT(0),
        RIGHT(2);

        final int idx;

        private Location(int idx) {
            this.idx = idx;
        }
    }
}

