/*
 * Decompiled with CFR 0.152.
 */
package xmindjbehave.xmind;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IEncryptionHandler;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbookBuilder;
import org.xmind.core.io.ByteArrayStorage;
import xmindjbehave.xmind.AbstractXMindMojo;
import xmindjbehave.xmind.XMindToSpecsExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXMindToSpecsMojo
extends AbstractXMindMojo
implements XMindToSpecsExtractor {
    String selector;
    @Parameter(defaultValue="${project.build.directory}", property="outputDirRoot", required=true)
    protected File outputDirectoryRoot;
    @Parameter(defaultValue="src\\test\\resources", property="outputDir", required=true)
    protected File outputDirectory;
    @Parameter(property="generateStoriesFromXMind.xmindpath", defaultValue="tests.xmind")
    protected String xmindpath;
    @Parameter(property="hostPortOfTarget", defaultValue="")
    protected String hostPort;

    @Override
    public void extractAll() throws IOException, CoreException {
        String workbookString = this.xmindpath;
        IWorkbookBuilder builder = Core.getWorkbookBuilder();
        ByteArrayStorage ist = new ByteArrayStorage();
        IEncryptionHandler iench = new IEncryptionHandler(){

            public String retrievePassword() throws CoreException {
                return "privet";
            }
        };
        this.wb = builder.loadFromPath(workbookString, ist, iench);
        for (ISheet isheet : this.wb.getSheets()) {
            System.out.println(isheet.getId());
            ITopic root = isheet.getRootTopic();
            this.iterateOverTopic(root, "", this.outputDirectory.getAbsolutePath(), null);
            AbstractXMindToSpecsMojo.cleanupFolders(this.outputDirectory.getAbsolutePath());
        }
    }

    @Override
    public boolean topicOrParentHaveMarker(ITopic itopic, String markers) {
        ITopic parent = itopic.getParent();
        boolean flag = true;
        System.out.println("checking topic " + itopic.getTitleText());
        if (parent == null) {
            System.out.println("parent is null");
            System.out.println("current topic has " + markers + " : " + itopic.hasMarker(markers));
            if (itopic.hasMarker(markers)) {
                return itopic.hasMarker(markers);
            }
        } else {
            if (itopic.hasMarker(markers)) {
                return true;
            }
            return this.topicOrParentHaveMarker(parent, markers);
        }
        return itopic.hasMarker(markers);
    }

    public boolean topicHasMarker(ITopic itopic, String markers) {
        return itopic.hasMarker(markers);
    }

    public static void cleanupFolders(String startingFolder) throws FileNotFoundException {
        File aStartingDir = new File(startingFolder);
        ArrayList<File> emptyFolders = new ArrayList<File>();
        AbstractXMindToSpecsMojo.findEmptyFoldersInDir(aStartingDir, emptyFolders);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File f : emptyFolders) {
            String s = f.getAbsolutePath();
            fileNames.add(s);
        }
        for (File f : emptyFolders) {
            boolean isDeleted = f.delete();
            if (!isDeleted) continue;
            System.out.println(f.getPath() + " deleted");
        }
    }

    public static boolean findEmptyFoldersInDir(File folder, List<File> emptyFolders) {
        boolean isEmpty = false;
        File[] filesAndDirs = folder.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        if (filesDirs.size() == 0) {
            isEmpty = true;
        }
        if (filesDirs.size() > 0) {
            boolean allDirsEmpty = true;
            boolean noFiles = true;
            for (File file : filesDirs) {
                boolean isEmptyChild;
                if (!file.isFile() && !(isEmptyChild = AbstractXMindToSpecsMojo.findEmptyFoldersInDir(file, emptyFolders))) {
                    allDirsEmpty = false;
                }
                if (!file.isFile()) continue;
                noFiles = false;
            }
            if (noFiles && allDirsEmpty) {
                isEmpty = true;
            }
        }
        if (isEmpty) {
            emptyFolders.add(folder);
        }
        return isEmpty;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.extractAll();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

