/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IChecksumStream;
import org.xmind.core.IEncryptionData;
import org.xmind.core.IEncryptionHandler;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.compatibility.Compatibility;
import org.xmind.core.internal.dom.ManifestImpl;
import org.xmind.core.internal.dom.MarkerSheetBuilderImpl;
import org.xmind.core.internal.dom.MarkerSheetImpl;
import org.xmind.core.internal.dom.MetaImpl;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.internal.dom.StyleSheetBuilderImpl;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.internal.dom.WorkbookBuilderImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.dom.WorkbookMarkerResourceProvider;
import org.xmind.core.internal.dom.XMLLoader;
import org.xmind.core.internal.security.Crypto;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyleSheet;

public class WorkbookLoader
extends XMLLoader {
    private WorkbookBuilderImpl builder;
    private IInputSource source;
    private IStorage storage;
    private IEncryptionHandler encryptionHandler;
    private WorkbookImpl workbook = null;
    private Set<String> loadedEntries = new HashSet<String>();
    private ManifestImpl manifest = null;
    private boolean ignoreCopy;
    private String password = null;
    private byte[] byteBuffer = new byte[4096];

    public WorkbookLoader(WorkbookBuilderImpl builder, IInputSource source, IStorage storage, IEncryptionHandler encryptionHandler) throws CoreException {
        this.builder = builder;
        if (source == null && storage != null) {
            source = storage.getInputSource();
            this.ignoreCopy = true;
        } else {
            this.ignoreCopy = false;
        }
        this.source = source;
        this.storage = storage;
        this.encryptionHandler = encryptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWorkbook load() throws IOException, CoreException {
        this.password = null;
        this.manifest = null;
        try {
            this.doLoad();
        }
        finally {
            this.manifest = null;
            this.password = null;
        }
        return this.workbook;
    }

    private void doLoad() throws IOException, CoreException {
        this.loadManifest();
        if (this.loadOldFormat()) {
            return;
        }
        this.loadContents();
        this.loadMeta();
        this.loadStyleSheet();
        this.loadMarkerSheet();
        this.copyOtherStaff();
        this.initWorkbook();
        this.clearEncryptionData();
    }

    private void loadManifest() throws IOException, CoreException {
        Document doc = this.forceLoadXML("META-INF/manifest.xml");
        this.manifest = new ManifestImpl(doc);
    }

    private boolean loadOldFormat() throws IOException, CoreException {
        IWorkbook compatible = Compatibility.loadCompatibleWorkbook(this.source, this, this.storage);
        if (compatible != null) {
            this.workbook = (WorkbookImpl)compatible;
            return true;
        }
        return false;
    }

    private void loadContents() throws IOException, CoreException {
        Document doc = this.loadXMLFile(this.source, "content.xml");
        this.workbook = new WorkbookImpl(doc);
        this.workbook.setManifest(this.manifest);
    }

    private void loadMeta() throws IOException, CoreException {
        Document doc = this.forceLoadXML("meta.xml");
        this.workbook.setMeta(new MetaImpl(doc));
    }

    private void loadStyleSheet() throws IOException, CoreException {
        block3: {
            try {
                IStyleSheet styleSheet = ((StyleSheetBuilderImpl)Core.getStyleSheetBuilder()).loadFromInputSource(this.source, this);
                ((StyleSheetImpl)styleSheet).setManifest(this.manifest);
                this.workbook.setStyleSheet((StyleSheetImpl)styleSheet);
            }
            catch (IOException e) {
                throw e;
            }
            catch (CoreException e) {
                if (e.getType() == 11) break block3;
                throw e;
            }
        }
    }

    private void loadMarkerSheet() throws IOException, CoreException {
        block3: {
            try {
                IMarkerSheet markerSheet = ((MarkerSheetBuilderImpl)Core.getMarkerSheetBuilder()).loadFromInputSource(this.source, this, new WorkbookMarkerResourceProvider(this.workbook));
                this.workbook.setMarkerSheet((MarkerSheetImpl)markerSheet);
            }
            catch (IOException e) {
                throw e;
            }
            catch (CoreException e) {
                if (e.getType() == 11) break block3;
                throw e;
            }
        }
    }

    private void copyOtherStaff() throws IOException, CoreException {
        if (this.ignoreCopy || this.source == null || this.storage == null) {
            return;
        }
        if (!this.source.equals(this.storage.getInputSource())) {
            IOutputTarget target = this.storage.getOutputTarget();
            IManifest manifest = this.workbook.getManifest();
            for (IFileEntry entry : manifest.getFileEntries()) {
                String entryPath;
                if (entry.isDirectory() || !this.shouldLoadEntry(entryPath = entry.getPath())) continue;
                this.copyEntry(this.source, target, entryPath);
                this.markLoaded(entryPath);
            }
        } else {
            this.workbook.getManifest().getFileEntries();
        }
    }

    private boolean shouldLoadEntry(String entryPath) {
        return entryPath != null && !"".equals(entryPath) && !this.hasBeenLoaded(entryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyEntry(IInputSource source, IOutputTarget target, String entryPath) throws IOException, CoreException {
        InputStream in = this.getInputStream(source, entryPath);
        if (in == null) {
            return;
        }
        try {
            long time = source.getEntryTime(entryPath);
            if (time >= 0L) {
                target.setEntryTime(entryPath, time);
            }
            OutputStream out = this.getOutputStream(target, entryPath);
            try {
                int numBytes;
                while ((numBytes = in.read(this.byteBuffer)) > 0) {
                    out.write(this.byteBuffer, 0, numBytes);
                }
                if (!this.verifyChecksum(source, entryPath, in)) {
                    throw new CoreException(17);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    private OutputStream getOutputStream(IOutputTarget target, String entryPath) throws IOException {
        if (!target.isEntryAvaialble(entryPath)) {
            return null;
        }
        return target.openEntryStream(entryPath);
    }

    private void markLoaded(String entryPath) {
        this.loadedEntries.add(entryPath);
    }

    private boolean hasBeenLoaded(String entryPath) {
        return this.loadedEntries.contains(entryPath);
    }

    private void initWorkbook() throws IOException, CoreException {
        if (this.storage != null) {
            this.workbook.setTempStorage(this.storage);
        }
        this.initWorkbookContents(this.workbook);
        this.workbook.setPassword(this.password);
    }

    private void initWorkbookContents(WorkbookImpl workbook) {
        for (ISheet s : workbook.getSheets()) {
            this.initSheet(s, workbook);
        }
    }

    private void initSheet(ISheet sheet, WorkbookImpl wb) {
        ((SheetImpl)sheet).addNotify(wb);
        this.workbook.getRevisionRepository().getRevisionManager(sheet.getId(), "application/vnd.xmind.sheet");
    }

    private void clearEncryptionData() {
        for (IFileEntry entry : this.manifest.getFileEntries()) {
            entry.deleteEncryptionData();
        }
    }

    private Document forceLoadXML(String entryPath) throws IOException, CoreException {
        try {
            return this.loadXMLFile(this.source, entryPath);
        }
        catch (Throwable e) {
            CoreException coreEx;
            if (e instanceof CoreException && ((coreEx = (CoreException)e).getType() == 17 || coreEx.getType() == 100)) {
                throw coreEx;
            }
            Core.getLogger().log(e, "Faild to load " + entryPath);
            return this.createDocument();
        }
    }

    private InputStream getInputStream(IInputSource source, String entryPath) throws CoreException {
        IEncryptionData encData;
        if (!source.hasEntry(entryPath)) {
            return null;
        }
        InputStream in = source.getEntryStream(entryPath);
        if (in == null) {
            return null;
        }
        if (this.manifest != null && (encData = this.manifest.getEncryptionData(entryPath)) != null) {
            in = this.createDecryptedStream(in, encData);
        }
        return in;
    }

    private InputStream createDecryptedStream(InputStream in, IEncryptionData encData) throws CoreException {
        String password = this.getPassword();
        if (password == null) {
            throw new CoreException(100);
        }
        return Crypto.createInputStream(in, false, encData, password);
    }

    private String getPassword() throws CoreException {
        if (this.password == null && this.encryptionHandler != null) {
            this.password = this.encryptionHandler.retrievePassword();
        }
        return this.password;
    }

    protected Document doLoadXMLFile(IInputSource source, String entryPath) throws IOException, CoreException {
        Document doc;
        InputStream stream = this.getInputStream(source, entryPath);
        if (stream == null) {
            throw new CoreException(11, entryPath);
        }
        try {
            doc = this.builder.getDocumentLoader().parse(stream);
        }
        catch (Throwable error) {
            if (!this.verifyChecksum(source, entryPath, stream)) {
                throw new CoreException(17, error);
            }
            if (error instanceof IOException) {
                throw (IOException)error;
            }
            if (error instanceof CoreException) {
                throw (CoreException)error;
            }
            throw new CoreException(13, error);
        }
        finally {
            stream.close();
        }
        if (!this.verifyChecksum(source, entryPath, stream)) {
            throw new CoreException(17);
        }
        this.markLoaded(entryPath);
        return doc;
    }

    private boolean verifyChecksum(IInputSource source, String entryName, InputStream stream) throws IOException, CoreException {
        if (stream instanceof IChecksumStream) {
            String actualChecksum;
            String expectedChecksum;
            if (this.manifest == null) {
                throw new IllegalStateException("Manifest should not be encrypted");
            }
            IEncryptionData encData = this.manifest.getEncryptionData(entryName);
            if (!(encData == null || (expectedChecksum = encData.getChecksum()) == null || (actualChecksum = ((IChecksumStream)((Object)stream)).getChecksum()) != null && expectedChecksum.equals(actualChecksum))) {
                return false;
            }
        }
        return true;
    }

    public Document createDocument() {
        return this.builder.createDocument();
    }
}

