/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.internal.TopicExtensionElement;
import org.xmind.core.internal.dom.TopicExtensionImpl;
import org.xmind.core.internal.dom.TopicImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicExtensionElementImpl
extends TopicExtensionElement {
    private Element implementation;
    private TopicImpl topic;
    private TopicExtensionImpl extension;

    public TopicExtensionElementImpl(Element implementation, TopicImpl topic, TopicExtensionImpl extension) {
        this.implementation = implementation;
        this.topic = topic;
        this.extension = extension;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof TopicExtensionElementImpl)) {
            return false;
        }
        TopicExtensionElementImpl that = (TopicExtensionElementImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return "{element:" + this.getName() + "}";
    }

    @Override
    public String getName() {
        return this.implementation.getTagName();
    }

    @Override
    public ITopicExtensionElement createChild(String elementName) {
        Element childImpl = DOMUtils.createElement(this.implementation, elementName);
        TopicExtensionElementImpl child = new TopicExtensionElementImpl(childImpl, this.topic, this.extension);
        this.registerChild(child);
        this.topic.updateModifiedTime();
        return child;
    }

    private void registerChild(TopicExtensionElementImpl child) {
        this.extension.registerElement(child);
    }

    private void unregisterChild(TopicExtensionElementImpl child) {
        this.extension.unregisterElement(child);
    }

    @Override
    public void addChild(ITopicExtensionElement child, int index) {
        TopicExtensionElementImpl c = (TopicExtensionElementImpl)child;
        if (c.getExtension() != this.getExtension() || c.getTopic() != this.getTopic()) {
            return;
        }
        ITopicExtensionElement oldParent = c.getParent();
        if (oldParent != null) {
            oldParent.deleteChild(child);
        }
        Element childImpl = c.getImplementation();
        Element[] es = DOMUtils.getChildElements(this.implementation);
        if (index >= 0 && index < es.length) {
            this.implementation.insertBefore(childImpl, es[index]);
        } else {
            this.implementation.appendChild(childImpl);
        }
        this.registerChild(c);
        this.topic.updateModifiedTime();
    }

    @Override
    public void deleteChild(ITopicExtensionElement child) {
        TopicExtensionElementImpl c = (TopicExtensionElementImpl)child;
        Element childImpl = c.getImplementation();
        if (childImpl.getParentNode() == this.implementation) {
            this.unregisterChild(c);
            this.implementation.removeChild(childImpl);
            this.topic.updateModifiedTime();
        }
    }

    @Override
    public void deleteChildren(String elementName) {
        Element[] children = elementName == null ? DOMUtils.getChildElements(this.implementation) : DOMUtils.getChildElementsByTag(this.implementation, elementName);
        for (int i = 0; i < children.length; ++i) {
            this.implementation.removeChild(children[i]);
        }
        if (children.length > 0) {
            this.topic.updateModifiedTime();
        }
    }

    @Override
    public void deleteChildren() {
        this.deleteChildren(null);
    }

    @Override
    public String getAttribute(String attrName) {
        return DOMUtils.getAttribute(this.implementation, attrName);
    }

    @Override
    public List<ITopicExtensionElement> getChildren() {
        return DOMUtils.getChildList(this.implementation, null, this.extension);
    }

    @Override
    public ITopicExtensionElement getFirstChild(String elementName) {
        Element childImpl = DOMUtils.getFirstChildElementByTag(this.implementation, elementName);
        return childImpl == null ? null : this.extension.getElement(childImpl);
    }

    @Override
    public List<ITopicExtensionElement> getChildren(String elementName) {
        return DOMUtils.getChildList(this.implementation, elementName, this.extension);
    }

    @Override
    public ITopicExtension getExtension() {
        return this.extension;
    }

    @Override
    public ITopicExtensionElement getParent() {
        Node p = this.implementation.getParentNode();
        if (p == null || !(p instanceof Element)) {
            return null;
        }
        return this.extension.getElement((Element)p);
    }

    @Override
    public String getTextContent() {
        Node c = this.implementation.getFirstChild();
        if (c != null && c.getNodeType() == 3) {
            return c.getTextContent();
        }
        return null;
    }

    @Override
    public ITopic getTopic() {
        return this.topic;
    }

    @Override
    public void setAttribute(String attrName, String attrValue) {
        DOMUtils.setAttribute(this.implementation, attrName, attrValue);
        this.topic.updateModifiedTime();
    }

    @Override
    public void setTextContent(String text) {
        Node c = this.implementation.getFirstChild();
        if (text == null) {
            if (c != null) {
                this.implementation.removeChild(c);
                this.topic.updateModifiedTime();
            }
        } else {
            if (c != null && c.getNodeType() == 3) {
                c.setTextContent(text);
            } else {
                Text t = this.implementation.getOwnerDocument().createTextNode(text);
                this.implementation.insertBefore(t, c);
            }
            this.topic.updateModifiedTime();
        }
    }
}

