/* ******************************************************************************
 * Copyright (c) 2006-2012 XMind Ltd. and others.
 * 
 * This file is a part of XMind 3. XMind releases 3 and
 * above are dual-licensed under the Eclipse Public License (EPL),
 * which is available at http://www.eclipse.org/legal/epl-v10.html
 * and the GNU Lesser General Public License (LGPL), 
 * which is available at http://www.gnu.org/licenses/lgpl.html
 * See http://www.xmind.net/license.html for details.
 * 
 * Contributors:
 *     XMind Ltd. - initial API and implementation
 *******************************************************************************/
package org.xmind.core.internal.dom;

/**
 * @author briansun
 * 
 */
public class DOMConstants {

    // =========================
    //   ATTRIBUTES
    // -------------------------
    public static final String ATTR_HIDDEN = "hidden"; //$NON-NLS-1$
    public static final String ATTR_ALGORITHM_NAME = "algorithm-name"; //$NON-NLS-1$
    public static final String ATTR_ALIGN = "align"; //$NON-NLS-1$
    public static final String ATTR_AMOUNT = "amount"; //$NON-NLS-1$
    public static final String ATTR_ANGLE = "angle"; //$NON-NLS-1$
    public static final String ATTR_ARROW_BEGIN_CLASS = "arrow-begin-class"; //$NON-NLS-1$
    public static final String ATTR_ARROW_END_CLASS = "arrow-end-class"; //$NON-NLS-1$
    public static final String ATTR_BACKGROUND = "background"; //$NON-NLS-1$
    public static final String ATTR_BACKGROUND_COLOR = "fo:background-color"; //$NON-NLS-1$
    public static final String ATTR_BRANCH = "branch"; //$NON-NLS-1$
    public static final String ATTR_CHECKSUM = "checksum";//$NON-NLS-1$
    public static final String ATTR_CHECKSUM_TYPE = "checksum-type";//$NON-NLS-1$
    public static final String ATTR_COLOR = "fo:color"; //$NON-NLS-1$
    public static final String ATTR_DESCRIPTION = "description"; //$NON-NLS-1$
    public static final String ATTR_END1 = "end1"; //$NON-NLS-1$
    public static final String ATTR_END2 = "end2"; //$NON-NLS-1$
    public static final String ATTR_FILL = "svg:fill"; //$NON-NLS-1$
    public static final String ATTR_FONT_DECORATION = "fo:text-decoration"; //$NON-NLS-1$
    public static final String ATTR_FONT_FAMILY = "fo:font-family"; //$NON-NLS-1$
    public static final String ATTR_FONT_SIZE = "fo:font-size"; //$NON-NLS-1$
    public static final String ATTR_FONT_STYLE = "fo:font-style"; //$NON-NLS-1$
    public static final String ATTR_FONT_WEIGHT = "fo:font-weight"; //$NON-NLS-1$
    public static final String ATTR_FULL_PATH = "full-path"; //$NON-NLS-1$
    public static final String ATTR_HEIGHT = "svg:height"; //$NON-NLS-1$
    public static final String ATTR_HREF = "xlink:href"; //$NON-NLS-1$
    public static final String ATTR_ID = "id"; //$NON-NLS-1$
    public static final String ATTR_INDEX = "index"; //$NON-NLS-1$
    public static final String ATTR_ITERATION_COUNT = "iteration-count"; //$NON-NLS-1$
    public static final String ATTR_KEY_DERIVATION_NAME = "key-derivation-name"; //$NON-NLS-1$
    public static final String ATTR_LINE_CLASS = "line-class"; //$NON-NLS-1$
    public static final String ATTR_LINE_COLOR = "line-color"; //$NON-NLS-1$
    public static final String ATTR_LINE_CORNER = "line-corner"; //$NON-NLS-1$
    public static final String ATTR_LINE_PATTERN = "line-pattern"; //$NON-NLS-1$
    public static final String ATTR_LINE_TAPERED = "line-tapered"; //$NON-NLS-1$
    public static final String ATTR_LINE_WIDTH = "line-width"; //$NON-NLS-1$
    public static final String ATTR_MARGIN_BOTTOM = "fo:margin-bottom"; //$NON-NLS-1$
    public static final String ATTR_MARGIN_LEFT = "fo:margin-left"; //$NON-NLS-1$
    public static final String ATTR_MARGIN_RIGHT = "fo:margin-right"; //$NON-NLS-1$
    public static final String ATTR_MARGIN_TOP = "fo:margin-top"; //$NON-NLS-1$
    public static final String ATTR_MARKER_ID = "marker-id"; //$NON-NLS-1$
    public static final String ATTR_MEDIA_TYPE = "media-type"; //$NON-NLS-1$
    public static final String ATTR_MULTI_LINE_COLORS = "multi-line-colors"; //$NON-NLS-1$
    public static final String ATTR_NAME = "name"; //$NON-NLS-1$
    public static final String ATTR_NEXT_REVISION_NUMBER = "next-rev-num"; //$NON-NLS-1$
    public static final String ATTR_NUMBER_FORMAT = "number-format"; //$NON-NLS-1$
    public static final String ATTR_OPACITY = "svg:opacity"; //$NON-NLS-1$
    public static final String ATTR_PREPENDING_NUMBERS = "prepending-numbers"; //$NON-NLS-1$
    public static final String ATTR_PROVIDER = "provider"; //$NON-NLS-1$
    public static final String ATTR_RANGE = "range"; //$NON-NLS-1$
    public static final String ATTR_RESOURCE = "resource"; //$NON-NLS-1$
    public static final String ATTR_RESOURCE_ID = "resource-id"; //$NON-NLS-1$
    public static final String ATTR_RESOURCE_TYPE = "resource-type"; //$NON-NLS-1$
    public static final String ATTR_REVISION_NUMBER = "rev-num"; //$NON-NLS-1$
    public static final String ATTR_SALT = "salt"; //$NON-NLS-1$
    public static final String ATTR_SHAPE_CLASS = "shape-class"; //$NON-NLS-1$
    public static final String ATTR_SHAPE_CORNER = "shape-corner"; //$NON-NLS-1$
    public static final String ATTR_SINGLETON = "singleton"; //$NON-NLS-1$
    public static final String ATTR_SPACING_MAJOR = "spacing-major"; //$NON-NLS-1$
    public static final String ATTR_SPACING_MINOR = "spacing-minor"; //$NON-NLS-1$
    public static final String ATTR_SRC = "xhtml:src"; //$NON-NLS-1$
    public static final String ATTR_STRUCTURE_CLASS = "structure-class"; //$NON-NLS-1$
    public static final String ATTR_STYLE_FAMILY = "style-family"; //$NON-NLS-1$
    public static final String ATTR_STYLE_ID = "style-id"; //$NON-NLS-1$
    public static final String ATTR_TEXT_ALIGN = "fo:text-align"; //$NON-NLS-1$
    public static final String ATTR_TEXT_BULLET = "fo:text-bullet"; //$NON-NLS-1$
    public static final String ATTR_THEME = "theme"; //$NON-NLS-1$
    public static final String ATTR_TIMESTAMP = "timestamp"; //$NON-NLS-1$
    public static final String ATTR_TOPIC_ID = "topic-id"; //$NON-NLS-1$
    public static final String ATTR_TYPE = "type"; //$NON-NLS-1$
    public static final String ATTR_VERSION = "version"; //$NON-NLS-1$
    public static final String ATTR_VISIBILITY = "visibility"; //$NON-NLS-1$
    public static final String ATTR_WIDTH = "svg:width"; //$NON-NLS-1$
    public static final String ATTR_X = "svg:x"; //$NON-NLS-1$
    public static final String ATTR_Y = "svg:y"; //$NON-NLS-1$

    // =========================
    //   TAGS
    // -------------------------
    public static final String TAG_A = "xhtml:a"; //$NON-NLS-1$
    public static final String TAG_ALGORITHM = "algorithm"; //$NON-NLS-1$
    public static final String TAG_AUTOMATIC_STYLES = "automatic-styles"; //$NON-NLS-1$
    public static final String TAG_BOUNDARIES = "boundaries"; //$NON-NLS-1$
    public static final String TAG_BOUNDARY = "boundary"; //$NON-NLS-1$
    public static final String TAG_CHILDREN = "children"; //$NON-NLS-1$
    public static final String TAG_CONTENT = "content"; //$NON-NLS-1$
    public static final String TAG_CONTROL_POINT = "control-point"; //$NON-NLS-1$
    public static final String TAG_CONTROL_POINTS = "control-points"; //$NON-NLS-1$
    public static final String TAG_DEFAULT_STYLE = "default-style"; //$NON-NLS-1$
    public static final String TAG_ENCRYPTION_DATA = "encryption-data"; //$NON-NLS-1$
    public static final String TAG_EXTENSION = "extension"; //$NON-NLS-1$
    public static final String TAG_EXTENSIONS = "extensions"; //$NON-NLS-1$
    public static final String TAG_FILE_ENTRY = "file-entry"; //$NON-NLS-1$
    public static final String TAG_IMG = "xhtml:img"; //$NON-NLS-1$
    public static final String TAG_KEY_DERIVATION = "key-derivation"; //$NON-NLS-1$
    public static final String TAG_LABEL = "label"; //$NON-NLS-1$
    public static final String TAG_LABELS = "labels"; //$NON-NLS-1$
    public static final String TAG_LEGEND = "legend"; //$NON-NLS-1$
    public static final String TAG_MANIFEST = "manifest"; //$NON-NLS-1$
    public static final String TAG_MARKER = "marker"; //$NON-NLS-1$
    public static final String TAG_MARKER_DESCRIPTION = "marker-description"; //$NON-NLS-1$
    public static final String TAG_MARKER_DESCRIPTIONS = "marker-descriptions"; //$NON-NLS-1$
    public static final String TAG_MARKER_GROUP = "marker-group"; //$NON-NLS-1$
    public static final String TAG_MARKER_REF = "marker-ref"; //$NON-NLS-1$
    public static final String TAG_MARKER_REFS = "marker-refs"; //$NON-NLS-1$
    public static final String TAG_MARKER_SHEET = "marker-sheet"; //$NON-NLS-1$
    public static final String TAG_MASTER_STYLES = "master-styles"; //$NON-NLS-1$
    public static final String TAG_META = "meta"; //$NON-NLS-1$
    public static final String TAG_NOTES = "notes"; //$NON-NLS-1$
    public static final String TAG_NUMBERING = "numbering"; //$NON-NLS-1$
    public static final String TAG_P = "xhtml:p"; //$NON-NLS-1$
    public static final String TAG_POSITION = "position"; //$NON-NLS-1$
    public static final String TAG_PREFIX = "prefix"; //$NON-NLS-1$
    public static final String TAG_PROPERTIES = "properties"; //$NON-NLS-1$
    public static final String TAG_RELATIONSHIP = "relationship"; //$NON-NLS-1$
    public static final String TAG_RELATIONSHIPS = "relationships"; //$NON-NLS-1$
    public static final String TAG_RESOURCE_REF = "resource-ref"; //$NON-NLS-1$
    public static final String TAG_RESOURCE_REFS = "resource-refs"; //$NON-NLS-1$
    public static final String TAG_REVISION = "revision"; //$NON-NLS-1$
    public static final String TAG_REVISION_CONTENT = "xmap-revision-content"; //$NON-NLS-1$
    public static final String TAG_REVISIONS = "xmap-revisions"; //$NON-NLS-1$
    public static final String TAG_SHEET = "sheet"; //$NON-NLS-1$
    public static final String TAG_SPAN = "xhtml:span"; //$NON-NLS-1$
    public static final String TAG_STYLE = "style"; //$NON-NLS-1$
    public static final String TAG_STYLE_SHEET = "xmap-styles"; //$NON-NLS-1$
    public static final String TAG_STYLES = "styles"; //$NON-NLS-1$
    public static final String TAG_SUFFIX = "suffix"; //$NON-NLS-1$
    public static final String TAG_SUMMARIES = "summaries"; //$NON-NLS-1$
    public static final String TAG_SUMMARY = "summary"; //$NON-NLS-1$
    public static final String TAG_TITLE = "title"; //$NON-NLS-1$
    public static final String TAG_TOPIC = "topic"; //$NON-NLS-1$
    public static final String TAG_TOPICS = "topics"; //$NON-NLS-1$
    public static final String TAG_WORKBOOK = "xmap-content"; //$NON-NLS-1$

    // ==================
    //   VALUES
    // ------------------

    public static final String VAL_BOLD = "bold"; //$NON-NLS-1$
    public static final String VAL_BOTTOM = "bottom"; //$NON-NLS-1$
    public static final String VAL_BULLET = "bullet"; //$NON-NLS-1$
    public static final String VAL_CENTER = "center"; //$NON-NLS-1$
    public static final String VAL_DEFAULT = "default"; //$NON-NLS-1$
    public static final String VAL_FOLDED = "folded"; //$NON-NLS-1$
    public static final String VAL_HIDDEN = "hidden"; //$NON-NLS-1$
    public static final String VAL_ITALIC = "italic"; //$NON-NLS-1$
    public static final String VAL_LEFT = "left"; //$NON-NLS-1$
    public static final String VAL_LINE_DASH = "dash"; //$NON-NLS-1$
    public static final String VAL_LINE_DASH_DOT = "dash-dot"; //$NON-NLS-1$
    public static final String VAL_LINE_DASH_DOT_DOT = "dash-dot-dot"; //$NON-NLS-1$
    public static final String VAL_LINE_DOT = "dot"; //$NON-NLS-1$
    public static final String VAL_LINE_SOLID = "solid"; //$NON-NLS-1$
    public static final String VAL_LINE_THROUGH = "line-through"; //$NON-NLS-1$
    public static final String VAL_MASTER = "master"; //$NON-NLS-1$
    public static final String VAL_NONE = "none"; //$NON-NLS-1$
    public static final String VAL_NORMAL = "normal"; //$NON-NLS-1$
    public static final String VAL_NUMBER = "number"; //$NON-NLS-1$
    public static final String VAL_RIGHT = "right"; //$NON-NLS-1$
    public static final String VAL_SYSTEM = "$system$"; //$NON-NLS-1$
    public static final String VAL_TAPERED = "tapered"; //$NON-NLS-1$
    public static final String VAL_TOP = "top"; //$NON-NLS-1$
    public static final String VAL_UNDERLINE = "underline"; //$NON-NLS-1$
    public static final String VAL_VISIBLE = "visible"; //$NON-NLS-1$

    @Deprecated
    protected static final String EVENT_SUBTREE_MODIFIED = "DOMSubtreeModified"; //$NON-NLS-1$

}