/*
 * Decompiled with CFR 0.152.
 */
package me.ele.uetool;

import android.content.Context;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.Toast;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import me.ele.uetool.BoardTextView;
import me.ele.uetool.EditAttrLayout;
import me.ele.uetool.GriddingLayout;
import me.ele.uetool.R;
import me.ele.uetool.RelativePositionLayout;
import me.ele.uetool.UETool;
import me.ele.uetool.Util;
import me.ele.uetool.base.DimenUtil;

public class TransparentActivity
extends AppCompatActivity {
    public static final String EXTRA_TYPE = "extra_type";
    private ViewGroup vContainer;
    private int type;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.finish();
            return;
        }
        Util.setStatusBarColor(this.getWindow(), 0);
        Util.enableFullscreen(this.getWindow());
        this.setContentView(R.layout.uet_activity_transparent);
        this.vContainer = (ViewGroup)this.findViewById(R.id.container);
        final BoardTextView board = new BoardTextView((Context)this);
        board.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UETool.getInstance().getTargetActivity().finish();
                TransparentActivity.this.finish();
            }
        });
        this.type = this.getIntent().getIntExtra(EXTRA_TYPE, -1);
        switch (this.type) {
            case 1: {
                EditAttrLayout editAttrLayout = new EditAttrLayout((Context)this);
                editAttrLayout.setOnDragListener(new EditAttrLayout.OnDragListener(){

                    @Override
                    public void showOffset(String offsetContent) {
                        board.updateInfo(offsetContent);
                    }
                });
                this.vContainer.addView((View)editAttrLayout);
                break;
            }
            case 3: {
                this.vContainer.addView((View)new RelativePositionLayout((Context)this));
                break;
            }
            case 2: {
                this.vContainer.addView((View)new GriddingLayout((Context)this));
                board.updateInfo("LINE_INTERVAL: " + DimenUtil.px2dip((float)GriddingLayout.LINE_INTERVAL, (boolean)true));
                break;
            }
            default: {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.uet_coming_soon), (int)0).show();
                this.finish();
            }
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 80;
        this.vContainer.addView((View)board, (ViewGroup.LayoutParams)params);
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    protected void onDestroy() {
        super.onDestroy();
        UETool.getInstance().release();
    }

    protected void onStop() {
        super.onStop();
        this.finish();
    }

    public void dismissAttrsDialog() {
        for (int i = 0; i < this.vContainer.getChildCount(); ++i) {
            View child = this.vContainer.getChildAt(i);
            if (!(child instanceof EditAttrLayout)) continue;
            ((EditAttrLayout)child).dismissAttrsDialog();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
        public static final int TYPE_UNKNOWN = -1;
        public static final int TYPE_EDIT_ATTR = 1;
        public static final int TYPE_SHOW_GRIDDING = 2;
        public static final int TYPE_RELATIVE_POSITION = 3;
    }
}

