/*
 * Decompiled with CFR 0.152.
 */
package me.ele.uetool;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import me.ele.uetool.UETool;
import me.ele.uetool.base.DimenUtil;

public class GriddingLayout
extends View {
    public static final int LINE_INTERVAL = DimenUtil.dip2px((float)5.0f);
    private final int screenWidth = DimenUtil.getScreenWidth();
    private final int screenHeight = DimenUtil.getScreenHeight();
    private Paint paint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setColor(0x30000000);
            this.setStrokeWidth(1.0f);
        }
    };
    private Activity bindActivity = UETool.getInstance().getTargetActivity();

    public GriddingLayout(Context context) {
        super(context);
    }

    public GriddingLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public GriddingLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int startX = 0; startX < this.screenWidth; startX += LINE_INTERVAL) {
            canvas.drawLine((float)startX, 0.0f, (float)startX, (float)this.screenHeight, this.paint);
        }
        for (int startY = 0; startY < this.screenHeight; startY += LINE_INTERVAL) {
            canvas.drawLine(0.0f, (float)startY, (float)this.screenWidth, (float)startY, this.paint);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        this.bindActivity.dispatchTouchEvent(event);
        return super.dispatchTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.bindActivity = null;
    }
}

