/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.exoplayer2.source.hls;

import android.net.Uri;
import android.os.SystemClock;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import buzz.getcoco.exoplayer2.Format;
import buzz.getcoco.exoplayer2.source.BehindLiveWindowException;
import buzz.getcoco.exoplayer2.source.TrackGroup;
import buzz.getcoco.exoplayer2.source.chunk.BaseMediaChunkIterator;
import buzz.getcoco.exoplayer2.source.chunk.Chunk;
import buzz.getcoco.exoplayer2.source.chunk.DataChunk;
import buzz.getcoco.exoplayer2.source.chunk.MediaChunk;
import buzz.getcoco.exoplayer2.source.chunk.MediaChunkIterator;
import buzz.getcoco.exoplayer2.source.hls.FullSegmentEncryptionKeyCache;
import buzz.getcoco.exoplayer2.source.hls.HlsDataSourceFactory;
import buzz.getcoco.exoplayer2.source.hls.HlsExtractorFactory;
import buzz.getcoco.exoplayer2.source.hls.HlsMediaChunk;
import buzz.getcoco.exoplayer2.source.hls.TimestampAdjusterProvider;
import buzz.getcoco.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import buzz.getcoco.exoplayer2.source.hls.playlist.HlsPlaylistTracker;
import buzz.getcoco.exoplayer2.trackselection.BaseTrackSelection;
import buzz.getcoco.exoplayer2.trackselection.ExoTrackSelection;
import buzz.getcoco.exoplayer2.upstream.DataSource;
import buzz.getcoco.exoplayer2.upstream.DataSpec;
import buzz.getcoco.exoplayer2.upstream.TransferListener;
import buzz.getcoco.exoplayer2.util.Assertions;
import buzz.getcoco.exoplayer2.util.UriUtil;
import buzz.getcoco.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

class HlsChunkSource {
    public static final int CHUNK_PUBLICATION_STATE_PRELOAD = 0;
    public static final int CHUNK_PUBLICATION_STATE_PUBLISHED = 1;
    public static final int CHUNK_PUBLICATION_STATE_REMOVED = 2;
    private static final int KEY_CACHE_SIZE = 4;
    private final HlsExtractorFactory extractorFactory;
    private final DataSource mediaDataSource;
    private final DataSource encryptionDataSource;
    private final TimestampAdjusterProvider timestampAdjusterProvider;
    private final Uri[] playlistUrls;
    private final Format[] playlistFormats;
    private final HlsPlaylistTracker playlistTracker;
    private final TrackGroup trackGroup;
    @Nullable
    private final List<Format> muxedCaptionFormats;
    private final FullSegmentEncryptionKeyCache keyCache;
    private boolean isTimestampMaster;
    private byte[] scratchSpace;
    @Nullable
    private IOException fatalError;
    @Nullable
    private Uri expectedPlaylistUrl;
    private boolean independentSegments;
    private ExoTrackSelection trackSelection;
    private long liveEdgeInPeriodTimeUs;
    private boolean seenExpectedPlaylistError;

    public HlsChunkSource(HlsExtractorFactory extractorFactory, HlsPlaylistTracker playlistTracker, Uri[] playlistUrls, Format[] playlistFormats, HlsDataSourceFactory dataSourceFactory, @Nullable TransferListener mediaTransferListener, TimestampAdjusterProvider timestampAdjusterProvider, @Nullable List<Format> muxedCaptionFormats) {
        this.extractorFactory = extractorFactory;
        this.playlistTracker = playlistTracker;
        this.playlistUrls = playlistUrls;
        this.playlistFormats = playlistFormats;
        this.timestampAdjusterProvider = timestampAdjusterProvider;
        this.muxedCaptionFormats = muxedCaptionFormats;
        this.keyCache = new FullSegmentEncryptionKeyCache(4);
        this.scratchSpace = Util.EMPTY_BYTE_ARRAY;
        this.liveEdgeInPeriodTimeUs = -9223372036854775807L;
        this.mediaDataSource = dataSourceFactory.createDataSource(1);
        if (mediaTransferListener != null) {
            this.mediaDataSource.addTransferListener(mediaTransferListener);
        }
        this.encryptionDataSource = dataSourceFactory.createDataSource(3);
        this.trackGroup = new TrackGroup(playlistFormats);
        ArrayList<Integer> initialTrackSelection = new ArrayList<Integer>();
        for (int i = 0; i < playlistUrls.length; ++i) {
            if ((playlistFormats[i].roleFlags & 0x4000) != 0) continue;
            initialTrackSelection.add(i);
        }
        this.trackSelection = new InitializationTrackSelection(this.trackGroup, Ints.toArray(initialTrackSelection));
    }

    public void maybeThrowError() throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
        if (this.expectedPlaylistUrl != null && this.seenExpectedPlaylistError) {
            this.playlistTracker.maybeThrowPlaylistRefreshError(this.expectedPlaylistUrl);
        }
    }

    public TrackGroup getTrackGroup() {
        return this.trackGroup;
    }

    public void setTrackSelection(ExoTrackSelection trackSelection) {
        this.trackSelection = trackSelection;
    }

    public ExoTrackSelection getTrackSelection() {
        return this.trackSelection;
    }

    public void reset() {
        this.fatalError = null;
    }

    public void setIsTimestampMaster(boolean isTimestampMaster) {
        this.isTimestampMaster = isTimestampMaster;
    }

    public int getChunkPublicationState(HlsMediaChunk mediaChunk) {
        List<HlsMediaPlaylist.Part> partsInCurrentPlaylist;
        if (mediaChunk.partIndex == -1) {
            return 1;
        }
        Uri playlistUrl = this.playlistUrls[this.trackGroup.indexOf(mediaChunk.trackFormat)];
        HlsMediaPlaylist mediaPlaylist = (HlsMediaPlaylist)Assertions.checkNotNull((Object)this.playlistTracker.getPlaylistSnapshot(playlistUrl, false));
        int segmentIndexInPlaylist = (int)(mediaChunk.chunkIndex - mediaPlaylist.mediaSequence);
        if (segmentIndexInPlaylist < 0) {
            return 1;
        }
        List<HlsMediaPlaylist.Part> list = partsInCurrentPlaylist = segmentIndexInPlaylist < mediaPlaylist.segments.size() ? mediaPlaylist.segments.get((int)segmentIndexInPlaylist).parts : mediaPlaylist.trailingParts;
        if (mediaChunk.partIndex >= partsInCurrentPlaylist.size()) {
            return 2;
        }
        HlsMediaPlaylist.Part newPart = partsInCurrentPlaylist.get(mediaChunk.partIndex);
        if (newPart.isPreload) {
            return 0;
        }
        Uri newUri = Uri.parse((String)UriUtil.resolve((String)mediaPlaylist.baseUri, (String)newPart.url));
        return Util.areEqual((Object)newUri, (Object)mediaChunk.dataSpec.uri) ? 1 : 2;
    }

    public void getNextChunk(long playbackPositionUs, long loadPositionUs, List<HlsMediaChunk> queue, boolean allowEndOfStream, HlsChunkHolder out) {
        HlsMediaChunk previous = queue.isEmpty() ? null : (HlsMediaChunk)((Object)Iterables.getLast(queue));
        int oldTrackIndex = previous == null ? -1 : this.trackGroup.indexOf(previous.trackFormat);
        long bufferedDurationUs = loadPositionUs - playbackPositionUs;
        long timeToLiveEdgeUs = this.resolveTimeToLiveEdgeUs(playbackPositionUs);
        if (previous != null && !this.independentSegments) {
            long subtractedDurationUs = previous.getDurationUs();
            bufferedDurationUs = Math.max(0L, bufferedDurationUs - subtractedDurationUs);
            if (timeToLiveEdgeUs != -9223372036854775807L) {
                timeToLiveEdgeUs = Math.max(0L, timeToLiveEdgeUs - subtractedDurationUs);
            }
        }
        MediaChunkIterator[] mediaChunkIterators = this.createMediaChunkIterators(previous, loadPositionUs);
        this.trackSelection.updateSelectedTrack(playbackPositionUs, bufferedDurationUs, timeToLiveEdgeUs, queue, mediaChunkIterators);
        int selectedTrackIndex = this.trackSelection.getSelectedIndexInTrackGroup();
        boolean switchingTrack = oldTrackIndex != selectedTrackIndex;
        Uri selectedPlaylistUrl = this.playlistUrls[selectedTrackIndex];
        if (!this.playlistTracker.isSnapshotValid(selectedPlaylistUrl)) {
            out.playlistUrl = selectedPlaylistUrl;
            this.seenExpectedPlaylistError &= selectedPlaylistUrl.equals((Object)this.expectedPlaylistUrl);
            this.expectedPlaylistUrl = selectedPlaylistUrl;
            return;
        }
        HlsMediaPlaylist playlist = this.playlistTracker.getPlaylistSnapshot(selectedPlaylistUrl, true);
        Assertions.checkNotNull((Object)playlist);
        this.independentSegments = playlist.hasIndependentSegments;
        this.updateLiveEdgeTimeUs(playlist);
        long startOfPlaylistInPeriodUs = playlist.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
        Pair<Long, Integer> nextMediaSequenceAndPartIndex = this.getNextMediaSequenceAndPartIndex(previous, switchingTrack, playlist, startOfPlaylistInPeriodUs, loadPositionUs);
        long chunkMediaSequence = (Long)nextMediaSequenceAndPartIndex.first;
        int partIndex = (Integer)nextMediaSequenceAndPartIndex.second;
        if (chunkMediaSequence < playlist.mediaSequence && previous != null && switchingTrack) {
            selectedTrackIndex = oldTrackIndex;
            selectedPlaylistUrl = this.playlistUrls[selectedTrackIndex];
            playlist = this.playlistTracker.getPlaylistSnapshot(selectedPlaylistUrl, true);
            Assertions.checkNotNull((Object)playlist);
            startOfPlaylistInPeriodUs = playlist.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
            Pair<Long, Integer> nextMediaSequenceAndPartIndexWithoutAdapting = this.getNextMediaSequenceAndPartIndex(previous, false, playlist, startOfPlaylistInPeriodUs, loadPositionUs);
            chunkMediaSequence = (Long)nextMediaSequenceAndPartIndexWithoutAdapting.first;
            partIndex = (Integer)nextMediaSequenceAndPartIndexWithoutAdapting.second;
        }
        if (chunkMediaSequence < playlist.mediaSequence) {
            this.fatalError = new BehindLiveWindowException();
            return;
        }
        SegmentBaseHolder segmentBaseHolder = HlsChunkSource.getNextSegmentHolder(playlist, chunkMediaSequence, partIndex);
        if (segmentBaseHolder == null) {
            if (!playlist.hasEndTag) {
                out.playlistUrl = selectedPlaylistUrl;
                this.seenExpectedPlaylistError &= selectedPlaylistUrl.equals((Object)this.expectedPlaylistUrl);
                this.expectedPlaylistUrl = selectedPlaylistUrl;
                return;
            }
            if (allowEndOfStream || playlist.segments.isEmpty()) {
                out.endOfStream = true;
                return;
            }
            segmentBaseHolder = new SegmentBaseHolder((HlsMediaPlaylist.SegmentBase)Iterables.getLast(playlist.segments), playlist.mediaSequence + (long)playlist.segments.size() - 1L, -1);
        }
        this.seenExpectedPlaylistError = false;
        this.expectedPlaylistUrl = null;
        Uri initSegmentKeyUri = HlsChunkSource.getFullEncryptionKeyUri(playlist, segmentBaseHolder.segmentBase.initializationSegment);
        out.chunk = this.maybeCreateEncryptionChunkFor(initSegmentKeyUri, selectedTrackIndex);
        if (out.chunk != null) {
            return;
        }
        Uri mediaSegmentKeyUri = HlsChunkSource.getFullEncryptionKeyUri(playlist, segmentBaseHolder.segmentBase);
        out.chunk = this.maybeCreateEncryptionChunkFor(mediaSegmentKeyUri, selectedTrackIndex);
        if (out.chunk != null) {
            return;
        }
        boolean shouldSpliceIn = HlsMediaChunk.shouldSpliceIn(previous, selectedPlaylistUrl, playlist, segmentBaseHolder, startOfPlaylistInPeriodUs);
        if (shouldSpliceIn && segmentBaseHolder.isPreload) {
            return;
        }
        out.chunk = HlsMediaChunk.createInstance(this.extractorFactory, this.mediaDataSource, this.playlistFormats[selectedTrackIndex], startOfPlaylistInPeriodUs, playlist, segmentBaseHolder, selectedPlaylistUrl, this.muxedCaptionFormats, this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), this.isTimestampMaster, this.timestampAdjusterProvider, previous, this.keyCache.get(mediaSegmentKeyUri), this.keyCache.get(initSegmentKeyUri), shouldSpliceIn);
    }

    @Nullable
    private static SegmentBaseHolder getNextSegmentHolder(HlsMediaPlaylist mediaPlaylist, long nextMediaSequence, int nextPartIndex) {
        int segmentIndexInPlaylist = (int)(nextMediaSequence - mediaPlaylist.mediaSequence);
        if (segmentIndexInPlaylist == mediaPlaylist.segments.size()) {
            int index = nextPartIndex != -1 ? nextPartIndex : 0;
            return index < mediaPlaylist.trailingParts.size() ? new SegmentBaseHolder(mediaPlaylist.trailingParts.get(index), nextMediaSequence, index) : null;
        }
        HlsMediaPlaylist.Segment mediaSegment = mediaPlaylist.segments.get(segmentIndexInPlaylist);
        if (nextPartIndex == -1) {
            return new SegmentBaseHolder(mediaSegment, nextMediaSequence, -1);
        }
        if (nextPartIndex < mediaSegment.parts.size()) {
            return new SegmentBaseHolder(mediaSegment.parts.get(nextPartIndex), nextMediaSequence, nextPartIndex);
        }
        if (segmentIndexInPlaylist + 1 < mediaPlaylist.segments.size()) {
            return new SegmentBaseHolder(mediaPlaylist.segments.get(segmentIndexInPlaylist + 1), nextMediaSequence + 1L, -1);
        }
        if (!mediaPlaylist.trailingParts.isEmpty()) {
            return new SegmentBaseHolder(mediaPlaylist.trailingParts.get(0), nextMediaSequence + 1L, 0);
        }
        return null;
    }

    public void onChunkLoadCompleted(Chunk chunk) {
        if (chunk instanceof EncryptionKeyChunk) {
            EncryptionKeyChunk encryptionKeyChunk = (EncryptionKeyChunk)chunk;
            this.scratchSpace = encryptionKeyChunk.getDataHolder();
            this.keyCache.put(encryptionKeyChunk.dataSpec.uri, (byte[])Assertions.checkNotNull((Object)encryptionKeyChunk.getResult()));
        }
    }

    public boolean maybeExcludeTrack(Chunk chunk, long exclusionDurationMs) {
        return this.trackSelection.blacklist(this.trackSelection.indexOf(this.trackGroup.indexOf(chunk.trackFormat)), exclusionDurationMs);
    }

    public boolean onPlaylistError(Uri playlistUrl, long exclusionDurationMs) {
        int trackGroupIndex = -1;
        for (int i = 0; i < this.playlistUrls.length; ++i) {
            if (!this.playlistUrls[i].equals((Object)playlistUrl)) continue;
            trackGroupIndex = i;
            break;
        }
        if (trackGroupIndex == -1) {
            return true;
        }
        int trackSelectionIndex = this.trackSelection.indexOf(trackGroupIndex);
        if (trackSelectionIndex == -1) {
            return true;
        }
        this.seenExpectedPlaylistError |= playlistUrl.equals((Object)this.expectedPlaylistUrl);
        return exclusionDurationMs == -9223372036854775807L || this.trackSelection.blacklist(trackSelectionIndex, exclusionDurationMs) && this.playlistTracker.excludeMediaPlaylist(playlistUrl, exclusionDurationMs);
    }

    public MediaChunkIterator[] createMediaChunkIterators(@Nullable HlsMediaChunk previous, long loadPositionUs) {
        int oldTrackIndex = previous == null ? -1 : this.trackGroup.indexOf(previous.trackFormat);
        MediaChunkIterator[] chunkIterators = new MediaChunkIterator[this.trackSelection.length()];
        for (int i = 0; i < chunkIterators.length; ++i) {
            int trackIndex = this.trackSelection.getIndexInTrackGroup(i);
            Uri playlistUrl = this.playlistUrls[trackIndex];
            if (!this.playlistTracker.isSnapshotValid(playlistUrl)) {
                chunkIterators[i] = MediaChunkIterator.EMPTY;
                continue;
            }
            HlsMediaPlaylist playlist = this.playlistTracker.getPlaylistSnapshot(playlistUrl, false);
            Assertions.checkNotNull((Object)playlist);
            long startOfPlaylistInPeriodUs = playlist.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
            boolean switchingTrack = trackIndex != oldTrackIndex;
            Pair<Long, Integer> chunkMediaSequenceAndPartIndex = this.getNextMediaSequenceAndPartIndex(previous, switchingTrack, playlist, startOfPlaylistInPeriodUs, loadPositionUs);
            long chunkMediaSequence = (Long)chunkMediaSequenceAndPartIndex.first;
            int partIndex = (Integer)chunkMediaSequenceAndPartIndex.second;
            chunkIterators[i] = new HlsMediaPlaylistSegmentIterator(playlist.baseUri, startOfPlaylistInPeriodUs, HlsChunkSource.getSegmentBaseList(playlist, chunkMediaSequence, partIndex));
        }
        return chunkIterators;
    }

    public int getPreferredQueueSize(long playbackPositionUs, List<? extends MediaChunk> queue) {
        if (this.fatalError != null || this.trackSelection.length() < 2) {
            return queue.size();
        }
        return this.trackSelection.evaluateQueueSize(playbackPositionUs, queue);
    }

    public boolean shouldCancelLoad(long playbackPositionUs, Chunk loadingChunk, List<? extends MediaChunk> queue) {
        if (this.fatalError != null) {
            return false;
        }
        return this.trackSelection.shouldCancelChunkLoad(playbackPositionUs, loadingChunk, queue);
    }

    @VisibleForTesting
    static List<HlsMediaPlaylist.SegmentBase> getSegmentBaseList(HlsMediaPlaylist playlist, long mediaSequence, int partIndex) {
        int firstSegmentIndexInPlaylist = (int)(mediaSequence - playlist.mediaSequence);
        if (firstSegmentIndexInPlaylist < 0 || playlist.segments.size() < firstSegmentIndexInPlaylist) {
            return ImmutableList.of();
        }
        ArrayList<HlsMediaPlaylist.SegmentBase> segmentBases = new ArrayList<HlsMediaPlaylist.SegmentBase>();
        if (firstSegmentIndexInPlaylist < playlist.segments.size()) {
            if (partIndex != -1) {
                HlsMediaPlaylist.Segment firstSegment = playlist.segments.get(firstSegmentIndexInPlaylist);
                if (partIndex == 0) {
                    segmentBases.add(firstSegment);
                } else if (partIndex < firstSegment.parts.size()) {
                    segmentBases.addAll(firstSegment.parts.subList(partIndex, firstSegment.parts.size()));
                }
                ++firstSegmentIndexInPlaylist;
            }
            partIndex = 0;
            segmentBases.addAll(playlist.segments.subList(firstSegmentIndexInPlaylist, playlist.segments.size()));
        }
        if (playlist.partTargetDurationUs != -9223372036854775807L) {
            int n = partIndex = partIndex == -1 ? 0 : partIndex;
            if (partIndex < playlist.trailingParts.size()) {
                segmentBases.addAll(playlist.trailingParts.subList(partIndex, playlist.trailingParts.size()));
            }
        }
        return Collections.unmodifiableList(segmentBases);
    }

    public boolean obtainsChunksForPlaylist(Uri playlistUrl) {
        return Util.contains((Object[])this.playlistUrls, (Object)playlistUrl);
    }

    private Pair<Long, Integer> getNextMediaSequenceAndPartIndex(@Nullable HlsMediaChunk previous, boolean switchingTrack, HlsMediaPlaylist mediaPlaylist, long startOfPlaylistInPeriodUs, long loadPositionUs) {
        if (previous == null || switchingTrack) {
            long targetPositionInPeriodUs;
            long endOfPlaylistInPeriodUs = startOfPlaylistInPeriodUs + mediaPlaylist.durationUs;
            long l = targetPositionInPeriodUs = previous == null || this.independentSegments ? loadPositionUs : previous.startTimeUs;
            if (!mediaPlaylist.hasEndTag && targetPositionInPeriodUs >= endOfPlaylistInPeriodUs) {
                return new Pair((Object)(mediaPlaylist.mediaSequence + (long)mediaPlaylist.segments.size()), (Object)-1);
            }
            long targetPositionInPlaylistUs = targetPositionInPeriodUs - startOfPlaylistInPeriodUs;
            int segmentIndexInPlaylist = Util.binarySearchFloor(mediaPlaylist.segments, (Comparable)Long.valueOf(targetPositionInPlaylistUs), (boolean)true, (!this.playlistTracker.isLive() || previous == null ? 1 : 0) != 0);
            long mediaSequence = (long)segmentIndexInPlaylist + mediaPlaylist.mediaSequence;
            int partIndex = -1;
            if (segmentIndexInPlaylist >= 0) {
                HlsMediaPlaylist.Segment segment = mediaPlaylist.segments.get(segmentIndexInPlaylist);
                List<HlsMediaPlaylist.Part> parts = targetPositionInPlaylistUs < segment.relativeStartTimeUs + segment.durationUs ? segment.parts : mediaPlaylist.trailingParts;
                for (int i = 0; i < parts.size(); ++i) {
                    HlsMediaPlaylist.Part part = parts.get(i);
                    if (targetPositionInPlaylistUs >= part.relativeStartTimeUs + part.durationUs) continue;
                    if (!part.isIndependent) break;
                    partIndex = i;
                    mediaSequence += parts == mediaPlaylist.trailingParts ? 1L : 0L;
                    break;
                }
            }
            return new Pair((Object)mediaSequence, (Object)partIndex);
        }
        return previous.isLoadCompleted() ? new Pair((Object)(previous.partIndex == -1 ? previous.getNextChunkIndex() : previous.chunkIndex), (Object)(previous.partIndex == -1 ? -1 : previous.partIndex + 1)) : new Pair((Object)previous.chunkIndex, (Object)previous.partIndex);
    }

    private long resolveTimeToLiveEdgeUs(long playbackPositionUs) {
        boolean resolveTimeToLiveEdgePossible = this.liveEdgeInPeriodTimeUs != -9223372036854775807L;
        return resolveTimeToLiveEdgePossible ? this.liveEdgeInPeriodTimeUs - playbackPositionUs : -9223372036854775807L;
    }

    private void updateLiveEdgeTimeUs(HlsMediaPlaylist mediaPlaylist) {
        this.liveEdgeInPeriodTimeUs = mediaPlaylist.hasEndTag ? -9223372036854775807L : mediaPlaylist.getEndTimeUs() - this.playlistTracker.getInitialStartTimeUs();
    }

    @Nullable
    private Chunk maybeCreateEncryptionChunkFor(@Nullable Uri keyUri, int selectedTrackIndex) {
        if (keyUri == null) {
            return null;
        }
        byte[] encryptionKey = this.keyCache.remove(keyUri);
        if (encryptionKey != null) {
            this.keyCache.put(keyUri, encryptionKey);
            return null;
        }
        DataSpec dataSpec = new DataSpec.Builder().setUri(keyUri).setFlags(1).build();
        return new EncryptionKeyChunk(this.encryptionDataSource, dataSpec, this.playlistFormats[selectedTrackIndex], this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), this.scratchSpace);
    }

    @Nullable
    private static Uri getFullEncryptionKeyUri(HlsMediaPlaylist playlist, @Nullable HlsMediaPlaylist.SegmentBase segmentBase) {
        if (segmentBase == null || segmentBase.fullSegmentEncryptionKeyUri == null) {
            return null;
        }
        return UriUtil.resolveToUri((String)playlist.baseUri, (String)segmentBase.fullSegmentEncryptionKeyUri);
    }

    @VisibleForTesting
    static final class HlsMediaPlaylistSegmentIterator
    extends BaseMediaChunkIterator {
        private final List<HlsMediaPlaylist.SegmentBase> segmentBases;
        private final long startOfPlaylistInPeriodUs;
        private final String playlistBaseUri;

        public HlsMediaPlaylistSegmentIterator(String playlistBaseUri, long startOfPlaylistInPeriodUs, List<HlsMediaPlaylist.SegmentBase> segmentBases) {
            super(0L, (long)(segmentBases.size() - 1));
            this.playlistBaseUri = playlistBaseUri;
            this.startOfPlaylistInPeriodUs = startOfPlaylistInPeriodUs;
            this.segmentBases = segmentBases;
        }

        public DataSpec getDataSpec() {
            this.checkInBounds();
            HlsMediaPlaylist.SegmentBase segmentBase = this.segmentBases.get((int)this.getCurrentIndex());
            Uri chunkUri = UriUtil.resolveToUri((String)this.playlistBaseUri, (String)segmentBase.url);
            return new DataSpec(chunkUri, segmentBase.byteRangeOffset, segmentBase.byteRangeLength);
        }

        public long getChunkStartTimeUs() {
            this.checkInBounds();
            return this.startOfPlaylistInPeriodUs + this.segmentBases.get((int)((int)this.getCurrentIndex())).relativeStartTimeUs;
        }

        public long getChunkEndTimeUs() {
            this.checkInBounds();
            HlsMediaPlaylist.SegmentBase segmentBase = this.segmentBases.get((int)this.getCurrentIndex());
            long segmentStartTimeInPeriodUs = this.startOfPlaylistInPeriodUs + segmentBase.relativeStartTimeUs;
            return segmentStartTimeInPeriodUs + segmentBase.durationUs;
        }
    }

    private static final class EncryptionKeyChunk
    extends DataChunk {
        private byte @MonotonicNonNull [] result;

        public EncryptionKeyChunk(DataSource dataSource, DataSpec dataSpec, Format trackFormat, int trackSelectionReason, @Nullable Object trackSelectionData, byte[] scratchSpace) {
            super(dataSource, dataSpec, 3, trackFormat, trackSelectionReason, trackSelectionData, scratchSpace);
        }

        protected void consume(byte[] data, int limit) {
            this.result = Arrays.copyOf(data, limit);
        }

        @Nullable
        public byte[] getResult() {
            return this.result;
        }
    }

    private static final class InitializationTrackSelection
    extends BaseTrackSelection {
        private int selectedIndex;

        public InitializationTrackSelection(TrackGroup group, int[] tracks) {
            super(group, tracks);
            this.selectedIndex = this.indexOf(group.getFormat(tracks[0]));
        }

        public void updateSelectedTrack(long playbackPositionUs, long bufferedDurationUs, long availableDurationUs, List<? extends MediaChunk> queue, MediaChunkIterator[] mediaChunkIterators) {
            long nowMs = SystemClock.elapsedRealtime();
            if (!this.isBlacklisted(this.selectedIndex, nowMs)) {
                return;
            }
            for (int i = this.length - 1; i >= 0; --i) {
                if (this.isBlacklisted(i, nowMs)) continue;
                this.selectedIndex = i;
                return;
            }
            throw new IllegalStateException();
        }

        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        public int getSelectionReason() {
            return 0;
        }

        @Nullable
        public Object getSelectionData() {
            return null;
        }
    }

    static final class SegmentBaseHolder {
        public final HlsMediaPlaylist.SegmentBase segmentBase;
        public final long mediaSequence;
        public final int partIndex;
        public final boolean isPreload;

        public SegmentBaseHolder(HlsMediaPlaylist.SegmentBase segmentBase, long mediaSequence, int partIndex) {
            this.segmentBase = segmentBase;
            this.mediaSequence = mediaSequence;
            this.partIndex = partIndex;
            this.isPreload = segmentBase instanceof HlsMediaPlaylist.Part && ((HlsMediaPlaylist.Part)segmentBase).isPreload;
        }
    }

    public static final class HlsChunkHolder {
        @Nullable
        public Chunk chunk;
        public boolean endOfStream;
        @Nullable
        public Uri playlistUrl;

        public HlsChunkHolder() {
            this.clear();
        }

        public void clear() {
            this.chunk = null;
            this.endOfStream = false;
            this.playlistUrl = null;
        }
    }
}

