/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.exoplayer2.util;

import androidx.annotation.GuardedBy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CopyOnWriteMultiset<E>
implements Iterable<E> {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Map<E, Integer> elementCounts = new HashMap<E, Integer>();
    @GuardedBy(value="lock")
    private Set<E> elementSet = Collections.emptySet();
    @GuardedBy(value="lock")
    private List<E> elements = Collections.emptyList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E element) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<E> elements = new ArrayList<E>(this.elements);
            elements.add(element);
            this.elements = Collections.unmodifiableList(elements);
            Integer count = this.elementCounts.get(element);
            if (count == null) {
                HashSet<E> elementSet = new HashSet<E>(this.elementSet);
                elementSet.add(element);
                this.elementSet = Collections.unmodifiableSet(elementSet);
            }
            this.elementCounts.put(element, count != null ? count + 1 : 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(E element) {
        Object object = this.lock;
        synchronized (object) {
            Integer count = this.elementCounts.get(element);
            if (count == null) {
                return;
            }
            ArrayList<E> elements = new ArrayList<E>(this.elements);
            elements.remove(element);
            this.elements = Collections.unmodifiableList(elements);
            if (count == 1) {
                this.elementCounts.remove(element);
                HashSet<E> elementSet = new HashSet<E>(this.elementSet);
                elementSet.remove(element);
                this.elementSet = Collections.unmodifiableSet(elementSet);
            } else {
                this.elementCounts.put(element, count - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<E> elementSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.elementSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Object object = this.lock;
        synchronized (object) {
            return this.elements.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.elementCounts.containsKey(element) ? this.elementCounts.get(element) : 0;
        }
    }
}

