/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.exoplayer2.trackselection;

import android.os.Bundle;
import androidx.annotation.Nullable;
import buzz.getcoco.exoplayer2.Bundleable;
import buzz.getcoco.exoplayer2.source.TrackGroup;
import buzz.getcoco.exoplayer2.util.Assertions;
import buzz.getcoco.exoplayer2.util.BundleableUtil;
import buzz.getcoco.exoplayer2.util.MimeTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class TrackSelectionOverrides
implements Bundleable {
    public static final TrackSelectionOverrides EMPTY = new TrackSelectionOverrides((Map<TrackGroup, TrackSelectionOverride>)ImmutableMap.of());
    private final ImmutableMap<TrackGroup, TrackSelectionOverride> overrides;
    private static final int FIELD_OVERRIDES = 0;
    public static final Bundleable.Creator<TrackSelectionOverrides> CREATOR = bundle -> {
        List<TrackSelectionOverride> trackSelectionOverrides = BundleableUtil.fromBundleNullableList(TrackSelectionOverride.CREATOR, bundle.getParcelableArrayList(TrackSelectionOverrides.keyForField(0)), ImmutableList.of());
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (int i = 0; i < trackSelectionOverrides.size(); ++i) {
            TrackSelectionOverride trackSelectionOverride = trackSelectionOverrides.get(i);
            builder.put((Object)trackSelectionOverride.trackGroup, (Object)trackSelectionOverride);
        }
        return new TrackSelectionOverrides((Map<TrackGroup, TrackSelectionOverride>)builder.build());
    };

    private TrackSelectionOverrides(Map<TrackGroup, TrackSelectionOverride> overrides) {
        this.overrides = ImmutableMap.copyOf(overrides);
    }

    public Builder buildUpon() {
        return new Builder((Map)this.overrides);
    }

    public ImmutableList<TrackSelectionOverride> asList() {
        return ImmutableList.copyOf((Collection)this.overrides.values());
    }

    @Nullable
    public TrackSelectionOverride getOverride(TrackGroup trackGroup) {
        return (TrackSelectionOverride)this.overrides.get((Object)trackGroup);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackSelectionOverrides that = (TrackSelectionOverrides)obj;
        return this.overrides.equals(that.overrides);
    }

    public int hashCode() {
        return this.overrides.hashCode();
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(TrackSelectionOverrides.keyForField(0), BundleableUtil.toBundleArrayList(this.overrides.values()));
        return bundle;
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    public static final class TrackSelectionOverride
    implements Bundleable {
        public final TrackGroup trackGroup;
        public final ImmutableList<Integer> trackIndices;
        private static final int FIELD_TRACK_GROUP = 0;
        private static final int FIELD_TRACKS = 1;
        public static final Bundleable.Creator<TrackSelectionOverride> CREATOR = bundle -> {
            Bundle trackGroupBundle = bundle.getBundle(TrackSelectionOverride.keyForField(0));
            Assertions.checkNotNull(trackGroupBundle);
            TrackGroup trackGroup = TrackGroup.CREATOR.fromBundle(trackGroupBundle);
            int[] tracks = bundle.getIntArray(TrackSelectionOverride.keyForField(1));
            if (tracks == null) {
                return new TrackSelectionOverride(trackGroup);
            }
            return new TrackSelectionOverride(trackGroup, Ints.asList((int[])tracks));
        };

        public TrackSelectionOverride(TrackGroup trackGroup) {
            this.trackGroup = trackGroup;
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (int i = 0; i < trackGroup.length; ++i) {
                builder.add((Object)i);
            }
            this.trackIndices = builder.build();
        }

        public TrackSelectionOverride(TrackGroup trackGroup, List<Integer> trackIndices) {
            if (!(trackIndices.isEmpty() || Collections.min(trackIndices) >= 0 && Collections.max(trackIndices) < trackGroup.length)) {
                throw new IndexOutOfBoundsException();
            }
            this.trackGroup = trackGroup;
            this.trackIndices = ImmutableList.copyOf(trackIndices);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TrackSelectionOverride that = (TrackSelectionOverride)obj;
            return this.trackGroup.equals(that.trackGroup) && this.trackIndices.equals(that.trackIndices);
        }

        public int hashCode() {
            return this.trackGroup.hashCode() + 31 * this.trackIndices.hashCode();
        }

        public int getTrackType() {
            return MimeTypes.getTrackType(this.trackGroup.getFormat((int)0).sampleMimeType);
        }

        @Override
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putBundle(TrackSelectionOverride.keyForField(0), this.trackGroup.toBundle());
            bundle.putIntArray(TrackSelectionOverride.keyForField(1), Ints.toArray(this.trackIndices));
            return bundle;
        }

        private static String keyForField(int field) {
            return Integer.toString(field, 36);
        }
    }

    public static final class Builder {
        private final HashMap<TrackGroup, TrackSelectionOverride> overrides;

        public Builder() {
            this.overrides = new HashMap();
        }

        private Builder(Map<TrackGroup, TrackSelectionOverride> overrides) {
            this.overrides = new HashMap<TrackGroup, TrackSelectionOverride>(overrides);
        }

        public Builder addOverride(TrackSelectionOverride override) {
            this.overrides.put(override.trackGroup, override);
            return this;
        }

        public Builder clearOverride(TrackGroup trackGroup) {
            this.overrides.remove(trackGroup);
            return this;
        }

        public Builder setOverrideForType(TrackSelectionOverride override) {
            this.clearOverridesOfType(override.getTrackType());
            this.overrides.put(override.trackGroup, override);
            return this;
        }

        public Builder clearOverridesOfType(int trackType) {
            Iterator<TrackSelectionOverride> it = this.overrides.values().iterator();
            while (it.hasNext()) {
                TrackSelectionOverride trackSelectionOverride = it.next();
                if (trackSelectionOverride.getTrackType() != trackType) continue;
                it.remove();
            }
            return this;
        }

        public TrackSelectionOverrides build() {
            return new TrackSelectionOverrides(this.overrides);
        }
    }
}

