/*
 * Decompiled with CFR 0.152.
 */
package ru.eldis.toollauncher;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.function.ToIntFunction;
import java.util.spi.ToolProvider;
import java.util.stream.Stream;

public final class ToolLauncher {
    private ToolLauncher() {
    }

    public static void main(String[] stringArray) {
        ToIntFunction<String[]> toIntFunction;
        if (stringArray.length < 2) {
            ToolLauncher.printUsage();
            System.exit(1);
            return;
        }
        switch (stringArray[0]) {
            case "-main": {
                toIntFunction = stringArray2 -> ToolLauncher.runMain(stringArray[1], stringArray2);
                break;
            }
            case "-tool": {
                toIntFunction = stringArray2 -> ToolLauncher.runTool(stringArray[1], stringArray2);
                break;
            }
            default: {
                ToolLauncher.printUsage();
                System.exit(1);
                return;
            }
        }
        String[] stringArray3 = (String[])Arrays.stream(stringArray).skip(2L).flatMap(ToolLauncher::expandArgument).toArray(String[]::new);
        int n = toIntFunction.applyAsInt(stringArray3);
        System.exit(n);
    }

    private static int runMain(String string, String[] stringArray) {
        try {
            Arrays.stream(Class.forName(string).getMethods()).filter(ToolLauncher::isMainMethod).findAny().orElseThrow(() -> new IllegalArgumentException("Class does not have a main method")).invoke(null, new Object[]{stringArray});
            return 0;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    private static int runTool(String string, String[] stringArray) {
        return ToolProvider.findFirst(string).orElseThrow(() -> new IllegalArgumentException("Tool not found")).run(System.out, System.err, stringArray);
    }

    private static void printUsage() {
        System.err.println("Usage:\n  java -jar tool-launcher.jar -main <main class> <args>\n  java -jar tool-launcher.jar -tool <tool name> <args>\n\nLaunch an application or a tool with @argfile support.\n\nOptions:\n  -main       Find and run a main class.\n  -tool       Find and run a ToolProvider (JVM 9+).\n  @<file>     Inject a UTF-8 argfile (one argument per line).\n  \\@<arg>     Pass an argument starting with the '@' character.\n");
    }

    private static boolean isMainMethod(Method method) {
        int n = 9;
        return "main".equals(method.getName()) && (method.getModifiers() & n) == n && method.getTypeParameters().length == 0 && method.getReturnType().equals(Void.TYPE) && Arrays.equals(method.getParameterTypes(), new Class[]{String[].class});
    }

    private static Stream<String> expandArgument(String string) {
        if (string.startsWith("@")) {
            try {
                return Files.lines(Paths.get(string.substring(1), new String[0]));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        if (string.startsWith("\\@")) {
            return Stream.of(string.substring(1));
        }
        return Stream.of(string);
    }
}

