/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.vectors;

import net.sacredlabyrinth.Phaed.PreciousStones.vectors.ChunkVec;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public abstract class AbstractVec {
    private int x;
    private int y;
    private int z;
    private String world;

    public AbstractVec() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.world = "";
    }

    public AbstractVec(int x, int y, int z, String world) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getX() {
        return this.x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getY() {
        return this.y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public int getZ() {
        return this.z;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public String getWorld() {
        return this.world;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractVec)) {
            return false;
        }
        AbstractVec other = (AbstractVec)obj;
        return other.getX() == this.getX() && other.getY() == this.getY() && other.getZ() == this.getZ() && other.getWorld().equals(this.getWorld());
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + this.getX();
        hash = 47 * hash + this.getY();
        hash = 47 * hash + this.getZ();
        hash = 47 * hash + (this.getWorld() != null ? this.getWorld().hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "[" + this.getX() + " " + this.getY() + " " + this.getZ() + " " + this.getWorld() + "]";
    }

    public ChunkVec toChunkVec() {
        return new ChunkVec(this.getX() >> 4, this.getZ() >> 4, this.getWorld());
    }

    public Vec toVec() {
        return new Vec(this);
    }

    public Location getLocation() {
        return new Location(Bukkit.getServer().getWorld(this.getWorld()), (double)this.getX(), (double)this.getY(), (double)this.getZ());
    }

    public Block getBlock() {
        World world = Bukkit.getServer().getWorld(this.getWorld());
        if (world != null) {
            return world.getBlockAt(this.getX(), this.getY(), this.getZ());
        }
        return null;
    }
}

