/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.HashMap;
import java.util.Queue;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.Rollback;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.GriefBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.plugin.Plugin;

public final class GriefUndoManager {
    private PreciousStones plugin;
    private HashMap<Field, Integer> intervalFields = new HashMap();

    public GriefUndoManager() {
        this.plugin = PreciousStones.getInstance();
    }

    public void register(Field field) {
        int taskId;
        if (field.getRevertingModule().getRevertSecs() == 0) {
            return;
        }
        if (this.intervalFields.containsKey(field)) {
            taskId = this.intervalFields.get(field);
            Bukkit.getScheduler().cancelTask(taskId);
        }
        taskId = this.startInterval(field);
        this.intervalFields.put(field, taskId);
    }

    public void remove(Field field) {
        this.intervalFields.remove(field);
    }

    public void addBlock(Field field, BlockState state) {
        GriefBlock gb = new GriefBlock(state);
        field.getRevertingModule().addGriefBlock(gb);
    }

    public void addBlock(Field field, Block block, boolean clear) {
        if (!this.plugin.getSettingsManager().isDependentBlock(block.getType())) {
            BlockFace[] faces;
            PreciousStones.debug("not depenedent", new Object[0]);
            for (BlockFace face : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN}) {
                Block rel = block.getRelative(face);
                if (!this.plugin.getSettingsManager().isDependentBlock(rel.getType())) continue;
                this.addBlock(field, rel, clear);
                PreciousStones.debug("+found dependent", new Object[0]);
            }
        }
        if (block.getType() == Material.OAK_DOOR || block.getType() == Material.IRON_DOOR || block.getType() == Material.IRON_DOOR) {
            field.getRevertingModule().addGriefBlock(new GriefBlock(block));
            Block bottom = block.getRelative(BlockFace.DOWN);
            Block top = block.getRelative(BlockFace.UP);
            if (bottom.getType() == Material.OAK_DOOR || bottom.getType() == Material.IRON_DOOR || bottom.getType() == Material.IRON_DOOR) {
                field.getRevertingModule().addGriefBlock(new GriefBlock(bottom));
                if (clear) {
                    bottom.setType(Material.AIR);
                    block.setType(Material.AIR);
                }
            }
            if (top.getType() == Material.OAK_DOOR || top.getType() == Material.IRON_DOOR || top.getType() == Material.IRON_DOOR) {
                field.getRevertingModule().addGriefBlock(new GriefBlock(top));
                if (clear) {
                    top.setType(Material.AIR);
                    block.setType(Material.AIR);
                }
            }
            return;
        }
        if (block.getState() instanceof Sign) {
            field.getRevertingModule().addGriefBlock(this.handleSign(block));
        } else {
            PreciousStones.debug("added grief to field", new Object[0]);
            field.getRevertingModule().addGriefBlock(new GriefBlock(block));
        }
        if (clear) {
            block.setType(Material.AIR);
        }
    }

    private GriefBlock handleSign(Block block) {
        GriefBlock gb = new GriefBlock(block);
        String signText = "";
        Sign sign = (Sign)block.getState();
        for (String line : sign.getLines()) {
            signText = signText + line + "`";
        }
        signText = Helper.stripTrailing(signText, "`");
        gb.setSignText(signText);
        return gb;
    }

    public int undoGrief(Field field) {
        World world = this.plugin.getServer().getWorld(field.getWorld());
        if (world != null) {
            PreciousStones.debug("Retrieving block grief", new Object[0]);
            Queue<GriefBlock> gbs = this.plugin.getStorageManager().retrieveBlockGrief(field);
            if (!gbs.isEmpty()) {
                PreciousStones.debug("Rolling back %s griefed blocks", gbs.size());
                this.plugin.getCommunicationManager().notifyRollBack(field, gbs.size());
                Rollback rollback = new Rollback(gbs, world, field);
            }
            return gbs.size();
        }
        return 0;
    }

    public int undoDirtyGrief(Field field) {
        World world = this.plugin.getServer().getWorld(field.getWorld());
        if (world != null) {
            PreciousStones.debug("Retrieving dirty grief", new Object[0]);
            Queue<GriefBlock> gbs = field.getRevertingModule().getGrief();
            if (!gbs.isEmpty()) {
                PreciousStones.debug("Rolling back %s dirty griefed blocks", gbs.size());
                this.plugin.getCommunicationManager().notifyRollBack(field, gbs.size());
                Rollback rollback = new Rollback(gbs, world, field);
            }
            return gbs.size();
        }
        return 0;
    }

    public void undoGriefBlock(GriefBlock gb, World world) {
        Material[] seeThrough;
        if (gb == null) {
            return;
        }
        Block block = world.getBlockAt(gb.getX(), gb.getY(), gb.getZ());
        if (block == null) {
            return;
        }
        if (gb.isEmpty()) {
            block.setType(gb.getType(), true);
            return;
        }
        boolean noConflict = false;
        block0: for (Material st : seeThrough = new Material[]{Material.AIR, Material.OAK_SAPLING, Material.WATER, Material.DEAD_BUSH, Material.DEAD_BUSH, Material.DANDELION, Material.POPPY, Material.BROWN_MUSHROOM, Material.RED_MUSHROOM, Material.WATER, Material.LAVA, Material.LAVA, Material.SAND, Material.FIRE, Material.WHEAT, Material.SUGAR_CANE, Material.CACTUS}) {
            if (block.getType() != st) continue;
            noConflict = true;
            if (st != Material.SAND) break;
            for (int count = 1; count < 256; ++count) {
                Material type = world.getBlockAt(gb.getX(), gb.getY() + count, gb.getZ()).getType();
                if (type != Material.AIR && type != Material.WATER && type != Material.WATER && type != Material.LAVA && type != Material.LAVA) continue;
                Block toSand = world.getBlockAt(gb.getX(), gb.getY() + count, gb.getZ());
                toSand.setType(Material.SAND, false);
                break block0;
            }
            break;
        }
        if (noConflict) {
            block.setType(gb.getType(), true);
            if (block.getState() instanceof Sign && gb.getSignText().length() > 0) {
                Sign sign = (Sign)block.getState();
                String[] lines = gb.getSignText().split("[`]");
                for (int i = 0; i < lines.length; ++i) {
                    sign.setLine(i, lines[i]);
                    sign.update();
                }
            }
        }
    }

    private int startInterval(Field field) {
        return Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> this.undoGrief(field), (long)field.getRevertingModule().getRevertSecs() * 20L, (long)field.getRevertingModule().getRevertSecs() * 20L);
    }
}

