/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.entries;

import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;

public class PaymentEntry {
    private String player;
    private BlockTypeEntry item;
    private int amount;
    private String fieldName;

    public PaymentEntry(String player, String fieldName, BlockTypeEntry item, int amount) {
        this.player = player;
        this.item = item;
        this.amount = amount;
        this.fieldName = fieldName;
    }

    public PaymentEntry(String packed) {
        String[] unpacked = packed.split("[|]");
        this.player = unpacked[0];
        this.fieldName = unpacked[1];
        this.amount = Integer.parseInt(unpacked[2]);
        if (packed.length() > 3) {
            this.item = new BlockTypeEntry(unpacked[3]);
        }
    }

    public String toString() {
        if (this.item == null) {
            return this.player + "|" + this.fieldName + "|" + this.amount;
        }
        return this.player + "|" + this.fieldName + "|" + this.amount + "|" + this.item;
    }

    public String getPlayer() {
        return this.player;
    }

    public BlockTypeEntry getItem() {
        return this.item;
    }

    public boolean isItemPayment() {
        return this.item != null;
    }

    public int getAmount() {
        return this.amount;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setPlayer(String player) {
        this.player = player;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }
}

