/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.entries;

import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class BlockEntry {
    private final Material type;
    private final Location location;

    public BlockEntry(Block block) {
        this.type = block.getType();
        this.location = block.getLocation();
    }

    public BlockEntry(Location loc, Material type) {
        this.type = type;
        this.location = loc;
    }

    public Material getType() {
        return this.type;
    }

    public Location getLocation() {
        return this.location;
    }

    public Block getBlock() {
        return this.location.getWorld().getBlockAt(this.location);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockEntry)) {
            return false;
        }
        BlockEntry other = (BlockEntry)obj;
        return other.getType() == this.getType() && Helper.isSameBlock(this.getLocation(), other.getLocation());
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + this.getType().ordinal();
        hash = 47 * hash + this.getLocation().getBlockX() + this.getLocation().getBlockY() + this.getLocation().getBlockZ();
        return hash;
    }

    public String toString() {
        return "[" + this.getType().name() + " " + Helper.toLocationString(this.location) + "]";
    }
}

