/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.blocks;

import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.AbstractVec;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class Unbreakable
extends AbstractVec {
    private String owner;
    private BlockTypeEntry type;
    private boolean dirty;

    public Unbreakable(int x, int y, int z, String world, BlockTypeEntry type, String owner) {
        super(x, y, z, world);
        this.owner = owner;
        this.type = type;
        this.dirty = true;
    }

    public Unbreakable(Block block, String owner) {
        super(block.getX(), block.getY(), block.getZ(), block.getWorld().getName());
        this.owner = owner;
        this.type = new BlockTypeEntry(block.getType());
        this.dirty = true;
    }

    public Unbreakable(Block block) {
        super(block.getX(), block.getY(), block.getZ(), block.getWorld().getName());
        this.type = new BlockTypeEntry(block.getType());
        this.dirty = true;
    }

    public Material getMaterial() {
        return this.type.getMaterial();
    }

    public BlockTypeEntry getTypeEntry() {
        return this.type;
    }

    public String getType() {
        return this.getMaterial().name();
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public boolean isOwner(String playerName) {
        return playerName.equals(this.getOwner());
    }

    @Override
    public String toString() {
        return super.toString() + " [owner:" + this.getOwner() + "]";
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String getDetails() {
        return "[" + this.getType() + "|" + this.getX() + " " + this.getY() + " " + this.getZ() + "]";
    }
}

