/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallNodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.YarnExecutorConfig;
import java.io.File;

final class InstallYarnExecutorConfig
implements YarnExecutorConfig {
    private static final String YARN_WINDOWS = "/node/yarn".concat("/dist/bin/yarn.cmd").replaceAll("/", "\\\\");
    private static final String YARN_DEFAULT = "/node/yarn/dist/bin/yarn";
    private final File nodePath;
    private final InstallConfig installConfig;
    private final boolean isYarnBerry;

    public InstallYarnExecutorConfig(InstallConfig installConfig, boolean isYarnBerry) {
        this.installConfig = installConfig;
        this.nodePath = new InstallNodeExecutorConfig(installConfig).getNodePath();
        this.isYarnBerry = isYarnBerry;
    }

    @Override
    public File getNodePath() {
        return this.nodePath;
    }

    @Override
    public File getYarnPath() {
        String yarnExecutable = this.getPlatform().isWindows() ? YARN_WINDOWS : YARN_DEFAULT;
        return new File(String.valueOf(this.installConfig.getInstallDirectory()) + yarnExecutable);
    }

    @Override
    public File getWorkingDirectory() {
        return this.installConfig.getWorkingDirectory();
    }

    @Override
    public Platform getPlatform() {
        return this.installConfig.getPlatform();
    }

    @Override
    public boolean isYarnBerry() {
        return this.isYarnBerry;
    }
}

