/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.BunExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallNodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import java.io.File;

final class InstallBunExecutorConfig
implements BunExecutorConfig {
    public static final String BUN_WINDOWS = "/bun".replaceAll("/", "\\\\") + "\\bun.exe";
    public static final String BUN_DEFAULT = "/bun/bun";
    private File nodePath;
    private final InstallConfig installConfig;

    public InstallBunExecutorConfig(InstallConfig installConfig) {
        this.installConfig = installConfig;
        this.nodePath = new InstallNodeExecutorConfig(installConfig).getNodePath();
    }

    @Override
    public File getNodePath() {
        return this.nodePath;
    }

    @Override
    public File getBunPath() {
        String bunExecutable = this.getPlatform().isWindows() ? BUN_WINDOWS : BUN_DEFAULT;
        return new File(String.valueOf(this.installConfig.getInstallDirectory()) + bunExecutable);
    }

    @Override
    public File getWorkingDirectory() {
        return this.installConfig.getWorkingDirectory();
    }

    @Override
    public Platform getPlatform() {
        return this.installConfig.getPlatform();
    }
}

