/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.lib.YarnExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.YarnRunner;
import com.github.eirslett.maven.plugins.frontend.lib.YarnTaskExecutor;
import java.util.ArrayList;
import java.util.List;

final class DefaultYarnRunner
extends YarnTaskExecutor
implements YarnRunner {
    private static final String TASK_NAME = "yarn";

    public DefaultYarnRunner(YarnExecutorConfig config, ProxyConfig proxyConfig, String npmRegistryURL) {
        super(config, TASK_NAME, config.getYarnPath().getAbsolutePath(), DefaultYarnRunner.buildArguments(config, proxyConfig, npmRegistryURL));
    }

    private static List<String> buildArguments(YarnExecutorConfig config, ProxyConfig proxyConfig, String npmRegistryURL) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (config.isYarnBerry()) {
            return arguments;
        }
        if (npmRegistryURL != null && !npmRegistryURL.isEmpty()) {
            arguments.add("--registry=" + npmRegistryURL);
        }
        if (!proxyConfig.isEmpty()) {
            ProxyConfig.Proxy proxy = null;
            if (npmRegistryURL != null && !npmRegistryURL.isEmpty()) {
                proxy = proxyConfig.getProxyForUrl(npmRegistryURL);
            }
            if (proxy == null) {
                proxy = proxyConfig.getSecureProxy();
            }
            if (proxy == null) {
                proxy = proxyConfig.getInsecureProxy();
            }
            arguments.add("--https-proxy=" + proxy.getUri().toString());
            arguments.add("--proxy=" + proxy.getUri().toString());
        }
        return arguments;
    }
}

