/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractionException;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricsInstallationWork;
import com.github.eirslett.maven.plugins.frontend.lib.CacheDescriptor;
import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallNodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.Utils;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PnpmInstaller {
    private static final String VERSION = "version";
    public static final String DEFAULT_PNPM_DOWNLOAD_ROOT = "https://registry.npmjs.org/pnpm/-/";
    private static final Object LOCK = new Object();
    private String pnpmVersion;
    private String pnpmDownloadRoot;
    private String userName;
    private String password;
    private Map<String, String> httpHeaders;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InstallConfig config;
    private final ArchiveExtractor archiveExtractor;
    private final FileDownloader fileDownloader;

    PnpmInstaller(InstallConfig config, ArchiveExtractor archiveExtractor, FileDownloader fileDownloader) {
        this.config = config;
        this.archiveExtractor = archiveExtractor;
        this.fileDownloader = fileDownloader;
    }

    public PnpmInstaller setNodeVersion(String nodeVersion) {
        return this;
    }

    public PnpmInstaller setPnpmVersion(String pnpmVersion) {
        this.pnpmVersion = pnpmVersion;
        return this;
    }

    public PnpmInstaller setPnpmDownloadRoot(String pnpmDownloadRoot) {
        this.pnpmDownloadRoot = pnpmDownloadRoot;
        return this;
    }

    public PnpmInstaller setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public PnpmInstaller setPassword(String password) {
        this.password = password;
        return this;
    }

    public PnpmInstaller setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtlassianDevMetricsInstallationWork install() throws InstallationException {
        AtlassianDevMetricsInstallationWork state = AtlassianDevMetricsInstallationWork.INSTALLED;
        Object object = LOCK;
        synchronized (object) {
            if (this.pnpmDownloadRoot == null || this.pnpmDownloadRoot.isEmpty()) {
                this.pnpmDownloadRoot = DEFAULT_PNPM_DOWNLOAD_ROOT;
            }
            if (!this.pnpmIsAlreadyInstalled()) {
                state = this.installPnpm();
            }
            if (this.config.getPlatform().isWindows()) {
                this.linkExecutableWindows();
            } else {
                this.linkExecutable();
            }
        }
        return state;
    }

    private boolean pnpmIsAlreadyInstalled() {
        try {
            File pnpmPackageJson = new File(this.config.getInstallDirectory() + Utils.normalize("/node/node_modules/pnpm/package.json"));
            if (pnpmPackageJson.exists()) {
                HashMap data = (HashMap)new ObjectMapper().readValue(pnpmPackageJson, HashMap.class);
                if (data.containsKey(VERSION)) {
                    String foundPnpmVersion = data.get(VERSION).toString();
                    if (foundPnpmVersion.equals(this.pnpmVersion.replaceFirst("^v", ""))) {
                        this.logger.info("PNPM {} is already installed.", (Object)foundPnpmVersion);
                        return true;
                    }
                    this.logger.info("PNPM {} was installed, but we need version {}", (Object)foundPnpmVersion, (Object)this.pnpmVersion);
                    return false;
                }
                this.logger.info("Could not read PNPM version from package.json");
                return false;
            }
            return false;
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read package.json", ex);
        }
    }

    private AtlassianDevMetricsInstallationWork installPnpm() throws InstallationException {
        try {
            this.logger.info("Installing pnpm version {}", (Object)this.pnpmVersion);
            String pnpmVersionClean = this.pnpmVersion.replaceFirst("^v(?=[0-9]+)", "");
            String downloadUrl = this.pnpmDownloadRoot + "pnpm-" + pnpmVersionClean + ".tgz";
            CacheDescriptor cacheDescriptor = new CacheDescriptor("pnpm", pnpmVersionClean, "tar.gz");
            File archive = this.config.getCacheResolver().resolve(cacheDescriptor);
            AtlassianDevMetricsInstallationWork state = this.downloadFileIfMissing(downloadUrl, archive, this.userName, this.password, this.httpHeaders);
            File installDirectory = this.getNodeInstallDirectory();
            File nodeModulesDirectory = new File(installDirectory, "node_modules");
            File oldNpmDirectory = new File(installDirectory, "pnpm");
            File pnpmDirectory = new File(nodeModulesDirectory, "pnpm");
            try {
                if (oldNpmDirectory.isDirectory()) {
                    FileUtils.deleteDirectory((File)oldNpmDirectory);
                }
                FileUtils.deleteDirectory((File)pnpmDirectory);
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete existing PNPM installation.");
            }
            File packageDirectory = new File(nodeModulesDirectory, "package");
            try {
                this.extractFile(archive, nodeModulesDirectory);
            }
            catch (ArchiveExtractionException e) {
                if (e.getCause() instanceof EOFException) {
                    this.logger.error("The archive file {} is corrupted and will be deleted. Please try the build again.", (Object)archive.getPath());
                    archive.delete();
                    if (packageDirectory.exists()) {
                        FileUtils.deleteDirectory((File)packageDirectory);
                    }
                }
                throw e;
            }
            if (packageDirectory.exists() && !pnpmDirectory.exists() && !packageDirectory.renameTo(pnpmDirectory)) {
                this.logger.warn("Cannot rename PNPM directory, making a copy.");
                FileUtils.copyDirectory((File)packageDirectory, (File)pnpmDirectory);
            }
            this.logger.info("Installed pnpm locally.");
            return state;
        }
        catch (DownloadException e) {
            throw new InstallationException("Could not download pnpm", e);
        }
        catch (ArchiveExtractionException e) {
            throw new InstallationException("Could not extract the pnpm archive", e);
        }
        catch (IOException e) {
            throw new InstallationException("Could not copy pnpm", e);
        }
    }

    private void linkExecutable() throws InstallationException {
        File nodeInstallDirectory = this.getNodeInstallDirectory();
        File pnpmExecutable = new File(nodeInstallDirectory, "pnpm");
        if (pnpmExecutable.exists()) {
            this.logger.info("Existing pnpm executable found, skipping linking.");
            return;
        }
        InstallNodeExecutorConfig executorConfig = new InstallNodeExecutorConfig(this.config);
        File pnpmJsExecutable = executorConfig.getPnpmCjsPath();
        if (!pnpmJsExecutable.exists()) {
            throw new InstallationException("Could not link to pnpm executable, no pnpm installation found.");
        }
        this.logger.info("No pnpm executable found, creating symbolic link to {}.", (Object)pnpmJsExecutable.toPath());
        try {
            Files.createSymbolicLink(pnpmExecutable.toPath(), pnpmJsExecutable.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new InstallationException("Could not create symbolic link for pnpm executable.", e);
        }
    }

    private void linkExecutableWindows() throws InstallationException {
        File nodeInstallDirectory = this.getNodeInstallDirectory();
        File pnpmExecutable = new File(nodeInstallDirectory, "pnpm.cmd");
        if (pnpmExecutable.exists()) {
            this.logger.info("Existing pnpm executable found, skipping linking.");
            return;
        }
        InstallNodeExecutorConfig executorConfig = new InstallNodeExecutorConfig(this.config);
        File pnpmJsExecutable = executorConfig.getPnpmCjsPath();
        if (!pnpmJsExecutable.exists()) {
            throw new InstallationException("Could not link to pnpm executable, no pnpm installation found.");
        }
        this.logger.info("No pnpm executable found, creating proxy script to {}.", (Object)pnpmJsExecutable.toPath());
        Path nodePath = executorConfig.getNodePath().toPath();
        Path relativeNodePath = nodeInstallDirectory.toPath().relativize(nodePath);
        Path relativePnpmPath = nodeInstallDirectory.toPath().relativize(pnpmJsExecutable.toPath());
        String scriptContents = ":: Created by frontend-maven-plugin, please don't edit manually.\r\n" + "@ECHO OFF\r\n" + "\r\n" + "SETLOCAL\r\n" + "\r\n" + String.format("SET \"NODE_EXE=%%~dp0\\%s\"\r\n", relativeNodePath) + String.format("SET \"PNPM_CLI_JS=%%~dp0\\%s\"\r\n", relativePnpmPath) + "\r\n" + "\"%NODE_EXE%\" \"%PNPM_CLI_JS%\" %*";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(pnpmExecutable));
            writer.write(scriptContents);
            writer.close();
        }
        catch (IOException e) {
            throw new InstallationException("Could not create proxy script for pnpm executable.", e);
        }
    }

    private File getNodeInstallDirectory() {
        File installDirectory = new File(this.config.getInstallDirectory(), "/node");
        if (!installDirectory.exists()) {
            this.logger.debug("Creating install directory {}", (Object)installDirectory);
            installDirectory.mkdirs();
        }
        return installDirectory;
    }

    private void extractFile(File archive, File destinationDirectory) throws ArchiveExtractionException {
        this.logger.info("Unpacking {} into {}", (Object)archive, (Object)destinationDirectory);
        this.archiveExtractor.extract(archive.getPath(), destinationDirectory.getPath());
    }

    private AtlassianDevMetricsInstallationWork downloadFileIfMissing(String downloadUrl, File destination, String userName, String password, Map<String, String> httpHeaders) throws DownloadException {
        if (!destination.exists()) {
            this.downloadFile(downloadUrl, destination, userName, password, httpHeaders);
            return AtlassianDevMetricsInstallationWork.DOWNLOADED;
        }
        return AtlassianDevMetricsInstallationWork.CACHED;
    }

    private void downloadFile(String downloadUrl, File destination, String userName, String password, Map<String, String> httpHeaders) throws DownloadException {
        this.logger.info("Downloading {} to {}", (Object)downloadUrl, (Object)destination);
        this.fileDownloader.download(downloadUrl, destination.getPath(), userName, password, httpHeaders);
    }
}

