/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class IncrementalBuildExecutionDigest {
    public static final Long CURRENT_DIGEST_VERSION = 2L;
    private static final String SERIALIZATION_CHARSET = StandardCharsets.UTF_8.toString();
    static final String SERIALIZATION_SEPARATOR = ";";
    public Long digestVersion;
    @JsonDeserialize(keyUsing=ExecutionCoordinatesDeserializer.class)
    @JsonSerialize(keyUsing=ExecutionCoordinatesSerializer.class)
    public Map<ExecutionCoordinates, Execution> executions;

    public IncrementalBuildExecutionDigest() {
    }

    public IncrementalBuildExecutionDigest(Long digestVersion, Map<ExecutionCoordinates, Execution> executions) {
        this.digestVersion = digestVersion;
        this.executions = executions;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IncrementalBuildExecutionDigest)) {
            return false;
        }
        IncrementalBuildExecutionDigest that = (IncrementalBuildExecutionDigest)o;
        return Objects.equals(this.digestVersion, that.digestVersion) && Objects.equals(this.executions, that.executions);
    }

    public int hashCode() {
        return Objects.hash(this.digestVersion, this.executions);
    }

    public static class ExecutionCoordinatesDeserializer
    extends KeyDeserializer {
        public ExecutionCoordinates deserializeKey(String key, DeserializationContext context) throws UnsupportedEncodingException {
            Objects.requireNonNull(key, "ExecutionCoordinates string cannot be null");
            List<String> keyParts = Arrays.asList(key.split(IncrementalBuildExecutionDigest.SERIALIZATION_SEPARATOR));
            if (keyParts.size() != 3) {
                throw new IllegalArgumentException("Supplied ExecutionCoordinates key didn't have three parts, was: " + key);
            }
            ExecutionCoordinates executionCoordinates = new ExecutionCoordinates();
            executionCoordinates.goal = URLDecoder.decode(keyParts.get(0), SERIALIZATION_CHARSET);
            executionCoordinates.id = URLDecoder.decode(keyParts.get(1), SERIALIZATION_CHARSET);
            executionCoordinates.lifecyclePhase = URLDecoder.decode(keyParts.get(2), SERIALIZATION_CHARSET);
            return executionCoordinates;
        }
    }

    public static class ExecutionCoordinatesSerializer
    extends StdSerializer<ExecutionCoordinates> {
        public ExecutionCoordinatesSerializer() {
            super(ExecutionCoordinates.class);
        }

        public void serialize(ExecutionCoordinates value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            String encoded = URLEncoder.encode(value.goal, SERIALIZATION_CHARSET) + IncrementalBuildExecutionDigest.SERIALIZATION_SEPARATOR + URLEncoder.encode(value.id, SERIALIZATION_CHARSET) + IncrementalBuildExecutionDigest.SERIALIZATION_SEPARATOR + URLEncoder.encode(value.lifecyclePhase, SERIALIZATION_CHARSET);
            gen.writeFieldName(encoded);
        }
    }

    public static class Execution {
        public String arguments;
        public Map<String, String> environmentVariables;
        public Set<File> files;
        public Runtime runtime;
        public Long millisecondsSaved = 0L;

        public Execution() {
        }

        public Execution(String arguments, Map<String, String> environmentVariables, Set<File> files, Runtime runtime) {
            this.files = files;
            this.environmentVariables = environmentVariables;
            this.arguments = arguments;
            this.runtime = runtime;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Execution)) {
                return false;
            }
            Execution execution = (Execution)o;
            return Objects.equals(this.files, execution.files) && Objects.equals(this.environmentVariables, execution.environmentVariables) && Objects.equals(this.arguments, execution.arguments) && Objects.equals(this.runtime, execution.runtime) && Objects.equals(this.millisecondsSaved, execution.millisecondsSaved);
        }

        public int hashCode() {
            return Objects.hash(this.files, this.environmentVariables, this.arguments, this.runtime, this.millisecondsSaved);
        }

        public static class Runtime {
            public String runtime;
            public String runtimeVersion;

            public Runtime() {
            }

            public Runtime(String runtime, String runtimeVersion) {
                this.runtime = runtime;
                this.runtimeVersion = runtimeVersion;
            }

            public String toString() {
                return "Runtime{runtime='" + this.runtime + '\'' + ", runtimeVersion='" + this.runtimeVersion + '\'' + '}';
            }

            public boolean equals(Object o) {
                if (!(o instanceof Runtime)) {
                    return false;
                }
                Runtime runtime = (Runtime)o;
                return Objects.equals(this.runtime, runtime.runtime) && Objects.equals(this.runtimeVersion, runtime.runtimeVersion);
            }

            public int hashCode() {
                return Objects.hash(this.runtime, this.runtimeVersion);
            }
        }

        public static class File {
            public String filename;
            public Integer byteLength;
            public String hash;

            public File() {
            }

            public File(String filename, Integer byteLength, String hash) {
                this.filename = filename;
                this.byteLength = byteLength;
                this.hash = hash;
            }

            public String toString() {
                return "File{filename='" + this.filename + '\'' + ", byteLength=" + this.byteLength + ", hash='" + this.hash + '\'' + '}';
            }

            public boolean equals(Object o) {
                if (!(o instanceof File)) {
                    return false;
                }
                File file = (File)o;
                return Objects.equals(this.filename, file.filename) && Objects.equals(this.byteLength, file.byteLength) && Objects.equals(this.hash, file.hash);
            }

            public int hashCode() {
                return Objects.hash(this.filename, this.byteLength, this.hash);
            }
        }
    }

    public static class ExecutionCoordinates {
        public String goal;
        public String id;
        public String lifecyclePhase;

        public ExecutionCoordinates() {
        }

        public ExecutionCoordinates(String goal, String id, String lifecyclePhase) {
            this.goal = goal;
            this.id = id;
            this.lifecyclePhase = lifecyclePhase;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ExecutionCoordinates)) {
                return false;
            }
            ExecutionCoordinates that = (ExecutionCoordinates)o;
            return Objects.equals(this.goal, that.goal) && Objects.equals(this.id, that.id) && Objects.equals(this.lifecyclePhase, that.lifecyclePhase);
        }

        public int hashCode() {
            return Objects.hash(this.goal, this.id, this.lifecyclePhase);
        }
    }
}

