/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib.version.manager.client;

import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.VersionManagerType;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.client.AsdfClient;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.client.FnmClient;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.client.MiseClient;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.client.NvmClient;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.client.NvsClient;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.client.VersionManagerClient;

public class VersionManagerFactory {
    final InstallConfig installConfig;

    public VersionManagerFactory(InstallConfig installConfig) {
        this.installConfig = installConfig;
    }

    public VersionManagerClient getClient(VersionManagerType type) {
        if (type == VersionManagerType.FNM) {
            return new FnmClient(this.installConfig);
        }
        if (type == VersionManagerType.NVM) {
            return new NvmClient(this.installConfig);
        }
        if (type == VersionManagerType.NVS) {
            return new NvsClient(this.installConfig);
        }
        if (type == VersionManagerType.MISE) {
            return new MiseClient(this.installConfig);
        }
        if (type == VersionManagerType.ASDF) {
            return new AsdfClient(this.installConfig);
        }
        throw new RuntimeException(String.format("Version manager (%s) type is not implemented", new Object[]{type}));
    }
}

