/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib.version.manager.client;

import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.client.VersionManagerClient;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvsClient
implements VersionManagerClient {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    final InstallConfig installConfig;

    public NvsClient(InstallConfig installConfig) {
        this.installConfig = installConfig;
    }

    @Override
    public boolean isInstalled() {
        String nvsDir = this.getNvsDir();
        this.logger.debug("Checking if NVS installation directory exists: {}", (Object)nvsDir);
        return nvsDir != null;
    }

    @Override
    public File getNodeExecutable(String nodeVersion) {
        String nvsDir = this.getNvsDir();
        String cleanNodeVersion = nodeVersion.replace("v", "");
        String architecture = this.installConfig.getPlatform().getArchitectureName();
        return Paths.get(nvsDir, "node", cleanNodeVersion, architecture, "bin", "node").toFile();
    }

    @Override
    public File getNpmExecutable(String nodeVersion) {
        File nodeExec = this.getNodeExecutable(nodeVersion);
        return new File(nodeExec.getParent(), "npm");
    }

    private String getNvsDir() {
        Path path;
        Path path2;
        String nvsDir = System.getenv("NVS_DIR");
        if (nvsDir != null && Files.exists(path2 = Paths.get(nvsDir, new String[0]), new LinkOption[0])) {
            return path2.toString();
        }
        String home = System.getenv("HOME");
        if (home != null && Files.exists(path = Paths.get(home, ".nvs"), new LinkOption[0])) {
            return path.toString();
        }
        return null;
    }
}

