/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib.version.manager.client;

import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.client.VersionManagerClient;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvmClient
implements VersionManagerClient {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    final InstallConfig installConfig;

    public NvmClient(InstallConfig installConfig) {
        this.installConfig = installConfig;
    }

    @Override
    public boolean isInstalled() {
        String nvmDir = this.getNvmDir();
        this.logger.debug("Checking if NVM installation directory exists: {}", (Object)nvmDir);
        return nvmDir != null;
    }

    @Override
    public File getNodeExecutable(String nodeVersion) {
        String nvmDir = this.getNvmDir();
        return Paths.get(nvmDir, "versions", "node", nodeVersion, "bin", "node").toFile();
    }

    @Override
    public File getNpmExecutable(String nodeVersion) {
        File nodeExec = this.getNodeExecutable(nodeVersion);
        return new File(nodeExec.getParent(), "npm");
    }

    private String getNvmDir() {
        Path path;
        Path path2;
        Path path3;
        String nvmDir = System.getenv("NVM_DIR");
        if (nvmDir != null && Files.exists(path3 = Paths.get(nvmDir, new String[0]), new LinkOption[0])) {
            return path3.toString();
        }
        String home = System.getenv("HOME");
        if (home != null && Files.exists(path2 = Paths.get(home, ".nvm"), new LinkOption[0])) {
            return path2.toString();
        }
        String xdgConfigHome = System.getenv("XDG_CONFIG_HOME");
        if (xdgConfigHome != null && Files.exists(path = Paths.get(xdgConfigHome, "nvm"), new LinkOption[0])) {
            return path.toString();
        }
        return null;
    }
}

