/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib.version.manager.client;

import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.client.VersionManagerClient;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiseClient
implements VersionManagerClient {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    final InstallConfig installConfig;

    public MiseClient(InstallConfig installConfig) {
        this.installConfig = installConfig;
    }

    @Override
    public boolean isInstalled() {
        String miseDir = this.getMiseDir();
        this.logger.debug("Checking if MISE installation directory exists: {}", (Object)miseDir);
        return miseDir != null;
    }

    @Override
    public File getNodeExecutable(String nodeVersion) {
        String miseNodeDir = this.getMiseDir();
        if (miseNodeDir == null) {
            return null;
        }
        String cleanNodeVersion = nodeVersion.replace("v", "");
        return Paths.get(miseNodeDir, cleanNodeVersion, "bin", "node").toFile();
    }

    @Override
    public File getNpmExecutable(String nodeVersion) {
        File nodeExec = this.getNodeExecutable(nodeVersion);
        return Paths.get(nodeExec.getParentFile().getParent(), "/lib/node_modules/npm/bin/npm-cli.js").toFile();
    }

    private String getMiseDir() {
        Path path;
        Path path2;
        Path path3;
        String miseDataDir = System.getenv("MISE_DATA_DIR");
        if (miseDataDir != null && Files.exists(path3 = Paths.get(miseDataDir, "installs", "node"), new LinkOption[0])) {
            return path3.toString();
        }
        String xdgDataDir = System.getenv("XDG_DATA_HOME");
        if (miseDataDir != null && Files.exists(path2 = Paths.get(xdgDataDir, "mise", "installs", "node"), new LinkOption[0])) {
            return path2.toString();
        }
        String home = System.getenv("HOME");
        if (home != null && Files.exists(path = Paths.get(home, ".local", "share", "mise", "installs", "node"), new LinkOption[0])) {
            return path.toString();
        }
        return null;
    }
}

