/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib.version.manager.client;

import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.client.VersionManagerClient;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FnmClient
implements VersionManagerClient {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    final InstallConfig installConfig;

    public FnmClient(InstallConfig installConfig) {
        this.installConfig = installConfig;
    }

    @Override
    public boolean isInstalled() {
        String fnmDir = this.getFnmDir();
        this.logger.debug("Checking if FNM installation directory exists: {}", (Object)fnmDir);
        return fnmDir != null;
    }

    @Override
    public File getNodeExecutable(String nodeVersion) {
        String nodeVersionWithV = nodeVersion.startsWith("v") ? nodeVersion : String.format("v%s", nodeVersion);
        String fnmDir = this.getFnmDir();
        Platform platform = this.installConfig.getPlatform();
        String architecture = platform.getArchitectureName();
        String osCodename = platform.getCodename();
        String nodeOnPlatform = String.format("node-%s-%s-%s", nodeVersionWithV, osCodename, architecture);
        Path path = Paths.get(fnmDir, "node-versions", nodeVersionWithV, nodeOnPlatform, "bin", "node");
        if (Files.exists(path, new LinkOption[0])) {
            return path.toFile();
        }
        return Paths.get(fnmDir, "node-versions", nodeVersionWithV, "installation", "bin", "node").toFile();
    }

    @Override
    public File getNpmExecutable(String nodeVersion) {
        File nodeExec = this.getNodeExecutable(nodeVersion);
        return new File(nodeExec.getParent(), "npm");
    }

    private String getFnmDir() {
        Path path;
        String xdgDataHome;
        Path path2;
        String fnmDir = System.getenv("FNM_DIR");
        if (fnmDir != null && Files.exists(path2 = Paths.get(fnmDir, new String[0]), new LinkOption[0])) {
            return path2.toString();
        }
        String home = System.getenv("HOME");
        if (home != null) {
            Path path3 = Paths.get(home, ".fnm");
            if (Files.exists(path3, new LinkOption[0])) {
                return path3.toString();
            }
            path3 = Paths.get(home, "Library", "Application Support", "fnm");
            if (Files.exists(path3, new LinkOption[0])) {
                return path3.toString();
            }
            path3 = Paths.get(home, ".local", "share", "fnm");
            if (Files.exists(path3, new LinkOption[0])) {
                return path3.toString();
            }
        }
        if ((xdgDataHome = System.getenv("XDG_DATA_HOME")) != null && Files.exists(path = Paths.get(xdgDataHome, "fnm"), new LinkOption[0])) {
            return path.toString();
        }
        return null;
    }
}

