/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib.version.manager.client;

import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.client.VersionManagerClient;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsdfClient
implements VersionManagerClient {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    final InstallConfig installConfig;

    public AsdfClient(InstallConfig installConfig) {
        this.installConfig = installConfig;
    }

    @Override
    public boolean isInstalled() {
        String asdfDir = this.getAsdfDir();
        this.logger.debug("Checking if ASDF installation directory exists: {}", (Object)asdfDir);
        return asdfDir != null;
    }

    @Override
    public File getNodeExecutable(String nodeVersion) {
        String asdfDir = this.getAsdfDir();
        return Paths.get(asdfDir, "installs", "nodejs", nodeVersion, "bin", "node").toFile();
    }

    @Override
    public File getNpmExecutable(String nodeVersion) {
        File nodeExec = this.getNodeExecutable(nodeVersion);
        return Paths.get(nodeExec.getParent(), "npm").toFile();
    }

    private String getAsdfDir() {
        Path path;
        String asdfDir = System.getenv("ASDF_DIR");
        if (asdfDir != null && Files.exists(path = Paths.get(asdfDir, new String[0]), new LinkOption[0])) {
            return path.toString();
        }
        String home = System.getenv("HOME");
        if (home != null) {
            Path path2 = Paths.get(home, ".asdf");
            if (Files.exists(path2, new LinkOption[0])) {
                return path2.toString();
            }
            path2 = Paths.get(home, ".local", "share", "asdf");
            if (Files.exists(path2, new LinkOption[0])) {
                return path2.toString();
            }
        }
        return null;
    }
}

